/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.uri;

import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.transport.jms.uri.JMSEndpointType;

public class JMSEndpoint
extends JMSEndpointType {
    Map<String, String> jndiParameters = new HashMap<String, String>();
    Map<String, String> parameters = new HashMap<String, String>();

    public JMSEndpoint(String endpointUri, String jmsVariant, String destinationName) {
        this.endpointUri = endpointUri;
        this.jmsVariant = jmsVariant;
        this.destinationName = destinationName;
    }

    public JMSEndpoint() {
        this.jmsVariant = "queue";
    }

    public String getRequestURI() {
        StringBuilder requestUri = new StringBuilder("jms:");
        if (this.jmsVariant == "jndi-topic") {
            requestUri.append("jndi");
        } else {
            requestUri.append(this.jmsVariant);
        }
        requestUri.append(":" + this.destinationName);
        boolean first = true;
        for (String key : this.parameters.keySet()) {
            if ("targetService".equals(key) || "messageType".equals(key)) continue;
            String value = this.parameters.get(key);
            if (first) {
                requestUri.append("?" + key + "=" + value);
                first = false;
                continue;
            }
            requestUri.append("&" + key + "=" + value);
        }
        return requestUri.toString();
    }

    public void putJndiParameter(String key, String value) {
        this.jndiParameters.put(key, value);
    }

    public void putParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public Map<String, String> getJndiParameters() {
        return this.jndiParameters;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }
}

