/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jibx;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jibx.runtime.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JibxSimpleTypes {
    public static final String SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final QName STRING_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "string");
    private static Map<String, QName> simpleObjectTypeMap = new HashMap<String, QName>();
    private static Map<String, QName> simplePrimitiveTypeMap = new HashMap<String, QName>();
    private static Map<String, Class<?>> simpleWrapperMap = new HashMap();
    private static Map<QName, Format> simpleTypeMap = new HashMap<QName, Format>();
    private static final Class<Utility> UTILITY = Utility.class;
    private static final Class<String> INPUT_TYPE = String.class;

    private JibxSimpleTypes() {
    }

    private static void buildFormat(String stype, String jtype, String sname, String dname, String dflt, Map<QName, Format> map) {
        Format format = new Format();
        format.setTypeName(jtype);
        format.setSerializeMethod(sname);
        format.setDeserializeMethod(dname);
        format.setDefaultValue(dflt);
        map.put(new QName(SCHEMA_NAMESPACE, stype), format);
    }

    public static Format getFormatElement(QName type) {
        return simpleTypeMap.get(type);
    }

    public static Object toObject(String text, QName stype) {
        String deserializerMethod;
        Format format = simpleTypeMap.get(stype);
        if (format != null && (deserializerMethod = format.getDeserializeMethod()) != null) {
            try {
                if (text == null) {
                    text = format.getDefaultValue();
                }
                Method method = UTILITY.getMethod(deserializerMethod, INPUT_TYPE);
                return method.invoke(null, text);
            }
            catch (Exception e) {
                throw new RuntimeException("", e);
            }
        }
        return text;
    }

    public static String toText(QName schemaType, Object value) {
        String serializeMethod;
        Format format = simpleTypeMap.get(schemaType);
        if (format != null && (serializeMethod = format.getSerializeMethod()) != null) {
            Class[] classArray;
            String jtype = format.getTypeName();
            if (JibxSimpleTypes.isPrimitiveType(jtype)) {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = JibxSimpleTypes.primitiveType(jtype);
            } else {
                Class[] classArray3 = new Class[1];
                classArray = classArray3;
                classArray3[0] = value.getClass();
            }
            Class[] paraTypes = classArray;
            try {
                Method method = UTILITY.getMethod(serializeMethod, paraTypes);
                return method.invoke(null, value).toString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return value.toString();
    }

    public static boolean isSimpleType(Class type) {
        String jtype = type.getName();
        return simplePrimitiveTypeMap.containsKey(jtype) || simpleObjectTypeMap.containsKey(jtype) || "void".equals(jtype);
    }

    public static QName schemaType(Class type) {
        String jtype = type.getName();
        QName stype = simplePrimitiveTypeMap.get(jtype);
        if (stype == null) {
            stype = simpleObjectTypeMap.get(jtype);
        }
        return stype;
    }

    public static boolean isPrimitiveType(String type) {
        return simpleWrapperMap.containsKey(type);
    }

    public static Class<?> primitiveType(String type) {
        return simpleWrapperMap.get(type);
    }

    public static QName toQname(String qname) {
        String ns = qname.substring(1, qname.indexOf("}"));
        String localName = qname.substring(qname.indexOf("}") + 2);
        return new QName(ns, localName);
    }

    static {
        simpleObjectTypeMap.put("java.lang.Boolean", new QName(SCHEMA_NAMESPACE, "boolean"));
        simpleObjectTypeMap.put("java.lang.Byte", new QName(SCHEMA_NAMESPACE, "byte"));
        simpleObjectTypeMap.put("java.lang.Character", new QName(SCHEMA_NAMESPACE, "unsignedInt"));
        simpleObjectTypeMap.put("java.lang.Double", new QName(SCHEMA_NAMESPACE, "double"));
        simpleObjectTypeMap.put("java.lang.Float", new QName(SCHEMA_NAMESPACE, "float"));
        simpleObjectTypeMap.put("java.lang.Integer", new QName(SCHEMA_NAMESPACE, "int"));
        simpleObjectTypeMap.put("java.lang.Long", new QName(SCHEMA_NAMESPACE, "long"));
        simpleObjectTypeMap.put("java.lang.Short", new QName(SCHEMA_NAMESPACE, "short"));
        simpleObjectTypeMap.put("java.lang.String", STRING_QNAME);
        simpleObjectTypeMap.put("java.math.BigDecimal", new QName(SCHEMA_NAMESPACE, "decimal"));
        simpleObjectTypeMap.put("java.math.BigInteger", new QName(SCHEMA_NAMESPACE, "integer"));
        simpleObjectTypeMap.put("java.util.Date", new QName(SCHEMA_NAMESPACE, "dateTime"));
        simpleObjectTypeMap.put("java.sql.Date", new QName(SCHEMA_NAMESPACE, "date"));
        simpleObjectTypeMap.put("java.sql.Time", new QName(SCHEMA_NAMESPACE, "time"));
        simpleObjectTypeMap.put("java.sql.Timestamp", new QName(SCHEMA_NAMESPACE, "dateTime"));
        simpleObjectTypeMap.put("org.joda.time.LocalDate", new QName(SCHEMA_NAMESPACE, "date"));
        simpleObjectTypeMap.put("org.joda.time.DateMidnight", new QName(SCHEMA_NAMESPACE, "date"));
        simpleObjectTypeMap.put("org.joda.time.LocalTime", new QName(SCHEMA_NAMESPACE, "time"));
        simpleObjectTypeMap.put("org.joda.time.DateTime", new QName(SCHEMA_NAMESPACE, "dateTime"));
        simpleObjectTypeMap.put("byte[]", new QName(SCHEMA_NAMESPACE, "base64"));
        simpleObjectTypeMap.put("org.jibx.runtime.QName", new QName(SCHEMA_NAMESPACE, "QName"));
        simplePrimitiveTypeMap.put("boolean", new QName(SCHEMA_NAMESPACE, "boolean"));
        simplePrimitiveTypeMap.put("byte", new QName(SCHEMA_NAMESPACE, "byte"));
        simplePrimitiveTypeMap.put("char", new QName(SCHEMA_NAMESPACE, "unsignedInt"));
        simplePrimitiveTypeMap.put("double", new QName(SCHEMA_NAMESPACE, "double"));
        simplePrimitiveTypeMap.put("float", new QName(SCHEMA_NAMESPACE, "float"));
        simplePrimitiveTypeMap.put("int", new QName(SCHEMA_NAMESPACE, "int"));
        simplePrimitiveTypeMap.put("long", new QName(SCHEMA_NAMESPACE, "long"));
        simplePrimitiveTypeMap.put("short", new QName(SCHEMA_NAMESPACE, "short"));
        simpleWrapperMap.put("boolean", Boolean.TYPE);
        simpleWrapperMap.put("byte", Byte.TYPE);
        simpleWrapperMap.put("char", Character.TYPE);
        simpleWrapperMap.put("double", Double.TYPE);
        simpleWrapperMap.put("float", Float.TYPE);
        simpleWrapperMap.put("int", Integer.TYPE);
        simpleWrapperMap.put("long", Long.TYPE);
        simpleWrapperMap.put("short", Short.TYPE);
        JibxSimpleTypes.buildFormat("byte", "byte", "serializeByte", "parseByte", "0", simpleTypeMap);
        JibxSimpleTypes.buildFormat("unsignedShort", "char", "serializeChar", "parseChar", "0", simpleTypeMap);
        JibxSimpleTypes.buildFormat("double", "double", "serializeDouble", "parseDouble", "0.0", simpleTypeMap);
        JibxSimpleTypes.buildFormat("float", "float", "serializeFloat", "parseFloat", "0.0", simpleTypeMap);
        JibxSimpleTypes.buildFormat("int", "int", "serializeInt", "parseInt", "0", simpleTypeMap);
        JibxSimpleTypes.buildFormat("long", "long", "serializeLong", "parseLong", "0", simpleTypeMap);
        JibxSimpleTypes.buildFormat("short", "short", "serializeShort", "parseShort", "0", simpleTypeMap);
        JibxSimpleTypes.buildFormat("boolean", "boolean", "serializeBoolean", "parseBoolean", "false", simpleTypeMap);
        JibxSimpleTypes.buildFormat("dateTime", "java.util.Date", "serializeDateTime", "deserializeDateTime", null, simpleTypeMap);
        JibxSimpleTypes.buildFormat("date", "java.sql.Date", "serializeSqlDate", "deserializeSqlDate", null, simpleTypeMap);
        JibxSimpleTypes.buildFormat("time", "java.sql.Time", "serializeSqlTime", "deserializeSqlTime", null, simpleTypeMap);
        JibxSimpleTypes.buildFormat("base64Binary", "byte[]", "serializeBase64", "deserializeBase64", null, simpleTypeMap);
        JibxSimpleTypes.buildFormat("string", "java.lang.String", null, null, null, simpleTypeMap);
    }

    private static class Format {
        private String typeName;
        private String deserializeMethod;
        private String serializeMethod;
        private String defaultValue;

        private Format() {
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public String getDeserializeMethod() {
            return this.deserializeMethod;
        }

        public void setDeserializeMethod(String deserializeMethod) {
            this.deserializeMethod = deserializeMethod;
        }

        public String getSerializeMethod() {
            return this.serializeMethod;
        }

        public void setSerializeMethod(String serializeMethod) {
            this.serializeMethod = serializeMethod;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }
    }
}

