/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientWebApplicationException;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerWebApplicationException
extends WebApplicationException {
    private String errorMessage;

    public ServerWebApplicationException() {
    }

    public ServerWebApplicationException(Response response) {
        super(response);
    }

    public ServerWebApplicationException(Throwable cause, Response response) {
        super(cause, response);
    }

    public Response getResponse() {
        Response response = super.getResponse();
        Response.ResponseBuilder rb = Response.status((int)response.getStatus());
        MultivaluedMap headers = response.getMetadata();
        for (String header : headers.keySet()) {
            List values = (List)headers.get((Object)header);
            for (Object value : values) {
                rb.header(header, value);
            }
        }
        rb.entity((Object)new ByteArrayInputStream(this.getMessage().getBytes()));
        return rb.build();
    }

    public int getStatus() {
        return super.getResponse().getStatus();
    }

    public MultivaluedMap<String, String> getHeaders() {
        return super.getResponse().getMetadata();
    }

    public String getMessage() {
        if (this.errorMessage == null) {
            this.errorMessage = this.readErrorMessage();
        }
        return this.errorMessage;
    }

    private String readErrorMessage() {
        Object entity = super.getResponse().getEntity();
        try {
            return entity == null ? "" : (entity instanceof InputStream ? IOUtils.readStringFromStream((InputStream)entity) : entity.toString());
        }
        catch (IOException ex) {
            return "";
        }
    }

    public String toString() {
        String lineSep = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("Status : " + this.getStatus()).append(lineSep);
        sb.append("Headers : ").append(lineSep);
        MultivaluedMap<String, String> headers = this.getHeaders();
        for (String header : headers.keySet()) {
            sb.append(header + " :");
            Iterator it = ((List)headers.get((Object)header)).iterator();
            while (it.hasNext()) {
                sb.append(' ').append((String)it.next());
                if (!it.hasNext()) continue;
                sb.append(',');
            }
            sb.append(lineSep);
        }
        String message = this.getMessage();
        if (!StringUtils.isEmpty(message)) {
            sb.append("Error message : ").append(lineSep);
            sb.append(message).append(lineSep);
        }
        return sb.toString();
    }

    public <T> T toErrorObject(Client client, Class<T> entityCls) {
        Response response = this.getResponse();
        try {
            MultivaluedMap headers = response.getMetadata();
            Object contentType = headers.getFirst((Object)"Content-Type");
            InputStream inputStream = (InputStream)response.getEntity();
            if (contentType == null || inputStream == null) {
                return null;
            }
            Annotation[] annotations = new Annotation[]{};
            MediaType mt = MediaType.valueOf((String)contentType.toString());
            Endpoint ep = WebClient.getConfig(client).getConduitSelector().getEndpoint();
            ExchangeImpl exchange = new ExchangeImpl();
            MessageImpl inMessage = new MessageImpl();
            inMessage.setExchange(exchange);
            exchange.put(Endpoint.class, ep);
            exchange.setOutMessage(new MessageImpl());
            exchange.setInMessage(inMessage);
            inMessage.put("org.apache.cxf.client", Boolean.TRUE);
            inMessage.put(Message.PROTOCOL_HEADERS, headers);
            ProviderFactory pf = (ProviderFactory)ep.get(ProviderFactory.class.getName());
            MessageBodyReader<T> reader = pf.createMessageBodyReader(entityCls, entityCls, annotations, mt, inMessage);
            if (reader == null) {
                return null;
            }
            return (T)reader.readFrom(entityCls, entityCls, annotations, mt, headers, inputStream);
        }
        catch (Exception ex) {
            throw new ClientWebApplicationException(ex);
        }
    }
}

