/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AbstractTypeCreator;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.TypeClassInfo;
import org.apache.cxf.aegis.type.TypeCreationOptions;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.type.basic.BeanType;
import org.apache.cxf.aegis.type.basic.BeanTypeInfo;

public class DefaultTypeCreator
extends AbstractTypeCreator {
    public DefaultTypeCreator() {
    }

    public DefaultTypeCreator(TypeCreationOptions configuration) {
        this.setConfiguration(configuration);
    }

    public TypeClassInfo createClassInfo(Method m, int index) {
        TypeClassInfo info = new TypeClassInfo();
        info.setDescription("method " + m.getName() + " parameter " + index);
        if (index >= 0) {
            info.setType(m.getParameterTypes()[index]);
        } else {
            info.setType(m.getReturnType());
        }
        return info;
    }

    public TypeClassInfo createClassInfo(PropertyDescriptor pd) {
        return this.createBasicClassInfo(pd.getPropertyType());
    }

    public AegisType createCollectionType(TypeClassInfo info) {
        if (!(info.getType() instanceof ParameterizedType)) {
            throw new DatabindingException("Cannot create mapping for " + info.getType() + ", unspecified component type for " + info.getDescription());
        }
        return this.createCollectionTypeFromGeneric(info);
    }

    public AegisType createDefaultType(TypeClassInfo info) {
        BeanType type = new BeanType();
        Class<?> typeClass = TypeUtil.getTypeClass(info.getType(), false);
        if (typeClass == null) {
            throw new DatabindingException("Unable to map generic type " + info.getType());
        }
        type.setSchemaType(this.createQName(typeClass));
        type.setTypeClass(typeClass);
        type.setTypeMapping(this.getTypeMapping());
        BeanTypeInfo typeInfo = type.getTypeInfo();
        typeInfo.setDefaultMinOccurs(this.getConfiguration().getDefaultMinOccurs());
        typeInfo.setExtensibleAttributes(this.getConfiguration().isDefaultExtensibleAttributes());
        typeInfo.setExtensibleElements(this.getConfiguration().isDefaultExtensibleElements());
        return type;
    }

    protected AegisType getOrCreateMapKeyType(TypeClassInfo info) {
        return this.createObjectType();
    }

    protected AegisType getOrCreateMapValueType(TypeClassInfo info) {
        return this.createObjectType();
    }
}

