/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import org.apache.commons.beanutils2.ConvertUtilsBean;
import org.apache.commons.beanutils2.Converter;

public class ConvertUtils {
    public static String convert(Object value) {
        return ConvertUtilsBean.getInstance().convert(value);
    }

    public static Object convert(Object value, Class<?> targetType) {
        return ConvertUtilsBean.getInstance().convert(value, targetType);
    }

    public static Object convert(String value, Class<?> clazz) {
        return ConvertUtilsBean.getInstance().convert(value, clazz);
    }

    public static Object convert(String[] values, Class<?> clazz) {
        return ConvertUtilsBean.getInstance().convert(values, clazz);
    }

    public static void deregister() {
        ConvertUtilsBean.getInstance().deregister();
    }

    public static void deregister(Class<?> clazz) {
        ConvertUtilsBean.getInstance().deregister(clazz);
    }

    public static <T> Converter<T> lookup(Class<?> sourceType, Class<T> targetType) {
        return ConvertUtilsBean.getInstance().lookup(sourceType, targetType);
    }

    public static <T> Converter<T> lookup(Class<T> clazz) {
        return ConvertUtilsBean.getInstance().lookup(clazz);
    }

    public static <T> Class<T> primitiveToWrapper(Class<T> type) {
        if (type == null || !type.isPrimitive()) {
            return type;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        return type;
    }

    public static <T> void register(Converter<T> converter, Class<T> clazz) {
        ConvertUtilsBean.getInstance().register(converter, clazz);
    }
}

