/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.GCInspector;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.CLibrary;
import org.apache.cassandra.utils.Mx4jTool;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCassandraDaemon
implements CassandraDaemon {
    private static Logger logger = LoggerFactory.getLogger(AbstractCassandraDaemon.class);
    static final AtomicInteger exceptions = new AtomicInteger();
    protected InetAddress listenAddr;
    protected int listenPort;
    protected volatile boolean isRunning = false;

    public static void initLog4j() {
        if (System.getProperty("log4j.defaultInitOverride", "false").equalsIgnoreCase("true")) {
            String config = System.getProperty("log4j.configuration", "log4j-server.properties");
            URL configLocation = null;
            try {
                configLocation = new URL(config);
            }
            catch (MalformedURLException ex) {
                configLocation = AbstractCassandraDaemon.class.getClassLoader().getResource(config);
            }
            if (configLocation == null) {
                throw new RuntimeException("Couldn't figure out log4j configuration: " + config);
            }
            String configFileName = null;
            try {
                configFileName = configLocation.getFile();
                File configFile = new File(configFileName);
                if (!configFile.exists()) {
                    configFileName = new File(configLocation.toURI()).getCanonicalPath();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't convert log4j configuration location to a valid file", e);
            }
            PropertyConfigurator.configureAndWatch((String)configFileName, (long)10000L);
            org.apache.log4j.Logger.getLogger(AbstractCassandraDaemon.class).info((Object)"Logging initialized");
        }
    }

    protected void setup() throws IOException {
        logger.info("JVM vendor/version: {}/{}", (Object)System.getProperty("java.vm.name"), (Object)System.getProperty("java.version"));
        logger.info("Heap size: {}/{}", (Object)Runtime.getRuntime().totalMemory(), (Object)Runtime.getRuntime().maxMemory());
        logger.info("Classpath: {}", (Object)System.getProperty("java.class.path"));
        CLibrary.tryMlockall();
        this.listenPort = DatabaseDescriptor.getRpcPort();
        this.listenAddr = DatabaseDescriptor.getRpcAddress();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                exceptions.incrementAndGet();
                logger.error("Fatal exception in thread " + t, e);
                if (e instanceof OutOfMemoryError) {
                    System.exit(100);
                }
            }
        });
        for (CFMetaData cfm : DatabaseDescriptor.getTableMetaData("system").values()) {
            ColumnFamilyStore.scrubDataDirectories("system", cfm.cfName);
        }
        try {
            SystemTable.checkHealth();
        }
        catch (ConfigurationException e) {
            logger.error("Fatal exception during initialization", (Throwable)e);
            System.exit(100);
        }
        try {
            DatabaseDescriptor.loadSchemas();
        }
        catch (IOException e) {
            logger.error("Fatal exception during initialization", (Throwable)e);
            System.exit(100);
        }
        for (String table : DatabaseDescriptor.getTables()) {
            for (CFMetaData cfm : DatabaseDescriptor.getTableMetaData(table).values()) {
                ColumnFamilyStore.scrubDataDirectories(table, cfm.cfName);
            }
        }
        for (String table : DatabaseDescriptor.getTables()) {
            if (logger.isDebugEnabled()) {
                logger.debug("opening keyspace " + table);
            }
            Table.open(table);
        }
        try {
            GCInspector.instance.start();
        }
        catch (Throwable t) {
            logger.warn("Unable to start GCInspector (currently only supported on the Sun JVM)");
        }
        CommitLog.recover();
        UUID currentMigration = DatabaseDescriptor.getDefsVersion();
        UUID lastMigration = Migration.getLastMigrationId();
        if (lastMigration != null && lastMigration.timestamp() > currentMigration.timestamp()) {
            Gossiper.instance.maybeInitializeLocalState(SystemTable.incrementAndGetGeneration());
            MigrationManager.applyMigrations(currentMigration, lastMigration);
        }
        SystemTable.purgeIncompatibleHints();
        StorageService.instance.registerDaemon(this);
        try {
            StorageService.instance.initServer();
        }
        catch (ConfigurationException e) {
            logger.error("Fatal configuration error", (Throwable)e);
            System.err.println(e.getMessage() + "\nFatal configuration error; unable to start server.  See log for stacktrace.");
            System.exit(1);
        }
        Mx4jTool.maybeLoad();
    }

    @Override
    public void init(String[] arguments) throws IOException {
        this.setup();
    }

    @Override
    public void start() {
        if (Boolean.parseBoolean(System.getProperty("cassandra.start_rpc", "true"))) {
            this.startRPCServer();
        } else {
            logger.info("Not starting RPC server as requested. Use JMX (StorageService->startRPCServer()) to start it");
        }
    }

    @Override
    public void stop() {
        logger.info("Cassandra shutting down...");
        this.stopRPCServer();
    }

    @Override
    public void startRPCServer() {
        if (!this.isRunning) {
            this.startServer();
            this.isRunning = true;
        }
    }

    @Override
    public void stopRPCServer() {
        if (this.isRunning) {
            this.stopServer();
            this.isRunning = false;
        }
    }

    @Override
    public boolean isRPCServerRunning() {
        return this.isRunning;
    }

    protected abstract void startServer();

    protected abstract void stopServer();

    @Override
    public void destroy() {
    }

    @Override
    public void activate() {
        String pidFile = System.getProperty("cassandra-pidfile");
        try {
            this.setup();
            if (pidFile != null) {
                new File(pidFile).deleteOnExit();
            }
            if (System.getProperty("cassandra-foreground") == null) {
                System.out.close();
                System.err.close();
            }
            this.start();
        }
        catch (Throwable e) {
            String msg = "Exception encountered during startup.";
            logger.error(msg, e);
            System.out.println(msg);
            e.printStackTrace();
            System.exit(3);
        }
    }

    @Override
    public void deactivate() {
        this.stop();
        this.destroy();
    }

    public static class CleaningThreadPool
    extends ThreadPoolExecutor {
        private ThreadLocal<ClientState> state;

        public CleaningThreadPool(ThreadLocal<ClientState> state, int minWorkerThread, int maxWorkerThreads) {
            super(minWorkerThread, maxWorkerThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            this.state = state;
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            DebuggableThreadPoolExecutor.logExceptionsAfterExecute(r, t);
            this.state.get().logout();
        }
    }
}

