/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.security.streaming;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.cassandra.streaming.IncomingStreamReader;
import org.apache.cassandra.streaming.StreamHeader;

public class SSLIncomingStreamReader
extends IncomingStreamReader {
    private final DataInputStream input;

    public SSLIncomingStreamReader(StreamHeader header, Socket socket, DataInputStream input) throws IOException {
        super(header, socket);
        this.input = input;
    }

    @Override
    protected long readnwrite(long length, long bytesRead, long offset, FileChannel fc) throws IOException {
        int toRead = (int)Math.min(0xA00000L, length - bytesRead);
        ByteBuffer buf = ByteBuffer.allocate(toRead);
        this.input.readFully(buf.array());
        fc.write(buf);
        this.remoteFile.progress += (long)buf.limit();
        return bytesRead += (long)buf.limit();
    }
}

