/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.File;
import java.io.IOException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.AbstractSSTableSimpleWriter;
import org.apache.cassandra.io.sstable.SSTableWriter;

public class SSTableSimpleWriter
extends AbstractSSTableSimpleWriter {
    private final SSTableWriter writer = this.getWriter();

    public SSTableSimpleWriter(File directory, String keyspace, String columnFamily, AbstractType comparator, AbstractType subComparator) throws IOException {
        this(directory, new CFMetaData(keyspace, columnFamily, subComparator == null ? ColumnFamilyType.Standard : ColumnFamilyType.Super, comparator, subComparator));
    }

    public SSTableSimpleWriter(File directory, CFMetaData metadata) throws IOException {
        super(directory, metadata);
    }

    @Override
    public void close() throws IOException {
        if (this.currentKey != null) {
            this.writeRow(this.currentKey, this.columnFamily);
        }
        this.writer.closeAndOpenReader();
    }

    @Override
    protected void writeRow(DecoratedKey key, ColumnFamily columnFamily) throws IOException {
        this.writer.append(key, columnFamily);
    }

    @Override
    protected ColumnFamily getColumnFamily() {
        return ColumnFamily.create(this.metadata);
    }
}

