/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang.time.DateUtils;

public class DateType
extends AbstractType<Date> {
    public static final DateType instance = new DateType();
    static final String DEFAULT_FORMAT = TimeUUIDType.iso8601Patterns[3];
    static final SimpleDateFormat FORMATTER = new SimpleDateFormat(DEFAULT_FORMAT);

    DateType() {
    }

    @Override
    public Date compose(ByteBuffer bytes) {
        return new Date(ByteBufferUtil.toLong(bytes));
    }

    @Override
    public ByteBuffer decompose(Date value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBufferUtil.bytes(value.getTime());
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (o1.remaining() == 0) {
            return o2.remaining() == 0 ? 0 : -1;
        }
        if (o2.remaining() == 0) {
            return 1;
        }
        return ByteBufferUtil.compareUnsigned(o1, o2);
    }

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return "";
        }
        if (bytes.remaining() != 8) {
            throw new MarshalException("A date is exactly 8 bytes (stored as a long): " + bytes.remaining());
        }
        return FORMATTER.format(new Date(bytes.getLong(bytes.position())));
    }

    @Override
    public String toString(Date d) {
        return FORMATTER.format(d);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        ByteBuffer idBytes = null;
        if (source.toLowerCase().equals("now")) {
            long millis = System.currentTimeMillis();
            idBytes = ByteBufferUtil.bytes(millis);
        } else {
            if (source.matches("^\\d+$")) {
                try {
                    idBytes = ByteBufferUtil.bytes(Long.parseLong(source));
                }
                catch (NumberFormatException e) {
                    throw new MarshalException(String.format("unable to make long (for date) from:  '%s'", source), e);
                }
            }
            try {
                long millis = DateUtils.parseDate((String)source, (String[])TimeUUIDType.iso8601Patterns).getTime();
                idBytes = ByteBufferUtil.bytes(millis);
            }
            catch (ParseException e1) {
                throw new MarshalException(String.format("unable to coerce '%s' to a  formatted date (long)", source), e1);
            }
        }
        return idBytes;
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 8 && bytes.remaining() != 0) {
            throw new MarshalException(String.format("Expected 8 or 0 byte long for date (%d)", bytes.remaining()));
        }
    }

    @Override
    public Class<Date> getType() {
        return Date.class;
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public int getPrecision(Date obj) {
        return -1;
    }

    @Override
    public int getScale(Date obj) {
        return -1;
    }

    @Override
    public int getJdbcType() {
        return 91;
    }

    @Override
    public boolean needsQuotes() {
        return false;
    }
}

