/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.IIterableColumns;
import org.apache.cassandra.utils.BloomFilter;

public class ColumnIndexer {
    public static void serialize(IIterableColumns columns, DataOutput dos) {
        try {
            ColumnIndexer.serializeInternal(columns, dos);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static void serializeInternal(IIterableColumns columns, DataOutput dos) throws IOException {
        int columnCount = columns.getEstimatedColumnCount();
        BloomFilter bf = BloomFilter.getFilter((long)columnCount, 4);
        if (columnCount == 0) {
            ColumnIndexer.writeEmptyHeader(dos, bf);
            return;
        }
        ArrayList<IndexHelper.IndexInfo> indexList = new ArrayList<IndexHelper.IndexInfo>();
        int endPosition = 0;
        int startPosition = -1;
        int indexSizeInBytes = 0;
        IColumn lastColumn = null;
        IColumn firstColumn = null;
        for (IColumn column : columns) {
            bf.add(column.name());
            if (firstColumn == null) {
                firstColumn = column;
                startPosition = endPosition;
            }
            if ((endPosition += column.serializedSize()) - startPosition >= DatabaseDescriptor.getColumnIndexSize()) {
                IndexHelper.IndexInfo cIndexInfo = new IndexHelper.IndexInfo(firstColumn.name(), column.name(), startPosition, endPosition - startPosition);
                indexList.add(cIndexInfo);
                indexSizeInBytes += cIndexInfo.serializedSize();
                firstColumn = null;
            }
            lastColumn = column;
        }
        if (lastColumn == null) {
            ColumnIndexer.writeEmptyHeader(dos, bf);
            return;
        }
        if (indexList.isEmpty() || columns.getComparator().compare(((IndexHelper.IndexInfo)indexList.get((int)(indexList.size() - 1))).lastName, lastColumn.name()) != 0) {
            IndexHelper.IndexInfo cIndexInfo = new IndexHelper.IndexInfo(firstColumn.name(), lastColumn.name(), startPosition, endPosition - startPosition);
            indexList.add(cIndexInfo);
            indexSizeInBytes += cIndexInfo.serializedSize();
        }
        ColumnIndexer.writeBloomFilter(dos, bf);
        assert (indexSizeInBytes > 0);
        if (indexList.size() > 1) {
            dos.writeInt(indexSizeInBytes);
            for (IndexHelper.IndexInfo cIndexInfo : indexList) {
                cIndexInfo.serialize(dos);
            }
        } else {
            dos.writeInt(0);
        }
    }

    private static void writeEmptyHeader(DataOutput dos, BloomFilter bf) throws IOException {
        ColumnIndexer.writeBloomFilter(dos, bf);
        dos.writeInt(0);
    }

    private static void writeBloomFilter(DataOutput dos, BloomFilter bf) throws IOException {
        DataOutputBuffer bufOut = new DataOutputBuffer();
        BloomFilter.serializer().serialize(bf, bufOut);
        dos.writeInt(bufOut.getLength());
        dos.write(bufOut.getData(), 0, bufOut.getLength());
        bufOut.flush();
    }
}

