/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.streaming.parser;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import org.apache.spark.sql.Row;
import scala.Function1;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class FieldConverter$ {
    public static final FieldConverter$ MODULE$;
    private final String stringLengthExceedErrorMsg;

    static {
        new FieldConverter$();
    }

    public String stringLengthExceedErrorMsg() {
        return this.stringLengthExceedErrorMsg;
    }

    public String objectToString(Object value, String serializationNullFormat, ArrayList<String> complexDelimiters, SimpleDateFormat timeStampFormat, SimpleDateFormat dateFormat, boolean isVarcharType, boolean isComplexType, int level, String binaryCodec) {
        String string;
        if (value == null) {
            string = serializationNullFormat;
        } else {
            String string2;
            Object object = value;
            if (object instanceof String) {
                String string3 = (String)object;
                if (!isVarcharType && !isComplexType && string3.length() > 32000) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)this.stringLengthExceedErrorMsg()).append((Object)BoxesRunTime.boxToInteger((int)32000)).append((Object)" characters").toString());
                }
                string2 = string3;
            } else if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                string2 = bigDecimal.toPlainString();
            } else if (object instanceof Integer) {
                Integer n = (Integer)object;
                string2 = n.toString();
            } else if (object instanceof Double) {
                Double d = (Double)object;
                string2 = d.toString();
            } else if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                string2 = timeStampFormat.format(timestamp);
            } else if (object instanceof Date) {
                Date date = (Date)object;
                string2 = dateFormat.format(date);
            } else if (object instanceof Boolean) {
                Boolean bl = (Boolean)object;
                string2 = bl.toString();
            } else if (object instanceof Short) {
                Short s = (Short)object;
                string2 = s.toString();
            } else if (object instanceof Float) {
                Float f = (Float)object;
                string2 = f.toString();
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                string2 = "base64".equalsIgnoreCase(binaryCodec) ? Base64.getEncoder().encodeToString(byArray) : new String(byArray, Charset.forName("UTF-8"));
            } else if (object instanceof Seq) {
                String string4;
                Seq seq = (Seq)object;
                if (seq.nonEmpty()) {
                    String delimiter = complexDelimiters.get(level);
                    StringBuilder builder = new StringBuilder();
                    seq.foreach((Function1)new Serializable(serializationNullFormat, complexDelimiters, timeStampFormat, dateFormat, isVarcharType, level, binaryCodec, delimiter, builder){
                        public static final long serialVersionUID = 0L;
                        private final String serializationNullFormat$1;
                        private final ArrayList complexDelimiters$1;
                        private final SimpleDateFormat timeStampFormat$1;
                        private final SimpleDateFormat dateFormat$1;
                        private final boolean isVarcharType$1;
                        private final int level$1;
                        private final String binaryCodec$1;
                        private final String delimiter$1;
                        private final StringBuilder builder$1;

                        public final StringBuilder apply(Object x) {
                            int nextLevel = this.level$1 + 1;
                            Object x$1 = x;
                            String x$2 = this.serializationNullFormat$1;
                            ArrayList x$3 = this.complexDelimiters$1;
                            SimpleDateFormat x$4 = this.timeStampFormat$1;
                            SimpleDateFormat x$5 = this.dateFormat$1;
                            boolean x$6 = this.isVarcharType$1;
                            int x$7 = nextLevel;
                            String x$8 = this.binaryCodec$1;
                            boolean x$9 = FieldConverter$.MODULE$.objectToString$default$7();
                            return this.builder$1.append(FieldConverter$.MODULE$.objectToString(x$1, x$2, x$3, x$4, x$5, x$6, x$9, x$7, x$8)).append(this.delimiter$1);
                        }
                        {
                            this.serializationNullFormat$1 = serializationNullFormat$1;
                            this.complexDelimiters$1 = complexDelimiters$1;
                            this.timeStampFormat$1 = timeStampFormat$1;
                            this.dateFormat$1 = dateFormat$1;
                            this.isVarcharType$1 = isVarcharType$1;
                            this.level$1 = level$1;
                            this.binaryCodec$1 = binaryCodec$1;
                            this.delimiter$1 = delimiter$1;
                            this.builder$1 = builder$1;
                        }
                    });
                    string4 = builder.substring(0, builder.length() - delimiter.length());
                } else {
                    string4 = "!LENGTH_ZERO_DATA_RETURN!";
                }
                string2 = string4;
            } else if (object instanceof Map) {
                String string5;
                Map map = (Map)object;
                if (map.nonEmpty()) {
                    int nextLevel = level + 2;
                    String delimiter = complexDelimiters.get(level);
                    String keyValueDelimiter = complexDelimiters.get(level + 1);
                    StringBuilder builder = new StringBuilder();
                    map.foreach((Function1)new Serializable(serializationNullFormat, complexDelimiters, timeStampFormat, dateFormat, isVarcharType, binaryCodec, nextLevel, delimiter, keyValueDelimiter, builder){
                        public static final long serialVersionUID = 0L;
                        private final String serializationNullFormat$1;
                        private final ArrayList complexDelimiters$1;
                        private final SimpleDateFormat timeStampFormat$1;
                        private final SimpleDateFormat dateFormat$1;
                        private final boolean isVarcharType$1;
                        private final String binaryCodec$1;
                        private final int nextLevel$1;
                        private final String delimiter$2;
                        private final String keyValueDelimiter$1;
                        private final StringBuilder builder$2;

                        public final StringBuilder apply(Tuple2<Object, Object> x) {
                            Object x$10 = x._1();
                            String x$11 = this.serializationNullFormat$1;
                            ArrayList x$12 = this.complexDelimiters$1;
                            SimpleDateFormat x$13 = this.timeStampFormat$1;
                            SimpleDateFormat x$14 = this.dateFormat$1;
                            boolean x$15 = this.isVarcharType$1;
                            int x$16 = this.nextLevel$1;
                            String x$17 = this.binaryCodec$1;
                            boolean x$18 = FieldConverter$.MODULE$.objectToString$default$7();
                            this.builder$2.append(FieldConverter$.MODULE$.objectToString(x$10, x$11, x$12, x$13, x$14, x$15, x$18, x$16, x$17)).append(this.keyValueDelimiter$1);
                            Object x$19 = x._2();
                            String x$20 = this.serializationNullFormat$1;
                            ArrayList x$21 = this.complexDelimiters$1;
                            SimpleDateFormat x$22 = this.timeStampFormat$1;
                            SimpleDateFormat x$23 = this.dateFormat$1;
                            boolean x$24 = this.isVarcharType$1;
                            int x$25 = this.nextLevel$1;
                            String x$26 = this.binaryCodec$1;
                            boolean x$27 = FieldConverter$.MODULE$.objectToString$default$7();
                            return this.builder$2.append(FieldConverter$.MODULE$.objectToString(x$19, x$20, x$21, x$22, x$23, x$24, x$27, x$25, x$26)).append(this.delimiter$2);
                        }
                        {
                            this.serializationNullFormat$1 = serializationNullFormat$1;
                            this.complexDelimiters$1 = complexDelimiters$1;
                            this.timeStampFormat$1 = timeStampFormat$1;
                            this.dateFormat$1 = dateFormat$1;
                            this.isVarcharType$1 = isVarcharType$1;
                            this.binaryCodec$1 = binaryCodec$1;
                            this.nextLevel$1 = nextLevel$1;
                            this.delimiter$2 = delimiter$2;
                            this.keyValueDelimiter$1 = keyValueDelimiter$1;
                            this.builder$2 = builder$2;
                        }
                    });
                    string5 = builder.substring(0, builder.length() - delimiter.length());
                } else {
                    string5 = "!LENGTH_ZERO_DATA_RETURN!";
                }
                string2 = string5;
            } else if (object instanceof Row) {
                Row row = (Row)object;
                String delimiter = complexDelimiters.get(level);
                StringBuilder builder = new StringBuilder();
                int len = row.length();
                for (int i = 0; i < len; ++i) {
                    int nextLevel = level + 1;
                    Object x$28 = row.apply(i);
                    String x$29 = serializationNullFormat;
                    ArrayList<String> x$30 = complexDelimiters;
                    SimpleDateFormat x$31 = timeStampFormat;
                    SimpleDateFormat x$32 = dateFormat;
                    boolean x$33 = isVarcharType;
                    int x$34 = nextLevel;
                    String x$35 = binaryCodec;
                    boolean x$36 = this.objectToString$default$7();
                    builder.append(this.objectToString(x$28, x$29, x$30, x$31, x$32, x$33, x$36, x$34, x$35)).append(delimiter);
                }
                string2 = builder.substring(0, builder.length() - delimiter.length());
            } else {
                string2 = object.toString();
            }
            string = string2;
        }
        return string;
    }

    public boolean objectToString$default$6() {
        return false;
    }

    public boolean objectToString$default$7() {
        return false;
    }

    public int objectToString$default$8() {
        return 0;
    }

    private FieldConverter$() {
        MODULE$ = this;
        this.stringLengthExceedErrorMsg = "Dataload failed, String length cannot exceed ";
    }
}

