/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.streaming;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.carbondata.core.datastore.compression.Compressor;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.datastore.page.statistics.ColumnPageStatsCollector;
import org.apache.carbondata.core.datastore.page.statistics.KeyPageStatsCollector;
import org.apache.carbondata.core.datastore.page.statistics.PrimitivePageStatsCollector;
import org.apache.carbondata.core.datastore.page.statistics.SimpleStatsResult;
import org.apache.carbondata.core.metadata.blocklet.index.BlockletMinMaxIndex;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.util.CarbonMetadataUtil;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.format.BlockletHeader;
import org.apache.carbondata.format.BlockletIndex;
import org.apache.carbondata.format.BlockletInfo;
import org.apache.carbondata.format.MutationType;
import org.apache.carbondata.streaming.CarbonStreamOutputFormat;
import org.apache.carbondata.streaming.segment.StreamSegment;
import org.apache.thrift.TBase;

public class StreamBlockletWriter {
    private byte[] buffer;
    private int maxSize;
    private int maxRowNum;
    private int rowSize;
    private int count = 0;
    private int rowIndex = -1;
    private Compressor compressor;
    private int dimCountWithoutComplex;
    private int measureCount;
    private DataType[] measureDataTypes;
    ColumnPageStatsCollector[] dimStatsCollectors;
    ColumnPageStatsCollector[] msrStatsCollectors;
    private BlockletMinMaxIndex blockletMinMaxIndex;

    StreamBlockletWriter(int maxSize, int maxRowNum, int rowSize, int dimCountWithoutComplex, int measureCount, DataType[] measureDataTypes, String compressorName) {
        this.buffer = new byte[maxSize];
        this.maxSize = maxSize;
        this.maxRowNum = maxRowNum;
        this.rowSize = rowSize;
        this.dimCountWithoutComplex = dimCountWithoutComplex;
        this.measureCount = measureCount;
        this.measureDataTypes = measureDataTypes;
        this.compressor = CompressorFactory.getInstance().getCompressor(compressorName);
        this.initializeStatsCollector();
    }

    private void initializeStatsCollector() {
        this.dimStatsCollectors = new ColumnPageStatsCollector[this.dimCountWithoutComplex];
        this.msrStatsCollectors = new ColumnPageStatsCollector[this.measureCount];
        for (int dimCount = 0; dimCount < this.dimCountWithoutComplex; ++dimCount) {
            this.dimStatsCollectors[dimCount] = KeyPageStatsCollector.newInstance((DataType)DataTypes.BYTE_ARRAY);
        }
        for (int msrCount = 0; msrCount < this.measureCount; ++msrCount) {
            this.msrStatsCollectors[msrCount] = PrimitivePageStatsCollector.newInstance((DataType)this.measureDataTypes[msrCount]);
        }
    }

    private void ensureCapacity(int space) {
        int newcount = space + this.count;
        if (newcount > this.buffer.length) {
            byte[] newbuf = new byte[Math.max(newcount, this.buffer.length + this.rowSize)];
            System.arraycopy(this.buffer, 0, newbuf, 0, this.count);
            this.buffer = newbuf;
        }
    }

    void reset() {
        this.count = 0;
        this.rowIndex = -1;
        this.initializeStatsCollector();
        this.blockletMinMaxIndex = null;
    }

    byte[] getBytes() {
        return this.buffer;
    }

    int getCount() {
        return this.count;
    }

    int getRowIndex() {
        return this.rowIndex;
    }

    void nextRow() {
        ++this.rowIndex;
    }

    void skipRow() {
        --this.maxSize;
        --this.maxRowNum;
    }

    boolean isFull() {
        return this.rowIndex == this.maxRowNum || this.count >= this.maxSize;
    }

    void writeBoolean(boolean val) {
        this.ensureCapacity(1);
        this.buffer[this.count] = (byte)(val ? 1 : 0);
        ++this.count;
    }

    void writeShort(int val) {
        this.ensureCapacity(2);
        this.buffer[this.count + 1] = (byte)val;
        this.buffer[this.count] = (byte)(val >>> 8);
        this.count += 2;
    }

    void writeInt(int val) {
        this.ensureCapacity(4);
        this.buffer[this.count + 3] = (byte)val;
        this.buffer[this.count + 2] = (byte)(val >>> 8);
        this.buffer[this.count + 1] = (byte)(val >>> 16);
        this.buffer[this.count] = (byte)(val >>> 24);
        this.count += 4;
    }

    void writeLong(long val) {
        this.ensureCapacity(8);
        this.buffer[this.count + 7] = (byte)val;
        this.buffer[this.count + 6] = (byte)(val >>> 8);
        this.buffer[this.count + 5] = (byte)(val >>> 16);
        this.buffer[this.count + 4] = (byte)(val >>> 24);
        this.buffer[this.count + 3] = (byte)(val >>> 32);
        this.buffer[this.count + 2] = (byte)(val >>> 40);
        this.buffer[this.count + 1] = (byte)(val >>> 48);
        this.buffer[this.count] = (byte)(val >>> 56);
        this.count += 8;
    }

    void writeDouble(double val) {
        this.writeLong(Double.doubleToLongBits(val));
    }

    void writeBytes(byte[] b) {
        this.writeBytes(b, 0, b.length);
    }

    void writeBytes(byte[] b, int off, int len) {
        this.ensureCapacity(len);
        System.arraycopy(b, off, this.buffer, this.count, len);
        this.count += len;
    }

    private SimpleStatsResult[] getDimStats() {
        if (this.dimStatsCollectors == null) {
            return new SimpleStatsResult[0];
        }
        SimpleStatsResult[] stats = new SimpleStatsResult[this.dimStatsCollectors.length];
        for (int dimCount = 0; dimCount < this.dimStatsCollectors.length; ++dimCount) {
            stats[dimCount] = this.dimStatsCollectors[dimCount].getPageStats();
        }
        return stats;
    }

    private SimpleStatsResult[] getMsrStats() {
        if (this.msrStatsCollectors == null) {
            return new SimpleStatsResult[0];
        }
        SimpleStatsResult[] stats = new SimpleStatsResult[this.msrStatsCollectors.length];
        for (int mrsCount = 0; mrsCount < this.msrStatsCollectors.length; ++mrsCount) {
            stats[mrsCount] = this.msrStatsCollectors[mrsCount].getPageStats();
        }
        return stats;
    }

    BlockletMinMaxIndex generateBlockletMinMax() {
        if (this.blockletMinMaxIndex == null) {
            this.blockletMinMaxIndex = StreamSegment.collectMinMaxIndex(this.getDimStats(), this.getMsrStats());
        }
        return this.blockletMinMaxIndex;
    }

    void apppendBlocklet(DataOutputStream outputStream) throws IOException {
        outputStream.write(CarbonStreamOutputFormat.CARBON_SYNC_MARKER);
        BlockletInfo blockletInfo = new BlockletInfo();
        blockletInfo.setNum_rows(this.getRowIndex() + 1);
        BlockletHeader blockletHeader = new BlockletHeader();
        blockletHeader.setBlocklet_length(this.getCount());
        blockletHeader.setMutation(MutationType.INSERT);
        blockletHeader.setBlocklet_info(blockletInfo);
        this.blockletMinMaxIndex = this.generateBlockletMinMax();
        if (blockletInfo.getNum_rows() > 1) {
            BlockletIndex blockletIndex = new BlockletIndex();
            blockletIndex.setMin_max_index(CarbonMetadataUtil.convertMinMaxIndex((BlockletMinMaxIndex)this.blockletMinMaxIndex));
            blockletHeader.setBlocklet_index(blockletIndex);
        }
        byte[] headerBytes = CarbonUtil.getByteArray((TBase)blockletHeader);
        outputStream.writeInt(headerBytes.length);
        outputStream.write(headerBytes);
        byte[] compressed = this.compressor.compressByte(this.getBytes(), this.getCount());
        outputStream.writeInt(compressed.length);
        outputStream.write(compressed);
    }

    void close() {
    }
}

