/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.streaming;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.carbondata.core.util.ObjectSerializationUtil;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.streaming.CarbonStreamRecordWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class CarbonStreamOutputFormat
extends FileOutputFormat<Void, Object> {
    static final byte[] CARBON_SYNC_MARKER = "@carbondata_sync".getBytes(Charset.forName("UTF-8"));
    public static final String CARBON_ENCODER_ROW_BUFFER_SIZE = "carbon.stream.row.buffer.size";
    public static final int CARBON_ENCODER_ROW_BUFFER_SIZE_DEFAULT = 1024;
    public static final String CARBON_STREAM_BLOCKLET_ROW_NUMS = "carbon.stream.blocklet.row.nums";
    public static final int CARBON_STREAM_BLOCKLET_ROW_NUMS_DEFAULT = 32000;
    public static final String CARBON_STREAM_CACHE_SIZE = "carbon.stream.cache.size";
    public static final int CARBON_STREAM_CACHE_SIZE_DEFAULT = 0x2000000;
    private static final String LOAD_Model = "mapreduce.output.carbon.load.model";
    private static final String SEGMENT_ID = "carbon.segment.id";

    public RecordWriter<Void, Object> getRecordWriter(TaskAttemptContext job) throws IOException {
        return new CarbonStreamRecordWriter(job);
    }

    public static void setCarbonLoadModel(Configuration hadoopConf, CarbonLoadModel carbonLoadModel) throws IOException {
        if (carbonLoadModel != null) {
            hadoopConf.set(LOAD_Model, ObjectSerializationUtil.convertObjectToString((Object)carbonLoadModel));
        }
    }

    public static CarbonLoadModel getCarbonLoadModel(Configuration hadoopConf) throws IOException {
        String value = hadoopConf.get(LOAD_Model);
        if (value == null) {
            return null;
        }
        return (CarbonLoadModel)ObjectSerializationUtil.convertStringToObject((String)value);
    }

    public static void setSegmentId(Configuration hadoopConf, String segmentId) {
        if (segmentId != null) {
            hadoopConf.set(SEGMENT_ID, segmentId);
        }
    }

    public static String getSegmentId(Configuration hadoopConf) {
        return hadoopConf.get(SEGMENT_ID);
    }
}

