/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.index.lucene;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.index.dev.IndexWriter;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.lucene50.Lucene50StoredFieldsFormat;
import org.apache.lucene.codecs.lucene62.Lucene62Codec;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.IntRangeField;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.solr.store.hdfs.HdfsDirectory;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.RoaringBitmap;

@InterfaceAudience.Internal
public class LuceneIndexWriter
extends IndexWriter {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)LuceneIndexWriter.class.getName());
    private org.apache.lucene.index.IndexWriter indexWriter = null;
    private Analyzer analyzer = null;
    public static final String PAGEID_NAME = "pageId";
    public static final String ROWID_NAME = "rowId";
    private Codec speedCodec = new Lucene62Codec(Lucene50StoredFieldsFormat.Mode.BEST_SPEED);
    private Codec compressionCodec = new Lucene62Codec(Lucene50StoredFieldsFormat.Mode.BEST_COMPRESSION);
    private Map<LuceneColumnKeys, Map<Integer, RoaringBitmap>> cache = new HashMap<LuceneColumnKeys, Map<Integer, RoaringBitmap>>();
    private int cacheSize;
    private ByteBuffer intBuffer = ByteBuffer.allocate(4);
    private boolean storeBlockletWise;
    private RAMDirectory ramDir;
    private org.apache.lucene.index.IndexWriter ramIndexWriter;

    LuceneIndexWriter(String tablePath, String indexName, List<CarbonColumn> indexColumns, Segment segment, String shardName, int flushSize, boolean storeBlockletWise) {
        super(tablePath, indexName, indexColumns, segment, shardName);
        this.cacheSize = flushSize;
        this.storeBlockletWise = storeBlockletWise;
    }

    public void onBlockStart(String blockId) {
    }

    public void onBlockEnd(String blockId) {
    }

    public void onBlockletStart(int blockletId) throws IOException {
        if (null == this.analyzer) {
            this.analyzer = CarbonProperties.getInstance().getProperty("carbon.lucene.index.stop.words", "false").equalsIgnoreCase("true") ? new StandardAnalyzer(CharArraySet.EMPTY_SET) : new StandardAnalyzer();
        }
        this.ramDir = new RAMDirectory();
        this.ramIndexWriter = new org.apache.lucene.index.IndexWriter((Directory)this.ramDir, new IndexWriterConfig(this.analyzer));
        if (this.indexWriter != null) {
            return;
        }
        String path = this.storeBlockletWise ? this.indexPath + File.separator + blockletId : this.indexPath;
        Path indexPath = FileFactory.getPath((String)path);
        FileSystem fs = FileFactory.getFileSystem((Path)indexPath);
        if (!fs.exists(indexPath) && !fs.mkdirs(indexPath)) {
            throw new IOException("Failed to create directory " + path);
        }
        Configuration conf = FileFactory.getConfiguration();
        conf.set("fs.hdfs.impl.disable.cache", "true");
        HdfsDirectory indexDir = new HdfsDirectory(indexPath, conf);
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(this.analyzer);
        if (CarbonProperties.getInstance().getProperty("carbon.lucene.compression.mode", "speed").equalsIgnoreCase("speed")) {
            indexWriterConfig.setCodec(this.speedCodec);
        } else {
            indexWriterConfig.setCodec(this.compressionCodec);
        }
        this.indexWriter = new org.apache.lucene.index.IndexWriter((Directory)indexDir, indexWriterConfig);
    }

    public void onBlockletEnd(int blockletId) throws IOException {
        this.ramIndexWriter.close();
        this.indexWriter.addIndexes(new Directory[]{this.ramDir});
        this.ramDir.close();
        if (this.storeBlockletWise) {
            LuceneIndexWriter.flushCache(this.cache, this.getIndexColumns(), this.indexWriter, this.storeBlockletWise);
            this.indexWriter.close();
            this.indexWriter = null;
        }
    }

    public void onPageAdded(int blockletId, int pageId, int pageSize, ColumnPage[] pages) throws IOException {
        int columnsCount = pages.length;
        if (columnsCount <= 0) {
            LOGGER.warn((Object)("No data in the page " + pageId + "with blockletid " + blockletId + " to write lucene index"));
            return;
        }
        for (int rowId = 0; rowId < pageSize; ++rowId) {
            LuceneColumnKeys columns = new LuceneColumnKeys(this.getIndexColumns().size());
            int i = 0;
            for (ColumnPage page : pages) {
                if (page.getNullBits().get(rowId)) continue;
                ((LuceneColumnKeys)columns).colValues[i++] = this.getValue(page, rowId);
            }
            if (this.cacheSize > 0) {
                LuceneIndexWriter.addToCache(columns, rowId, pageId, blockletId, this.cache, this.intBuffer, this.storeBlockletWise);
                continue;
            }
            LuceneIndexWriter.addData(columns, rowId, pageId, blockletId, this.intBuffer, this.ramIndexWriter, this.getIndexColumns(), this.storeBlockletWise);
        }
        if (this.cacheSize > 0) {
            this.flushCacheIfPossible();
        }
    }

    private static void addField(Document doc, Object key, String fieldName, Field.Store store) {
        if (key instanceof Byte) {
            byte value = (Byte)key;
            IntRangeField field = new IntRangeField(fieldName, new int[]{-128}, new int[]{127});
            field.setIntValue((int)value);
            doc.add((IndexableField)field);
            if (store == Field.Store.YES) {
                doc.add((IndexableField)new StoredField(fieldName, (int)value));
            }
        } else if (key instanceof Short) {
            short value = (Short)key;
            IntRangeField field = new IntRangeField(fieldName, new int[]{Short.MIN_VALUE}, new int[]{Short.MAX_VALUE});
            field.setShortValue(value);
            doc.add((IndexableField)field);
            if (store == Field.Store.YES) {
                doc.add((IndexableField)new StoredField(fieldName, (int)value));
            }
        } else if (key instanceof Integer) {
            int value = (Integer)key;
            doc.add((IndexableField)new IntPoint(fieldName, new int[]{value}));
            if (store == Field.Store.YES) {
                doc.add((IndexableField)new StoredField(fieldName, value));
            }
        } else if (key instanceof Long) {
            long value = (Long)key;
            doc.add((IndexableField)new LongPoint(fieldName, new long[]{value}));
            if (store == Field.Store.YES) {
                doc.add((IndexableField)new StoredField(fieldName, value));
            }
        } else if (key instanceof Float) {
            float value = ((Float)key).floatValue();
            doc.add((IndexableField)new FloatPoint(fieldName, new float[]{value}));
            if (store == Field.Store.YES) {
                doc.add((IndexableField)new FloatPoint(fieldName, new float[]{value}));
            }
        } else if (key instanceof Double) {
            double value = (Double)key;
            doc.add((IndexableField)new DoublePoint(fieldName, new double[]{value}));
            if (store == Field.Store.YES) {
                doc.add((IndexableField)new DoublePoint(fieldName, new double[]{value}));
            }
        } else if (key instanceof String) {
            String strValue = (String)key;
            doc.add((IndexableField)new TextField(fieldName, strValue, store));
        } else if (key instanceof Boolean) {
            boolean value = (Boolean)key;
            IntRangeField field = new IntRangeField(fieldName, new int[]{0}, new int[]{1});
            field.setIntValue(value ? 1 : 0);
            doc.add((IndexableField)field);
            if (store == Field.Store.YES) {
                doc.add((IndexableField)new StoredField(fieldName, value ? 1 : 0));
            }
        }
    }

    private Object getValue(ColumnPage page, int rowId) {
        DataType type = page.getColumnSpec().getSchemaDataType();
        Object value = null;
        if (type == DataTypes.BYTE) {
            value = page.getByte(rowId);
        } else if (type == DataTypes.SHORT) {
            value = page.getShort(rowId);
        } else if (type == DataTypes.INT) {
            value = page.getInt(rowId);
        } else if (type == DataTypes.LONG) {
            value = page.getLong(rowId);
        } else if (type == DataTypes.FLOAT) {
            value = Float.valueOf(page.getFloat(rowId));
        } else if (type == DataTypes.DOUBLE) {
            value = page.getDouble(rowId);
        } else if (type == DataTypes.STRING) {
            byte[] bytes = page.getBytes(rowId);
            try {
                value = new String(bytes, 2, bytes.length - 2, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        } else {
            if (type == DataTypes.DATE) {
                throw new RuntimeException("unsupported data type " + type);
            }
            if (type == DataTypes.TIMESTAMP) {
                throw new RuntimeException("unsupported data type " + type);
            }
            if (type == DataTypes.BOOLEAN) {
                value = page.getBoolean(rowId);
            } else {
                LOGGER.error((Object)("unsupported data type " + type));
                throw new RuntimeException("unsupported data type " + type);
            }
        }
        return value;
    }

    public static void addToCache(LuceneColumnKeys key, int rowId, int pageId, int blockletId, Map<LuceneColumnKeys, Map<Integer, RoaringBitmap>> cache, ByteBuffer intBuffer, boolean storeBlockletWise) {
        int combinKey;
        Map<Integer, RoaringBitmap> setMap = cache.get(key);
        if (setMap == null) {
            setMap = new HashMap<Integer, RoaringBitmap>();
            cache.put(key, setMap);
        }
        if (!storeBlockletWise) {
            intBuffer.clear();
            intBuffer.putShort((short)blockletId);
            intBuffer.putShort((short)pageId);
            intBuffer.rewind();
            combinKey = intBuffer.getInt();
        } else {
            combinKey = pageId;
        }
        RoaringBitmap bitSet = setMap.get(combinKey);
        if (bitSet == null) {
            bitSet = new RoaringBitmap();
            setMap.put(combinKey, bitSet);
        }
        bitSet.add(rowId);
    }

    public static void addData(LuceneColumnKeys key, int rowId, int pageId, int blockletId, ByteBuffer intBuffer, org.apache.lucene.index.IndexWriter indexWriter, List<CarbonColumn> indexCols, boolean storeBlockletWise) throws IOException {
        Document document = new Document();
        for (int i = 0; i < key.getColValues().length; ++i) {
            LuceneIndexWriter.addField(document, key.getColValues()[i], indexCols.get(i).getColName(), Field.Store.NO);
        }
        intBuffer.clear();
        if (storeBlockletWise) {
            intBuffer.putShort((short)pageId);
            intBuffer.putShort((short)rowId);
            intBuffer.rewind();
            document.add((IndexableField)new StoredField(ROWID_NAME, intBuffer.getInt()));
        } else {
            intBuffer.putShort((short)blockletId);
            intBuffer.putShort((short)pageId);
            intBuffer.rewind();
            document.add((IndexableField)new StoredField(PAGEID_NAME, intBuffer.getInt()));
            document.add((IndexableField)new StoredField(ROWID_NAME, (int)((short)rowId)));
        }
        indexWriter.addDocument((Iterable)document);
    }

    private void flushCacheIfPossible() throws IOException {
        if (this.cache.size() > this.cacheSize) {
            LuceneIndexWriter.flushCache(this.cache, this.getIndexColumns(), this.indexWriter, this.storeBlockletWise);
        }
    }

    public static void flushCache(Map<LuceneColumnKeys, Map<Integer, RoaringBitmap>> cache, List<CarbonColumn> indexCols, org.apache.lucene.index.IndexWriter indexWriter, boolean storeBlockletWise) throws IOException {
        for (Map.Entry<LuceneColumnKeys, Map<Integer, RoaringBitmap>> entry : cache.entrySet()) {
            Document document = new Document();
            LuceneColumnKeys key = entry.getKey();
            for (int i = 0; i < key.getColValues().length; ++i) {
                LuceneIndexWriter.addField(document, key.getColValues()[i], indexCols.get(i).getColName(), Field.Store.NO);
            }
            Map<Integer, RoaringBitmap> value = entry.getValue();
            int count = 0;
            for (Map.Entry<Integer, RoaringBitmap> pageData : value.entrySet()) {
                RoaringBitmap bitMap = pageData.getValue();
                int cardinality = bitMap.getCardinality();
                ByteBuffer byteBuffer = ByteBuffer.allocate(cardinality * 2 + 4);
                if (!storeBlockletWise) {
                    byteBuffer.putInt(pageData.getKey());
                } else {
                    byteBuffer.putShort(pageData.getKey().shortValue());
                }
                IntIterator intIterator = bitMap.getIntIterator();
                while (intIterator.hasNext()) {
                    byteBuffer.putShort((short)intIterator.next());
                }
                document.add((IndexableField)new StoredField(PAGEID_NAME + count, byteBuffer.array()));
                ++count;
            }
            indexWriter.addDocument((Iterable)document);
        }
        cache.clear();
    }

    public void finish() throws IOException {
        if (!this.isWritingFinished()) {
            LuceneIndexWriter.flushCache(this.cache, this.getIndexColumns(), this.indexWriter, this.storeBlockletWise);
            if (this.indexWriter != null) {
                this.indexWriter.close();
                this.indexWriter = null;
            }
            this.setWritingFinished(true);
        }
    }

    public static class LuceneColumnKeys {
        private Object[] colValues;

        public LuceneColumnKeys(int size) {
            this.colValues = new Object[size];
        }

        public Object[] getColValues() {
            return this.colValues;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LuceneColumnKeys that = (LuceneColumnKeys)o;
            return Arrays.equals(this.colValues, that.colValues);
        }

        public int hashCode() {
            return Arrays.hashCode(this.colValues);
        }
    }
}

