/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.index.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.exceptions.sql.MalformedIndexCommandException;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.index.IndexInputSplit;
import org.apache.carbondata.core.index.IndexLevel;
import org.apache.carbondata.core.index.IndexMeta;
import org.apache.carbondata.core.index.IndexStoreManager;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.index.TableIndex;
import org.apache.carbondata.core.index.dev.Index;
import org.apache.carbondata.core.index.dev.IndexBuilder;
import org.apache.carbondata.core.index.dev.IndexFactory;
import org.apache.carbondata.core.index.dev.IndexWriter;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.IndexSchema;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.events.Event;
import org.apache.carbondata.index.lucene.LuceneIndexBuilder;
import org.apache.carbondata.index.lucene.LuceneIndexInputSplit;
import org.apache.carbondata.index.lucene.LuceneIndexWriter;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

@InterfaceAudience.Internal
abstract class LuceneIndexFactoryBase<T extends Index>
extends IndexFactory<T> {
    static final String FLUSH_CACHE = "flush_cache";
    static final String FLUSH_CACHE_DEFAULT_SIZE = "-1";
    static final String SPLIT_BLOCKLET = "split_blocklet";
    static final String SPLIT_BLOCKLET_DEFAULT = "true";
    final Logger LOGGER = LogServiceFactory.getLogService((String)((Object)((Object)this)).getClass().getName());
    IndexMeta indexMeta = null;
    Analyzer analyzer = null;
    String indexName = null;
    AbsoluteTableIdentifier tableIdentifier = null;
    List<CarbonColumn> indexedCarbonColumns = null;
    int flushCacheSize;
    boolean storeBlockletWise;

    public LuceneIndexFactoryBase(CarbonTable carbonTable, IndexSchema indexSchema) throws MalformedIndexCommandException {
        super(carbonTable, indexSchema);
        Objects.requireNonNull(carbonTable.getAbsoluteTableIdentifier());
        Objects.requireNonNull(indexSchema);
        this.tableIdentifier = carbonTable.getAbsoluteTableIdentifier();
        this.indexName = indexSchema.getIndexName();
        this.indexedCarbonColumns = carbonTable.getIndexedColumns(indexSchema.getIndexColumns());
        this.flushCacheSize = LuceneIndexFactoryBase.validateAndGetWriteCacheSize(indexSchema);
        this.storeBlockletWise = LuceneIndexFactoryBase.validateAndGetStoreBlockletWise(indexSchema);
        ArrayList<ExpressionType> optimizedOperations = new ArrayList<ExpressionType>();
        optimizedOperations.add(ExpressionType.TEXT_MATCH);
        this.indexMeta = new IndexMeta(this.indexedCarbonColumns, optimizedOperations);
        this.analyzer = new StandardAnalyzer();
    }

    public static int validateAndGetWriteCacheSize(IndexSchema schema) {
        int cacheSize;
        String cacheStr = (String)schema.getProperties().get(FLUSH_CACHE);
        if (cacheStr == null) {
            cacheStr = FLUSH_CACHE_DEFAULT_SIZE;
        }
        try {
            cacheSize = Integer.parseInt(cacheStr);
        }
        catch (NumberFormatException e) {
            cacheSize = -1;
        }
        return cacheSize;
    }

    public static boolean validateAndGetStoreBlockletWise(IndexSchema schema) {
        boolean splitBlockletWise;
        String splitBlockletStr = (String)schema.getProperties().get(SPLIT_BLOCKLET);
        if (splitBlockletStr == null) {
            splitBlockletStr = SPLIT_BLOCKLET_DEFAULT;
        }
        try {
            splitBlockletWise = Boolean.parseBoolean(splitBlockletStr);
        }
        catch (NumberFormatException e) {
            splitBlockletWise = true;
        }
        return splitBlockletWise;
    }

    private void deleteIndex() throws MalformedIndexCommandException {
        SegmentStatusManager ssm = new SegmentStatusManager(this.tableIdentifier);
        try {
            List validSegments = ssm.getValidAndInvalidSegments(Boolean.valueOf(this.getCarbonTable().isMV())).getValidSegments();
            for (Segment segment : validSegments) {
                this.deleteIndexData(segment);
            }
        }
        catch (IOException | RuntimeException ex) {
            throw new MalformedIndexCommandException("drop index failed, failed to delete index directory");
        }
    }

    public IndexWriter createWriter(Segment segment, String shardName, SegmentProperties segmentProperties) {
        this.LOGGER.info((Object)("lucene data write to " + shardName));
        return new LuceneIndexWriter(this.getCarbonTable().getTablePath(), this.indexName, this.indexMeta.getIndexedColumns(), segment, shardName, this.flushCacheSize, this.storeBlockletWise);
    }

    public IndexBuilder createBuilder(Segment segment, String shardName, SegmentProperties segmentProperties) {
        return new LuceneIndexBuilder(this.getCarbonTable().getTablePath(), this.indexName, segment, shardName, this.indexMeta.getIndexedColumns(), this.flushCacheSize, this.storeBlockletWise);
    }

    public List<IndexInputSplit> toDistributable(Segment segment) {
        ArrayList<IndexInputSplit> splits = new ArrayList<IndexInputSplit>();
        CarbonFile[] indexDirs = this.getAllIndexDirs(this.tableIdentifier.getTablePath(), segment.getSegmentNo());
        if (segment.getFilteredIndexShardNames().size() == 0) {
            for (CarbonFile indexDir : indexDirs) {
                LuceneIndexInputSplit luceneIndexInputSplit = new LuceneIndexInputSplit(this.tableIdentifier.getTablePath(), indexDir.getAbsolutePath());
                luceneIndexInputSplit.setSegment(segment);
                luceneIndexInputSplit.setIndexSchema(this.getIndexSchema());
                splits.add(luceneIndexInputSplit);
            }
            return splits;
        }
        for (CarbonFile indexDir : indexDirs) {
            if (this.getIndexLevel() != IndexLevel.FG && !segment.getFilteredIndexShardNames().contains(indexDir.getName())) continue;
            LuceneIndexInputSplit luceneIndexInputSplit = new LuceneIndexInputSplit(CarbonTablePath.getSegmentPath((String)this.tableIdentifier.getTablePath(), (String)segment.getSegmentNo()), indexDir.getAbsolutePath());
            luceneIndexInputSplit.setSegment(segment);
            luceneIndexInputSplit.setIndexSchema(this.getIndexSchema());
            splits.add(luceneIndexInputSplit);
        }
        return splits;
    }

    public void fireEvent(Event event) {
    }

    public void clear() {
    }

    public void deleteIndexData(Segment segment) throws IOException {
        this.deleteSegmentIndexData(segment.getSegmentNo());
    }

    public void deleteSegmentIndexData(String segmentId) throws IOException {
        try {
            String indexPath = CarbonTablePath.getIndexesStorePath((String)this.tableIdentifier.getTablePath(), (String)segmentId, (String)this.indexName);
            if (FileFactory.isFileExist((String)indexPath)) {
                CarbonFile file = FileFactory.getCarbonFile((String)indexPath);
                CarbonUtil.deleteFoldersAndFilesSilent((CarbonFile[])new CarbonFile[]{file});
            }
        }
        catch (InterruptedException ex) {
            throw new IOException("drop index failed, failed to delete index directory");
        }
    }

    public void deleteIndexData() {
        try {
            this.deleteIndex();
        }
        catch (MalformedIndexCommandException ex) {
            this.LOGGER.error((Object)"failed to delete index directory ", (Throwable)ex);
        }
    }

    public IndexMeta getMeta() {
        return this.indexMeta;
    }

    private CarbonFile[] getAllIndexDirs(String tablePath, String segmentId) {
        ArrayList<CarbonFile> indexDirs = new ArrayList<CarbonFile>();
        List indexes = new ArrayList();
        try {
            indexes = IndexStoreManager.getInstance().getAllCGAndFGIndexes(this.getCarbonTable());
        }
        catch (IOException ex) {
            this.LOGGER.error((Object)"failed to get indexes");
        }
        if (indexes.size() > 0) {
            for (TableIndex index : indexes) {
                if (!index.getIndexSchema().getIndexName().equals(this.indexName)) continue;
                String dmPath = CarbonTablePath.getIndexesStorePath((String)tablePath, (String)segmentId, (String)index.getIndexSchema().getIndexName());
                CarbonFile dirPath = FileFactory.getCarbonFile((String)dmPath);
                List<CarbonFile> indexFiles = Arrays.asList(dirPath.listFiles(new CarbonFileFilter(){

                    public boolean accept(CarbonFile file) {
                        return file.isDirectory();
                    }
                }));
                indexDirs.addAll(indexFiles);
            }
        }
        return indexDirs.toArray(new CarbonFile[0]);
    }
}

