/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.index.lucene;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.index.dev.IndexBuilder;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.index.lucene.LuceneIndexWriter;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.lucene50.Lucene50StoredFieldsFormat;
import org.apache.lucene.codecs.lucene62.Lucene62Codec;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.solr.store.hdfs.HdfsDirectory;
import org.roaringbitmap.RoaringBitmap;

public class LuceneIndexBuilder
implements IndexBuilder {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)LuceneIndexWriter.class.getName());
    private String indexPath;
    private List<CarbonColumn> indexColumns;
    private int columnsCount;
    private IndexWriter indexWriter = null;
    private Analyzer analyzer = null;
    private int writeCacheSize;
    private Map<LuceneIndexWriter.LuceneColumnKeys, Map<Integer, RoaringBitmap>> cache = new HashMap<LuceneIndexWriter.LuceneColumnKeys, Map<Integer, RoaringBitmap>>();
    private ByteBuffer intBuffer = ByteBuffer.allocate(4);
    private boolean storeBlockletWise;
    private int currentBlockletId = -1;

    LuceneIndexBuilder(String tablePath, String indexName, Segment segment, String shardName, List<CarbonColumn> indexColumns, int writeCacheSize, boolean storeBlockletWise) {
        this.indexPath = CarbonTablePath.getIndexStorePathOnShardName((String)tablePath, (String)segment.getSegmentNo(), (String)indexName, (String)shardName);
        this.indexColumns = indexColumns;
        this.columnsCount = indexColumns.size();
        this.writeCacheSize = writeCacheSize;
        this.storeBlockletWise = storeBlockletWise;
    }

    public void initialize() throws IOException {
        if (!this.storeBlockletWise) {
            this.indexWriter = this.createIndexWriter(this.indexPath);
        }
    }

    private IndexWriter createIndexWriter(String path) throws IOException {
        Path indexPath = FileFactory.getPath((String)path);
        FileSystem fs = FileFactory.getFileSystem((Path)indexPath);
        if (fs.exists(indexPath)) {
            fs.delete(indexPath, true);
        }
        if (!fs.mkdirs(indexPath)) {
            LOGGER.error((Object)("Failed to create directory " + indexPath));
        }
        if (null == this.analyzer) {
            this.analyzer = new StandardAnalyzer();
        }
        HdfsDirectory indexDir = new HdfsDirectory(indexPath, FileFactory.getConfiguration());
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(this.analyzer);
        if (CarbonProperties.getInstance().getProperty("carbon.lucene.compression.mode", "speed").equalsIgnoreCase("speed")) {
            indexWriterConfig.setCodec((Codec)new Lucene62Codec(Lucene50StoredFieldsFormat.Mode.BEST_SPEED));
        } else {
            indexWriterConfig.setCodec((Codec)new Lucene62Codec(Lucene50StoredFieldsFormat.Mode.BEST_COMPRESSION));
        }
        return new IndexWriter((Directory)indexDir, new IndexWriterConfig(this.analyzer));
    }

    public void addRow(int blockletId, int pageId, int rowId, Object[] values) throws IOException {
        if (this.storeBlockletWise && this.currentBlockletId != blockletId) {
            this.close();
            this.indexWriter = this.createIndexWriter(this.indexPath + File.separator + blockletId);
            this.currentBlockletId = blockletId;
        }
        LuceneIndexWriter.LuceneColumnKeys columns = new LuceneIndexWriter.LuceneColumnKeys(this.columnsCount);
        for (int colIdx = 0; colIdx < this.columnsCount; ++colIdx) {
            columns.getColValues()[colIdx] = values[colIdx];
        }
        if (this.writeCacheSize > 0) {
            LuceneIndexWriter.addToCache(columns, rowId, pageId, blockletId, this.cache, this.intBuffer, this.storeBlockletWise);
            this.flushCacheIfPossible();
        } else {
            LuceneIndexWriter.addData(columns, rowId, pageId, blockletId, this.intBuffer, this.indexWriter, this.indexColumns, this.storeBlockletWise);
        }
    }

    private void flushCacheIfPossible() throws IOException {
        if (this.cache.size() >= this.writeCacheSize) {
            LuceneIndexWriter.flushCache(this.cache, this.indexColumns, this.indexWriter, this.storeBlockletWise);
        }
    }

    public void finish() throws IOException {
        LuceneIndexWriter.flushCache(this.cache, this.indexColumns, this.indexWriter, this.storeBlockletWise);
    }

    public void close() throws IOException {
        if (this.indexWriter != null) {
            this.indexWriter.close();
        }
    }

    public boolean isIndexForCarbonRawBytes() {
        return false;
    }
}

