/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.index.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.exceptions.sql.MalformedIndexCommandException;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.features.TableOperation;
import org.apache.carbondata.core.index.IndexInputSplit;
import org.apache.carbondata.core.index.IndexLevel;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.index.dev.IndexModel;
import org.apache.carbondata.core.index.dev.IndexWriter;
import org.apache.carbondata.core.index.dev.fgindex.FineGrainIndex;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.IndexSchema;
import org.apache.carbondata.index.lucene.LuceneFineGrainIndex;
import org.apache.carbondata.index.lucene.LuceneIndexFactoryBase;
import org.apache.carbondata.index.lucene.LuceneIndexInputSplit;
import org.apache.hadoop.fs.Path;

@InterfaceAudience.Internal
public class LuceneFineGrainIndexFactory
extends LuceneIndexFactoryBase<FineGrainIndex> {
    public LuceneFineGrainIndexFactory(CarbonTable carbonTable, IndexSchema indexSchema) throws MalformedIndexCommandException {
        super(carbonTable, indexSchema);
    }

    public List<FineGrainIndex> getIndexes(Segment segment) throws IOException {
        ArrayList<FineGrainIndex> indexes = new ArrayList<FineGrainIndex>();
        LuceneFineGrainIndex index = new LuceneFineGrainIndex(this.analyzer, this.getIndexSchema());
        index.init(new IndexModel(IndexWriter.getDefaultIndexPath((String)this.tableIdentifier.getTablePath(), (String)segment.getSegmentNo(), (String)this.indexName), segment.getConfiguration()));
        indexes.add(index);
        return indexes;
    }

    public List<FineGrainIndex> getIndexes(Segment segment, Set<Path> partitionLocations) throws IOException {
        return this.getIndexes(segment);
    }

    public List<FineGrainIndex> getIndexes(IndexInputSplit distributable) throws IOException {
        ArrayList<FineGrainIndex> indexes = new ArrayList<FineGrainIndex>();
        LuceneFineGrainIndex index = new LuceneFineGrainIndex(this.analyzer, this.getIndexSchema());
        String indexPath = ((LuceneIndexInputSplit)distributable).getIndexPath();
        index.init(new IndexModel(indexPath, FileFactory.getConfiguration()));
        indexes.add(index);
        return indexes;
    }

    public IndexLevel getIndexLevel() {
        return IndexLevel.FG;
    }

    public boolean willBecomeStale(TableOperation operation) {
        switch (operation) {
            case ALTER_RENAME: {
                return true;
            }
            case ALTER_DROP: {
                return true;
            }
            case ALTER_ADD_COLUMN: {
                return true;
            }
            case ALTER_CHANGE_DATATYPE: {
                return true;
            }
            case ALTER_COLUMN_RENAME: {
                return true;
            }
            case STREAMING: {
                return false;
            }
            case DELETE: {
                return true;
            }
            case UPDATE: {
                return true;
            }
            case PARTITION: {
                return true;
            }
        }
        return false;
    }
}

