/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.index.lucene;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.index.dev.IndexModel;
import org.apache.carbondata.core.index.dev.fgindex.FineGrainBlocklet;
import org.apache.carbondata.core.index.dev.fgindex.FineGrainIndex;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.IndexSchema;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.MatchExpression;
import org.apache.carbondata.core.scan.filter.executer.FilterExecuter;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.index.lucene.LuceneIndexFactoryBase;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.store.hdfs.HdfsDirectory;

@InterfaceAudience.Internal
public class LuceneFineGrainIndex
extends FineGrainIndex {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)LuceneFineGrainIndex.class.getName());
    private static final int SEARCH_LIMIT = 100;
    private Map<String, IndexSearcher> indexSearcherMap = null;
    private Analyzer analyzer;
    private String filePath;
    private int writeCacheSize;
    private boolean storeBlockletWise;
    private IndexReader indexReader;

    LuceneFineGrainIndex(Analyzer analyzer, IndexSchema schema) {
        this.analyzer = analyzer;
        this.writeCacheSize = LuceneIndexFactoryBase.validateAndGetWriteCacheSize(schema);
        this.storeBlockletWise = LuceneIndexFactoryBase.validateAndGetStoreBlockletWise(schema);
    }

    public void init(IndexModel indexModel) throws IOException {
        long startTime = System.currentTimeMillis();
        Path indexPath = FileFactory.getPath((String)indexModel.getFilePath());
        LOGGER.info((Object)("Lucene index read path " + indexPath.toString()));
        this.filePath = indexPath.getName();
        this.indexSearcherMap = new HashMap<String, IndexSearcher>();
        CarbonFile indexFilePath = FileFactory.getCarbonFile((String)indexPath.toString());
        if (!indexFilePath.exists()) {
            String errorMessage = String.format("index directory %s not exists.", indexPath);
            LOGGER.error((Object)errorMessage);
            throw new IOException(errorMessage);
        }
        if (!indexFilePath.isDirectory()) {
            String errorMessage = String.format("error index path %s, must be directory", indexPath);
            LOGGER.error((Object)errorMessage);
            throw new IOException(errorMessage);
        }
        if (this.storeBlockletWise) {
            CarbonFile[] blockletDirs;
            for (CarbonFile blockletDir : blockletDirs = indexFilePath.listFiles()) {
                IndexSearcher indexSearcher = this.createIndexSearcher(new Path(blockletDir.getAbsolutePath()));
                this.indexSearcherMap.put(blockletDir.getName(), indexSearcher);
            }
        } else {
            IndexSearcher indexSearcher = this.createIndexSearcher(indexPath);
            this.indexSearcherMap.put("-1", indexSearcher);
        }
        LOGGER.info((Object)("Time taken to initialize lucene searcher: " + (System.currentTimeMillis() - startTime)));
    }

    private IndexSearcher createIndexSearcher(Path indexPath) throws IOException {
        HdfsDirectory indexDir = new HdfsDirectory(indexPath, FileFactory.getConfiguration());
        this.indexReader = DirectoryReader.open((Directory)indexDir);
        if (this.indexReader == null) {
            throw new RuntimeException("failed to create index reader object");
        }
        return new IndexSearcher(this.indexReader);
    }

    private String getQueryString(Expression expression) {
        if (expression.getFilterExpressionType() == ExpressionType.TEXT_MATCH) {
            return expression.getString();
        }
        for (Expression child : expression.getChildren()) {
            String queryString = this.getQueryString(child);
            if (queryString == null) continue;
            return queryString;
        }
        return null;
    }

    private int getMaxDoc(Expression expression) {
        if (expression.getFilterExpressionType() == ExpressionType.TEXT_MATCH) {
            int maxDoc = ((MatchExpression)expression).getMaxDoc();
            if (maxDoc < 0) {
                maxDoc = Integer.MAX_VALUE;
            }
            return maxDoc;
        }
        Iterator iterator = expression.getChildren().iterator();
        if (iterator.hasNext()) {
            Expression child = (Expression)iterator.next();
            return this.getMaxDoc(child);
        }
        return Integer.MAX_VALUE;
    }

    public List<FineGrainBlocklet> prune(FilterResolverIntf filterExp, SegmentProperties segmentProperties, FilterExecuter filterExecuter, CarbonTable carbonTable) throws IOException {
        Query query;
        int maxDocs;
        ArrayList fields = new ArrayList();
        String strQuery = this.getQueryString(filterExp.getFilterExpression());
        try {
            maxDocs = this.getMaxDoc(filterExp.getFilterExpression());
        }
        catch (NumberFormatException e) {
            maxDocs = Integer.MAX_VALUE;
        }
        if (null == strQuery) {
            return null;
        }
        String[] sFields = new String[fields.size()];
        fields.toArray(sFields);
        if (this.analyzer == null) {
            this.analyzer = new StandardAnalyzer();
        }
        MultiFieldQueryParser queryParser = new MultiFieldQueryParser(sFields, this.analyzer);
        queryParser.setAllowLeadingWildcard(true);
        try {
            query = queryParser.parse(strQuery);
        }
        catch (ParseException e) {
            String errorMessage = String.format("failed to filter block with query %s, detail is %s", strQuery, e.getMessage());
            LOGGER.error((Object)errorMessage, (Throwable)e);
            return null;
        }
        HashMap<String, Map<Integer, List<Short>>> mapBlocks = new HashMap<String, Map<Integer, List<Short>>>();
        long luceneSearchStartTime = System.currentTimeMillis();
        block6: for (Map.Entry<String, IndexSearcher> searcherEntry : this.indexSearcherMap.entrySet()) {
            IndexSearcher indexSearcher = searcherEntry.getValue();
            maxDocs = Math.min(maxDocs, indexSearcher.getIndexReader().maxDoc());
            TopDocs result = null;
            int numberOfDocumentsToBeQueried = 0;
            int documentHitCounter = 0;
            try {
                numberOfDocumentsToBeQueried = Math.min(maxDocs, 100);
                result = indexSearcher.search(query, numberOfDocumentsToBeQueried);
                documentHitCounter += numberOfDocumentsToBeQueried;
            }
            catch (IOException e) {
                String errorMessage = String.format("failed to search lucene data, detail is %s", e.getMessage());
                LOGGER.error((Object)errorMessage, (Throwable)e);
                throw new IOException(errorMessage, e);
            }
            ByteBuffer intBuffer = ByteBuffer.allocate(4);
            ScoreDoc lastScoreDoc = null;
            while (true) {
                for (ScoreDoc scoreDoc : result.scoreDocs) {
                    Document doc = indexSearcher.doc(scoreDoc.doc);
                    List fieldsInDoc = doc.getFields();
                    if (this.writeCacheSize > 0) {
                        this.fillMapForCombineRows(intBuffer, mapBlocks, fieldsInDoc, searcherEntry.getKey());
                    } else {
                        this.fillMap(intBuffer, mapBlocks, fieldsInDoc, searcherEntry.getKey());
                    }
                    lastScoreDoc = scoreDoc;
                }
                int remainingHits = result.totalHits - documentHitCounter;
                if (remainingHits <= 0 || documentHitCounter >= maxDocs) continue block6;
                numberOfDocumentsToBeQueried = Math.min(remainingHits, 100);
                result = indexSearcher.searchAfter(lastScoreDoc, query, numberOfDocumentsToBeQueried);
                documentHitCounter += numberOfDocumentsToBeQueried;
            }
        }
        LOGGER.info((Object)("Time taken for lucene search: " + (System.currentTimeMillis() - luceneSearchStartTime) + " ms"));
        ArrayList<FineGrainBlocklet> blocklets = new ArrayList<FineGrainBlocklet>();
        for (Map.Entry mapBlocklet : mapBlocks.entrySet()) {
            String blockletId = (String)mapBlocklet.getKey();
            Map mapPageIds = (Map)mapBlocklet.getValue();
            ArrayList<FineGrainBlocklet.Page> pages = new ArrayList<FineGrainBlocklet.Page>();
            for (Map.Entry mapPageId : mapPageIds.entrySet()) {
                int[] rowIds = new int[((List)mapPageId.getValue()).size()];
                int i = 0;
                for (Short rowid : (List)mapPageId.getValue()) {
                    rowIds[i++] = rowid.shortValue();
                }
                FineGrainBlocklet.Page page = new FineGrainBlocklet.Page();
                page.setPageId(((Integer)mapPageId.getKey()).intValue());
                page.setRowId(rowIds);
                pages.add(page);
            }
            blocklets.add(new FineGrainBlocklet(this.filePath, blockletId, pages));
        }
        return blocklets;
    }

    private void fillMapForCombineRows(ByteBuffer intBuffer, Map<String, Map<Integer, List<Short>>> mapBlocks, List<IndexableField> fieldsInDoc, String blockletId) {
        for (int i = 0; i < fieldsInDoc.size(); ++i) {
            List<Short> setRowId;
            short pageId;
            BytesRef bytesRef = fieldsInDoc.get(i).binaryValue();
            ByteBuffer buffer = ByteBuffer.wrap(bytesRef.bytes);
            if (this.storeBlockletWise) {
                pageId = buffer.getShort();
            } else {
                int combineKey = buffer.getInt();
                intBuffer.clear();
                intBuffer.putInt(combineKey);
                intBuffer.rewind();
                blockletId = String.valueOf(intBuffer.getShort());
                pageId = intBuffer.getShort();
            }
            Map<Integer, List<Short>> mapPageIds = mapBlocks.get(blockletId);
            if (mapPageIds == null) {
                mapPageIds = new HashMap<Integer, List<Short>>();
                mapBlocks.put(blockletId, mapPageIds);
            }
            if ((setRowId = mapPageIds.get(pageId)) == null) {
                setRowId = new ArrayList<Short>();
                mapPageIds.put(Integer.valueOf(pageId), setRowId);
            }
            while (buffer.hasRemaining()) {
                setRowId.add(buffer.getShort());
            }
        }
    }

    private void fillMap(ByteBuffer intBuffer, Map<String, Map<Integer, List<Short>>> mapBlocks, List<IndexableField> fieldsInDoc, String blockletId) {
        List<Short> setRowId;
        short rowId;
        short pageId;
        int combineKey = fieldsInDoc.get(0).numericValue().intValue();
        intBuffer.clear();
        intBuffer.putInt(combineKey);
        intBuffer.rewind();
        if (this.storeBlockletWise) {
            pageId = intBuffer.getShort();
            rowId = intBuffer.getShort();
        } else {
            blockletId = String.valueOf(intBuffer.getShort());
            pageId = intBuffer.getShort();
            rowId = fieldsInDoc.get(1).numericValue().shortValue();
        }
        Map<Integer, List<Short>> mapPageIds = mapBlocks.get(blockletId);
        if (mapPageIds == null) {
            mapPageIds = new HashMap<Integer, List<Short>>();
            mapBlocks.put(blockletId, mapPageIds);
        }
        if ((setRowId = mapPageIds.get(pageId)) == null) {
            setRowId = new ArrayList<Short>();
            mapPageIds.put(Integer.valueOf(pageId), setRowId);
        }
        setRowId.add(rowId);
    }

    public boolean isScanRequired(FilterResolverIntf filterExp) {
        return true;
    }

    public void clear() {
    }

    public void finish() {
        if (null != this.indexReader) {
            try {
                int referenceCount = this.indexReader.getRefCount();
                if (referenceCount > 0) {
                    this.indexReader.decRef();
                    if (null != this.indexSearcherMap) {
                        this.indexSearcherMap.clear();
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"Ignoring the exception, Error while closing the lucene index reader", (Throwable)e);
            }
        }
    }
}

