/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.FileReader;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.StructField;
import org.apache.carbondata.core.scan.executor.QueryExecutor;
import org.apache.carbondata.core.scan.executor.QueryExecutorFactory;
import org.apache.carbondata.core.scan.executor.exception.QueryExecutionException;
import org.apache.carbondata.core.scan.model.ProjectionDimension;
import org.apache.carbondata.core.scan.model.ProjectionMeasure;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.scan.result.iterator.AbstractDetailQueryResultIterator;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnarBatch;
import org.apache.carbondata.core.scan.result.vector.impl.CarbonColumnVectorImpl;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.hadoop.AbstractRecordReader;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;

public class CarbonVectorizedRecordReader
extends AbstractRecordReader<Object> {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonVectorizedRecordReader.class.getName());
    private CarbonColumnarBatch carbonColumnarBatch;
    private QueryExecutor queryExecutor;
    private int batchIdx = 0;
    private int numBatched = 0;
    private AbstractDetailQueryResultIterator iterator;
    private QueryModel queryModel;
    private List<Integer> projectionMapping = new ArrayList<Integer>();

    public CarbonVectorizedRecordReader(QueryModel queryModel) {
        this.queryModel = queryModel;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException {
        if (inputSplit instanceof CarbonInputSplit) {
            CarbonInputSplit carbonInputSplit = (CarbonInputSplit)inputSplit;
            String splitPath = carbonInputSplit.getFilePath();
            if (null != carbonInputSplit.getDetailInfo() && carbonInputSplit.getDetailInfo().getBlockFooterOffset() == 0L || null == carbonInputSplit.getDetailInfo() && carbonInputSplit.getStart() == 0L) {
                FileReader reader = FileFactory.getFileHolder((FileFactory.FileType)FileFactory.getFileType((String)splitPath), (Configuration)taskAttemptContext.getConfiguration());
                ByteBuffer buffer = reader.readByteBuffer(FileFactory.getUpdatedFilePath((String)splitPath), ((CarbonInputSplit)inputSplit).getLength() - 8L, 8);
                if (carbonInputSplit.getDetailInfo() == null) {
                    carbonInputSplit.setStart(buffer.getLong());
                } else {
                    carbonInputSplit.getDetailInfo().setBlockFooterOffset(buffer.getLong());
                }
                reader.finish();
            }
        } else {
            throw new RuntimeException("unsupported input split type: " + inputSplit);
        }
        ArrayList<CarbonInputSplit> splitList = new ArrayList<CarbonInputSplit>(1);
        splitList.add((CarbonInputSplit)inputSplit);
        List tableBlockInfoList = CarbonInputSplit.createBlocks(splitList);
        this.queryModel.setTableBlockInfos(tableBlockInfoList);
        this.queryModel.setVectorReader(true);
        try {
            this.queryExecutor = QueryExecutorFactory.getQueryExecutor((QueryModel)this.queryModel, (Configuration)taskAttemptContext.getConfiguration());
            this.iterator = (AbstractDetailQueryResultIterator)this.queryExecutor.execute(this.queryModel);
            this.initBatch();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw e;
        }
    }

    public boolean nextKeyValue() {
        if (this.batchIdx >= this.numBatched && !this.nextBatch()) {
            return false;
        }
        ++this.batchIdx;
        return true;
    }

    private boolean nextBatch() {
        this.carbonColumnarBatch.reset();
        if (this.iterator.hasNext()) {
            this.iterator.processNextBatch(this.carbonColumnarBatch);
            this.numBatched = this.carbonColumnarBatch.getActualSize();
            if (this.numBatched == 0) {
                return this.nextBatch();
            }
            this.batchIdx = 0;
            return true;
        }
        return false;
    }

    private void initBatch() {
        if (this.carbonColumnarBatch == null) {
            List queryDimension = this.queryModel.getProjectionDimensions();
            List queryMeasures = this.queryModel.getProjectionMeasures();
            StructField[] fields = new StructField[queryDimension.size() + queryMeasures.size()];
            for (ProjectionDimension dim : queryDimension) {
                fields[dim.getOrdinal()] = new StructField(dim.getColumnName(), dim.getDimension().getDataType());
            }
            for (ProjectionMeasure msr : queryMeasures) {
                DataType dataType = msr.getMeasure().getDataType();
                if (dataType == DataTypes.BOOLEAN || dataType == DataTypes.SHORT || dataType == DataTypes.INT || dataType == DataTypes.LONG || dataType == DataTypes.FLOAT || dataType == DataTypes.BYTE || dataType == DataTypes.BINARY) {
                    fields[msr.getOrdinal()] = new StructField(msr.getColumnName(), msr.getMeasure().getDataType());
                    continue;
                }
                if (DataTypes.isDecimal((DataType)dataType)) {
                    fields[msr.getOrdinal()] = new StructField(msr.getColumnName(), (DataType)DataTypes.createDecimalType((int)msr.getMeasure().getPrecision(), (int)msr.getMeasure().getScale()));
                    continue;
                }
                fields[msr.getOrdinal()] = new StructField(msr.getColumnName(), DataTypes.DOUBLE);
            }
            CarbonColumnVector[] vectors = new CarbonColumnVector[fields.length];
            HashMap<String, Integer> colmap = new HashMap<String, Integer>();
            for (int i = 0; i < fields.length; ++i) {
                vectors[i] = new CarbonColumnVectorImpl(32000, fields[i].getDataType());
                if (colmap.containsKey(fields[i].getFieldName())) {
                    int reusedIndex = (Integer)colmap.get(fields[i].getFieldName());
                    this.projectionMapping.add(reusedIndex);
                    continue;
                }
                colmap.put(fields[i].getFieldName(), i);
                this.projectionMapping.add(i);
            }
            this.carbonColumnarBatch = new CarbonColumnarBatch(vectors, 32000, new boolean[0]);
        }
    }

    public Object getCurrentValue() {
        ++this.rowCount;
        Object[] row = new Object[this.projectionMapping.size()];
        for (int i = 0; i < this.projectionMapping.size(); ++i) {
            if (this.projectionMapping.get(i) < i) {
                row[i] = row[this.projectionMapping.get(i)];
                continue;
            }
            Object data = this.carbonColumnarBatch.columnVectors[this.projectionMapping.get(i)].getData(this.batchIdx - 1);
            if (this.carbonColumnarBatch.columnVectors[i].getType() == DataTypes.STRING || this.carbonColumnarBatch.columnVectors[i].getType() == DataTypes.VARCHAR) {
                if (data == null) {
                    row[i] = null;
                    continue;
                }
                row[i] = ByteUtil.toString((byte[])((byte[])data), (int)0, (int)((byte[])data).length);
                continue;
            }
            if (this.carbonColumnarBatch.columnVectors[i].getType() == DataTypes.BOOLEAN) {
                if (data == null) {
                    row[i] = null;
                    continue;
                }
                row[i] = ByteUtil.toBoolean((byte)((Byte)data));
                continue;
            }
            row[i] = this.carbonColumnarBatch.columnVectors[this.projectionMapping.get(i)].getData(this.batchIdx - 1);
        }
        return row;
    }

    public Void getCurrentKey() {
        throw new UnsupportedOperationException("Operation not allowed on CarbonVectorizedReader");
    }

    public float getProgress() {
        return 0.0f;
    }

    public void close() throws IOException {
        this.logStatistics(this.rowCount, this.queryModel.getStatisticsRecorder());
        if (this.carbonColumnarBatch != null) {
            this.carbonColumnarBatch = null;
        }
        if (this.iterator != null) {
            this.iterator.close();
        }
        try {
            this.queryExecutor.finish();
        }
        catch (QueryExecutionException e) {
            throw new IOException(e);
        }
    }
}

