/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.carbondata.core.datastore.block.Distributable;
import org.apache.carbondata.hadoop.CarbonInputSplit;

public class CarbonInputSplitTaskInfo
implements Distributable {
    private final List<CarbonInputSplit> carbonBlockInfoList;
    private final String taskId;

    public String getTaskId() {
        return this.taskId;
    }

    public List<CarbonInputSplit> getCarbonInputSplitList() {
        return this.carbonBlockInfoList;
    }

    public CarbonInputSplitTaskInfo(String taskId, List<CarbonInputSplit> carbonSplitListInfo) {
        this.taskId = taskId;
        this.carbonBlockInfoList = carbonSplitListInfo;
    }

    public String[] getLocations() {
        HashSet<String> locations = new HashSet<String>();
        for (CarbonInputSplit splitInfo : this.carbonBlockInfoList) {
            try {
                locations.addAll(Arrays.asList(splitInfo.getLocations()));
            }
            catch (IOException e) {
                throw new RuntimeException("Fail to get location of split: " + splitInfo, e);
            }
        }
        locations.toArray(new String[locations.size()]);
        List<String> nodes = CarbonInputSplitTaskInfo.maxNoNodes(this.carbonBlockInfoList);
        return nodes.toArray(new String[nodes.size()]);
    }

    public int compareTo(Distributable o) {
        return this.taskId.compareTo(((CarbonInputSplitTaskInfo)o).getTaskId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CarbonInputSplitTaskInfo)) {
            return false;
        }
        CarbonInputSplitTaskInfo that = (CarbonInputSplitTaskInfo)obj;
        return null != this.taskId ? 0 == this.taskId.compareTo(that.taskId) : null == that.taskId;
    }

    public int hashCode() {
        return null != this.taskId ? this.taskId.hashCode() : 0;
    }

    public static List<String> maxNoNodes(List<CarbonInputSplit> splitList) {
        boolean useIndex = true;
        Integer maxOccurence = 0;
        String maxNode = null;
        TreeMap<String, Integer> nodeAndOccurenceMapping = new TreeMap<String, Integer>();
        for (CarbonInputSplit carbonInputSplit : splitList) {
            try {
                for (String node : carbonInputSplit.getLocations()) {
                    Integer nodeOccurence = (Integer)nodeAndOccurenceMapping.get(node);
                    if (null == nodeOccurence) {
                        nodeAndOccurenceMapping.put(node, 1);
                        continue;
                    }
                    Integer n = nodeOccurence;
                    Integer n2 = nodeOccurence = Integer.valueOf(nodeOccurence + 1);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Fail to get location of split: " + carbonInputSplit, iOException);
            }
        }
        Integer previousValueOccurence = null;
        for (Map.Entry entry : nodeAndOccurenceMapping.entrySet()) {
            if ((Integer)entry.getValue() > maxOccurence) {
                maxOccurence = (Integer)entry.getValue();
                maxNode = (String)entry.getKey();
            }
            if (null == previousValueOccurence) {
                previousValueOccurence = (Integer)entry.getValue();
                continue;
            }
            if (Objects.equals(previousValueOccurence, entry.getValue())) continue;
            useIndex = false;
        }
        if (useIndex) {
            return new ArrayList<String>(nodeAndOccurenceMapping.keySet());
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(maxNode);
        return arrayList;
    }
}

