/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.util;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.index.IndexUtil;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.hadoop.api.CarbonFileInputFormat;
import org.apache.carbondata.hadoop.api.CarbonTableInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.log4j.Logger;

public class CarbonInputFormatUtil {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonProperties.class.getName());

    public static <V> CarbonFileInputFormat<V> createCarbonFileInputFormat(AbsoluteTableIdentifier identifier, Job job) throws IOException {
        CarbonFileInputFormat carbonInputFormat = new CarbonFileInputFormat();
        CarbonTableInputFormat.setDatabaseName(job.getConfiguration(), identifier.getCarbonTableIdentifier().getDatabaseName());
        CarbonTableInputFormat.setTableName(job.getConfiguration(), identifier.getCarbonTableIdentifier().getTableName());
        FileInputFormat.addInputPath((Job)job, (Path)new Path(identifier.getTablePath()));
        CarbonInputFormatUtil.setIndexJobIfConfigured(job.getConfiguration());
        return carbonInputFormat;
    }

    public static <V> CarbonTableInputFormat<V> createCarbonInputFormat(AbsoluteTableIdentifier identifier, Job job) throws IOException {
        CarbonTableInputFormat carbonInputFormat = new CarbonTableInputFormat();
        CarbonTableInputFormat.setDatabaseName(job.getConfiguration(), identifier.getCarbonTableIdentifier().getDatabaseName());
        CarbonTableInputFormat.setTableName(job.getConfiguration(), identifier.getCarbonTableIdentifier().getTableName());
        FileInputFormat.addInputPath((Job)job, (Path)new Path(identifier.getTablePath()));
        CarbonInputFormatUtil.setIndexJobIfConfigured(job.getConfiguration());
        return carbonInputFormat;
    }

    public static void setIndexJobIfConfigured(Configuration conf) throws IOException {
        String className = "org.apache.carbondata.indexserver.EmbeddedIndexJob";
        IndexUtil.setIndexJob((Configuration)conf, (Object)IndexUtil.createIndexJob((String)className));
    }

    public static String createJobTrackerID(Date date) {
        return new SimpleDateFormat("yyyyMMddHHmmss", Locale.US).format(date);
    }

    public static JobID getJobId(Date date, int batch) {
        String jobtrackerID = CarbonInputFormatUtil.createJobTrackerID(date);
        return new JobID(jobtrackerID, batch);
    }
}

