/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.exceptions.DeprecatedFeatureException;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.constants.CarbonLoadOptionConstants;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.metadata.datatype.StructField;
import org.apache.carbondata.core.metadata.datatype.StructType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonThreadFactory;
import org.apache.carbondata.core.util.DataLoadMetrics;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.core.util.ObjectSerializationUtil;
import org.apache.carbondata.core.util.ThreadLocalSessionInfo;
import org.apache.carbondata.hadoop.api.CarbonOutputCommitter;
import org.apache.carbondata.hadoop.internal.ObjectArrayWritable;
import org.apache.carbondata.processing.loading.ComplexDelimitersEnum;
import org.apache.carbondata.processing.loading.DataLoadExecutor;
import org.apache.carbondata.processing.loading.TableProcessingOperations;
import org.apache.carbondata.processing.loading.iterator.CarbonOutputIteratorWrapper;
import org.apache.carbondata.processing.loading.model.CarbonDataLoadSchema;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.log4j.Logger;

public class CarbonTableOutputFormat
extends FileOutputFormat<NullWritable, ObjectArrayWritable> {
    protected static final String LOAD_MODEL = "mapreduce.carbontable.load.model";
    private static final String DATABASE_NAME = "mapreduce.carbontable.databaseName";
    private static final String TABLE_NAME = "mapreduce.carbontable.tableName";
    private static final String TABLE = "mapreduce.carbontable.table";
    private static final String TABLE_PATH = "mapreduce.carbontable.tablepath";
    private static final String INPUT_SCHEMA = "mapreduce.carbontable.inputschema";
    private static final String TEMP_STORE_LOCATIONS = "mapreduce.carbontable.tempstore.locations";
    private static final String OVERWRITE_SET = "mapreduce.carbontable.set.overwrite";
    public static final String COMPLEX_DELIMITERS = "mapreduce.carbontable.complex_delimiters";
    private static final String CARBON_TRANSACTIONAL_TABLE = "mapreduce.input.carboninputformat.transactional";
    public static final String SERIALIZATION_NULL_FORMAT = "mapreduce.carbontable.serialization.null.format";
    public static final String BAD_RECORDS_LOGGER_ENABLE = "mapreduce.carbontable.bad.records.logger.enable";
    public static final String BAD_RECORDS_LOGGER_ACTION = "mapreduce.carbontable.bad.records.logger.action";
    public static final String IS_EMPTY_DATA_BAD_RECORD = "mapreduce.carbontable.empty.data.bad.record";
    public static final String SKIP_EMPTY_LINE = "mapreduce.carbontable.skip.empty.line";
    public static final String SORT_SCOPE = "mapreduce.carbontable.load.sort.scope";
    public static final String GLOBAL_SORT_PARTITIONS = "mapreduce.carbontable.global.sort.partitions";
    public static final String BAD_RECORD_PATH = "mapreduce.carbontable.bad.record.path";
    public static final String DATE_FORMAT = "mapreduce.carbontable.date.format";
    public static final String TIMESTAMP_FORMAT = "mapreduce.carbontable.timestamp.format";
    public static final String UPADTE_TIMESTAMP = "mapreduce.carbontable.update.timestamp";
    public static final String SEGMENTS_TO_BE_DELETED = "mapreduce.carbontable.segments.to.be.removed";
    public static final String OPERATION_CONTEXT = "mapreduce.carbontable.operation.context";
    private static final Logger LOG = LogServiceFactory.getLogService((String)CarbonTableOutputFormat.class.getName());
    private CarbonOutputCommitter committer;
    private static final AtomicLong DEFAULT_TASK_NO = new AtomicLong(0L);

    public static void setDatabaseName(Configuration configuration, String databaseName) {
        if (null != databaseName) {
            configuration.set(DATABASE_NAME, databaseName);
        }
    }

    public static String getDatabaseName(Configuration configuration) {
        return configuration.get(DATABASE_NAME);
    }

    public static void setTableName(Configuration configuration, String tableName) {
        if (null != tableName) {
            configuration.set(TABLE_NAME, tableName);
        }
    }

    public static String getTableName(Configuration configuration) {
        return configuration.get(TABLE_NAME);
    }

    public static void setTablePath(Configuration configuration, String tablePath) {
        if (null != tablePath) {
            configuration.set(TABLE_PATH, tablePath);
        }
    }

    public static String getTablePath(Configuration configuration) {
        return configuration.get(TABLE_PATH);
    }

    public static void setCarbonTable(Configuration configuration, CarbonTable carbonTable) throws IOException {
        if (carbonTable != null) {
            configuration.set(TABLE, ObjectSerializationUtil.convertObjectToString((Object)carbonTable.getTableInfo().serialize()));
        }
    }

    public static CarbonTable getCarbonTable(Configuration configuration) throws IOException {
        CarbonTable carbonTable = null;
        String encodedString = configuration.get(TABLE);
        if (encodedString != null) {
            byte[] bytes = (byte[])ObjectSerializationUtil.convertStringToObject((String)encodedString);
            TableInfo tableInfo = TableInfo.deserialize((byte[])bytes);
            carbonTable = CarbonTable.buildFromTableInfo((TableInfo)tableInfo);
        }
        return carbonTable;
    }

    public static void setLoadModel(Configuration configuration, CarbonLoadModel loadModel) throws IOException {
        if (loadModel != null) {
            configuration.set(LOAD_MODEL, ObjectSerializationUtil.convertObjectToString((Object)loadModel));
        }
    }

    public static void setInputSchema(Configuration configuration, StructType inputSchema) throws IOException {
        if (inputSchema == null || inputSchema.getFields().size() <= 0) {
            throw new UnsupportedOperationException("Input schema must be set");
        }
        configuration.set(INPUT_SCHEMA, ObjectSerializationUtil.convertObjectToString((Object)inputSchema));
    }

    private static StructType getInputSchema(Configuration configuration) throws IOException {
        String encodedString = configuration.get(INPUT_SCHEMA);
        if (encodedString != null) {
            return (StructType)ObjectSerializationUtil.convertStringToObject((String)encodedString);
        }
        return null;
    }

    public static boolean isOverwriteSet(Configuration configuration) {
        String overwrite = configuration.get(OVERWRITE_SET);
        if (overwrite != null) {
            return Boolean.parseBoolean(overwrite);
        }
        return false;
    }

    public static void setOverwrite(Configuration configuration, boolean overwrite) {
        configuration.set(OVERWRITE_SET, String.valueOf(overwrite));
    }

    public static void setTempStoreLocations(Configuration configuration, String[] tempLocations) throws IOException {
        if (tempLocations != null && tempLocations.length > 0) {
            configuration.set(TEMP_STORE_LOCATIONS, ObjectSerializationUtil.convertObjectToString((Object)tempLocations));
        }
    }

    private static String[] getTempStoreLocations(TaskAttemptContext taskAttemptContext) throws IOException {
        String encodedString = taskAttemptContext.getConfiguration().get(TEMP_STORE_LOCATIONS);
        if (encodedString != null) {
            return (String[])ObjectSerializationUtil.convertStringToObject((String)encodedString);
        }
        return new String[]{System.getProperty("java.io.tmpdir") + "/" + UUID.randomUUID().toString().replace("-", "") + "_" + taskAttemptContext.getTaskAttemptID().toString()};
    }

    public synchronized OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException {
        if (this.committer == null) {
            Path output = CarbonTableOutputFormat.getOutputPath((JobContext)context);
            this.committer = new CarbonOutputCommitter(output, context);
        }
        return this.committer;
    }

    public RecordWriter<NullWritable, ObjectArrayWritable> getRecordWriter(final TaskAttemptContext taskAttemptContext) throws IOException {
        int sdkWriterCores;
        final CarbonLoadModel loadModel = CarbonTableOutputFormat.getLoadModel(taskAttemptContext.getConfiguration());
        loadModel.setMetrics(new DataLoadMetrics());
        String appName = taskAttemptContext.getConfiguration().get("carbon.writtenby.app.name");
        if (null != appName) {
            CarbonProperties.getInstance().addProperty("carbon.writtenby.app.name", appName);
        }
        int itrSize = (sdkWriterCores = loadModel.getSdkWriterCores()) > 0 ? sdkWriterCores : 1;
        final CarbonOutputIteratorWrapper[] iterators = new CarbonOutputIteratorWrapper[itrSize];
        for (int i = 0; i < itrSize; ++i) {
            iterators[i] = new CarbonOutputIteratorWrapper();
        }
        if (null == loadModel.getTaskNo() || loadModel.getTaskNo().isEmpty()) {
            loadModel.setTaskNo(taskAttemptContext.getConfiguration().get("carbon.outputformat.taskno", String.valueOf(DEFAULT_TASK_NO.getAndIncrement())));
        }
        loadModel.setDataWritePath(taskAttemptContext.getConfiguration().get("carbon.outputformat.writepath"));
        final String[] tempStoreLocations = CarbonTableOutputFormat.getTempStoreLocations(taskAttemptContext);
        DataTypeUtil.clearFormatter();
        final DataLoadExecutor dataLoadExecutor = new DataLoadExecutor();
        final ExecutorService executorService = Executors.newFixedThreadPool(1, (ThreadFactory)new CarbonThreadFactory("CarbonRecordWriter:" + loadModel.getTableName(), true));
        Future<?> future = executorService.submit(new Thread(){

            @Override
            public void run() {
                ThreadLocalSessionInfo.getOrCreateCarbonSessionInfo().getNonSerializableExtraInfo().put("carbonConf", taskAttemptContext.getConfiguration());
                try {
                    dataLoadExecutor.execute(loadModel, tempStoreLocations, (CarbonIterator[])iterators);
                }
                catch (Exception e) {
                    executorService.shutdownNow();
                    for (CarbonOutputIteratorWrapper iterator : iterators) {
                        iterator.closeWriter(true);
                    }
                    try {
                        dataLoadExecutor.close();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(e);
                    }
                    throw new RuntimeException(e);
                }
                finally {
                    ThreadLocalSessionInfo.unsetAll();
                }
            }
        });
        if (sdkWriterCores > 0) {
            return new CarbonMultiRecordWriter(iterators, dataLoadExecutor, loadModel, future, executorService);
        }
        return new CarbonRecordWriter(iterators[0], dataLoadExecutor, loadModel, future, executorService);
    }

    public static CarbonLoadModel getLoadModel(Configuration conf) throws IOException {
        String columnCompressor;
        String encodedString = conf.get(LOAD_MODEL);
        if (encodedString != null) {
            CarbonLoadModel model = (CarbonLoadModel)ObjectSerializationUtil.convertStringToObject((String)encodedString);
            return model;
        }
        CarbonLoadModel model = new CarbonLoadModel();
        CarbonProperties carbonProperty = CarbonProperties.getInstance();
        model.setDatabaseName(CarbonTableOutputFormat.getDatabaseName(conf));
        model.setTableName(CarbonTableOutputFormat.getTableName(conf));
        model.setCarbonTransactionalTable(true);
        model.setMetrics(new DataLoadMetrics());
        CarbonTable carbonTable = CarbonTableOutputFormat.getCarbonTable(conf);
        if (carbonTable.getTableInfo().getFactTable().getTableProperties().containsKey("dictionary_include")) {
            DeprecatedFeatureException.globalDictNotSupported();
        }
        if (null == (columnCompressor = (String)carbonTable.getTableInfo().getFactTable().getTableProperties().get("carbon.column.compressor"))) {
            columnCompressor = CompressorFactory.getInstance().getCompressor().getName();
        }
        model.setColumnCompressor(columnCompressor);
        model.setCarbonDataLoadSchema(new CarbonDataLoadSchema(carbonTable));
        model.setTablePath(CarbonTableOutputFormat.getTablePath(conf));
        CarbonTableOutputFormat.setFileHeader(conf, model);
        model.setSerializationNullFormat(conf.get(SERIALIZATION_NULL_FORMAT, "\\N"));
        model.setBadRecordsLoggerEnable(conf.get(BAD_RECORDS_LOGGER_ENABLE, carbonProperty.getProperty("carbon.options.bad.records.logger.enable", CarbonLoadOptionConstants.CARBON_OPTIONS_BAD_RECORDS_LOGGER_ENABLE_DEFAULT)));
        model.setBadRecordsAction(conf.get(BAD_RECORDS_LOGGER_ACTION, carbonProperty.getProperty("carbon.bad.records.action", "FAIL")));
        model.setIsEmptyDataBadRecord(conf.get(IS_EMPTY_DATA_BAD_RECORD, carbonProperty.getProperty("carbon.options.is.empty.data.bad.record", "false")));
        model.setSkipEmptyLine(conf.get(SKIP_EMPTY_LINE, carbonProperty.getProperty("carbon.options.is.empty.data.bad.record")));
        String complexDelim = conf.get(COMPLEX_DELIMITERS);
        if (null == complexDelim) {
            complexDelim = ComplexDelimitersEnum.COMPLEX_DELIMITERS_LEVEL_1.value() + "," + ComplexDelimitersEnum.COMPLEX_DELIMITERS_LEVEL_2.value() + "," + ComplexDelimitersEnum.COMPLEX_DELIMITERS_LEVEL_3.value();
        }
        String[] split = complexDelim.split(",");
        model.setComplexDelimiter(split[0]);
        if (split.length > 2) {
            model.setComplexDelimiter(split[1]);
            model.setComplexDelimiter(split[2]);
        } else if (split.length > 1) {
            model.setComplexDelimiter(split[1]);
        }
        model.setDateFormat(conf.get(DATE_FORMAT, carbonProperty.getProperty("carbon.options.date.format", "")));
        model.setTimestampFormat(conf.get(TIMESTAMP_FORMAT, carbonProperty.getProperty("carbon.options.timestamp.format", "")));
        model.setGlobalSortPartitions(conf.get(GLOBAL_SORT_PARTITIONS, carbonProperty.getProperty("carbon.options.global.sort.partitions", null)));
        String badRecordsPath = conf.get(BAD_RECORD_PATH);
        if (StringUtils.isEmpty((CharSequence)badRecordsPath) && StringUtils.isEmpty((CharSequence)(badRecordsPath = (String)carbonTable.getTableInfo().getFactTable().getTableProperties().get("bad_record_path")))) {
            badRecordsPath = carbonProperty.getProperty("carbon.options.bad.record.path", carbonProperty.getProperty("carbon.badRecords.location", ""));
        }
        model.setBadRecordsLocation(badRecordsPath);
        return model;
    }

    private static void setFileHeader(Configuration configuration, CarbonLoadModel model) throws IOException {
        StructType inputSchema = CarbonTableOutputFormat.getInputSchema(configuration);
        if (inputSchema == null || inputSchema.getFields().size() == 0) {
            throw new UnsupportedOperationException("Input schema must be set");
        }
        List fields = inputSchema.getFields();
        StringBuilder builder = new StringBuilder();
        String[] columns = new String[fields.size()];
        int i = 0;
        for (StructField field : fields) {
            builder.append(field.getFieldName());
            builder.append(",");
            columns[i++] = field.getFieldName();
        }
        String header = builder.toString();
        model.setCsvHeader(header.substring(0, header.length() - 1));
        model.setCsvHeaderColumns(columns);
    }

    public static class CarbonMultiRecordWriter
    extends CarbonRecordWriter {
        private CarbonOutputIteratorWrapper[] iterators;
        private AtomicLong counter;

        CarbonMultiRecordWriter(CarbonOutputIteratorWrapper[] iterators, DataLoadExecutor dataLoadExecutor, CarbonLoadModel loadModel, Future future, ExecutorService executorService) {
            super(null, dataLoadExecutor, loadModel, future, executorService);
            this.iterators = iterators;
            this.counter = new AtomicLong(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(NullWritable aVoid, ObjectArrayWritable objects) throws InterruptedException {
            int iteratorNum = (int)(this.counter.incrementAndGet() % (long)this.iterators.length);
            CarbonOutputIteratorWrapper carbonOutputIteratorWrapper = this.iterators[iteratorNum];
            synchronized (carbonOutputIteratorWrapper) {
                this.iterators[iteratorNum].write(objects.get());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close(TaskAttemptContext taskAttemptContext) throws InterruptedException {
            for (int i = 0; i < this.iterators.length; ++i) {
                CarbonOutputIteratorWrapper carbonOutputIteratorWrapper = this.iterators[i];
                synchronized (carbonOutputIteratorWrapper) {
                    this.iterators[i].closeWriter(false);
                    continue;
                }
            }
            super.close(taskAttemptContext);
        }
    }

    public static class CarbonRecordWriter
    extends RecordWriter<NullWritable, ObjectArrayWritable> {
        private CarbonOutputIteratorWrapper iteratorWrapper;
        private DataLoadExecutor dataLoadExecutor;
        private CarbonLoadModel loadModel;
        private ExecutorService executorService;
        private Future future;
        private boolean isClosed;

        public CarbonRecordWriter(CarbonOutputIteratorWrapper iteratorWrapper, DataLoadExecutor dataLoadExecutor, CarbonLoadModel loadModel, Future future, ExecutorService executorService) {
            this.iteratorWrapper = iteratorWrapper;
            this.dataLoadExecutor = dataLoadExecutor;
            this.loadModel = loadModel;
            this.executorService = executorService;
            this.future = future;
        }

        public void write(NullWritable aVoid, ObjectArrayWritable objects) throws InterruptedException {
            if (this.iteratorWrapper != null) {
                this.iteratorWrapper.write(objects.get());
            }
        }

        public void close(TaskAttemptContext taskAttemptContext) throws InterruptedException {
            if (!this.isClosed) {
                this.isClosed = true;
                if (this.iteratorWrapper != null) {
                    this.iteratorWrapper.closeWriter(false);
                }
                try {
                    this.future.get();
                }
                catch (ExecutionException e) {
                    LOG.error((Object)"Error while loading data", (Throwable)e);
                    throw new RuntimeException(e);
                }
                finally {
                    this.executorService.shutdownNow();
                    this.dataLoadExecutor.close();
                    ThreadLocalSessionInfo.unsetAll();
                    TableProcessingOperations.deleteLocalDataLoadFolderLocation((CarbonLoadModel)this.loadModel, (boolean)false, (boolean)false);
                }
                DataLoadMetrics metrics = this.loadModel.getMetrics();
                if (null != metrics) {
                    taskAttemptContext.getConfiguration().set("carbon.number.of.output.files", metrics.getFileCount() + "");
                    if (metrics.getOutputFiles() != null) {
                        this.appendConfiguration(taskAttemptContext.getConfiguration(), "carbon.output.files.name", metrics.getOutputFiles());
                    }
                    if (metrics.getPartitionPath() != null) {
                        this.appendConfiguration(taskAttemptContext.getConfiguration(), "carbon.output.partitions.name", metrics.getPartitionPath());
                    }
                }
                LOG.info((Object)("Closed writer task " + taskAttemptContext.getTaskAttemptID()));
            }
        }

        private void appendConfiguration(Configuration conf, String key, List<String> value) throws InterruptedException {
            String currentValue = conf.get(key);
            try {
                if (StringUtils.isEmpty((CharSequence)currentValue)) {
                    conf.set(key, ObjectSerializationUtil.convertObjectToString(value), "");
                } else {
                    ArrayList currentValueList = (ArrayList)ObjectSerializationUtil.convertStringToObject((String)currentValue);
                    currentValueList.addAll(value);
                    conf.set(key, ObjectSerializationUtil.convertObjectToString((Object)currentValueList), "");
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
                throw new InterruptedException(e.getMessage());
            }
        }

        public CarbonLoadModel getLoadModel() {
            return this.loadModel;
        }
    }
}

