/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.carbondata.common.exceptions.DeprecatedFeatureException;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.index.IndexChooser;
import org.apache.carbondata.core.index.IndexFilter;
import org.apache.carbondata.core.index.IndexStoreManager;
import org.apache.carbondata.core.index.IndexUtil;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.index.TableIndex;
import org.apache.carbondata.core.index.dev.expr.IndexExprWrapper;
import org.apache.carbondata.core.indexstore.ExtendedBlocklet;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.mutate.CarbonUpdateUtil;
import org.apache.carbondata.core.mutate.SegmentUpdateDetails;
import org.apache.carbondata.core.mutate.UpdateVO;
import org.apache.carbondata.core.mutate.data.BlockMappingVO;
import org.apache.carbondata.core.profiler.ExplainCollector;
import org.apache.carbondata.core.readcommitter.LatestFilesReadCommittedScope;
import org.apache.carbondata.core.readcommitter.ReadCommittedScope;
import org.apache.carbondata.core.readcommitter.TableStatusReadCommittedScope;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.statusmanager.FileFormat;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.statusmanager.SegmentUpdateStatusManager;
import org.apache.carbondata.core.statusmanager.StageInputCollector;
import org.apache.carbondata.core.stream.StreamFile;
import org.apache.carbondata.core.stream.StreamPruner;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.api.CarbonInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.log4j.Logger;

public class CarbonTableInputFormat<T>
extends CarbonInputFormat<T> {
    public static final String INPUT_SEGMENT_NUMBERS = "mapreduce.input.carboninputformat.segmentnumbers";
    public static final String INPUT_FILES = "mapreduce.input.carboninputformat.files";
    private static final Logger LOG = LogServiceFactory.getLogService((String)CarbonTableInputFormat.class.getName());
    protected static final String CARBON_TRANSACTIONAL_TABLE = "mapreduce.input.carboninputformat.transactional";
    public static final String DATABASE_NAME = "mapreduce.input.carboninputformat.databaseName";
    public static final String TABLE_NAME = "mapreduce.input.carboninputformat.tableName";
    public static final String UPDATE_DELTA_VERSION = "updateDeltaVersion";
    private CarbonTable carbonTable;
    private ReadCommittedScope readCommittedScope;

    @Override
    public List<InputSplit> getSplits(JobContext job) throws IOException {
        IndexFilter indexFilter;
        this.carbonTable = this.getOrCreateCarbonTable(job.getConfiguration());
        if (null == this.carbonTable) {
            throw new IOException("Missing/Corrupt schema file for table.");
        }
        if (this.carbonTable.getTableInfo().getFactTable().getTableProperties().containsKey("dictionary_include")) {
            DeprecatedFeatureException.globalDictNotSupported();
        }
        LinkedList<InputSplit> splits = new LinkedList<InputSplit>();
        if (CarbonProperties.isQueryStageInputEnabled()) {
            try {
                List stageInputSplits = StageInputCollector.createInputSplits((CarbonTable)this.carbonTable, (Configuration)job.getConfiguration());
                splits.addAll(stageInputSplits);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error((Object)"Failed to create input splits from stage files", (Throwable)e);
                throw new IOException(e);
            }
        }
        this.readCommittedScope = this.getReadCommitted(job, this.carbonTable.getAbsoluteTableIdentifier());
        LoadMetadataDetails[] loadMetadataDetails = this.readCommittedScope.getSegmentList();
        String updateDeltaVersion = job.getConfiguration().get(UPDATE_DELTA_VERSION);
        SegmentUpdateStatusManager updateStatusManager = updateDeltaVersion != null ? new SegmentUpdateStatusManager(this.carbonTable, loadMetadataDetails, updateDeltaVersion) : new SegmentUpdateStatusManager(this.carbonTable, loadMetadataDetails);
        ArrayList<String> invalidSegmentIds = new ArrayList<String>();
        List<Segment> streamSegments = null;
        SegmentStatusManager segmentStatusManager = new SegmentStatusManager(this.carbonTable.getAbsoluteTableIdentifier(), this.readCommittedScope.getConfiguration());
        SegmentStatusManager.ValidAndInvalidSegmentsInfo segments = segmentStatusManager.getValidAndInvalidSegments(Boolean.valueOf(this.carbonTable.isMV()), loadMetadataDetails, this.readCommittedScope);
        if (CarbonTableInputFormat.getValidateSegmentsToAccess(job.getConfiguration())) {
            List validSegments = segments.getValidSegments();
            streamSegments = segments.getStreamSegments();
            streamSegments = this.getFilteredSegment(job, streamSegments, true, this.readCommittedScope);
            if (validSegments.size() == 0) {
                splits.addAll(this.getSplitsOfStreaming(job, streamSegments, this.carbonTable));
                return splits;
            }
            List<Segment> filteredSegmentToAccess = this.getFilteredSegment(job, segments.getValidSegments(), true, this.readCommittedScope);
            if (filteredSegmentToAccess.size() == 0) {
                splits.addAll(this.getSplitsOfStreaming(job, streamSegments, this.carbonTable));
                return splits;
            }
            CarbonTableInputFormat.setSegmentsToAccess(job.getConfiguration(), filteredSegmentToAccess);
            for (Segment segment : segments.getInvalidSegments()) {
                invalidSegmentIds.add(segment.getSegmentNo());
            }
            if (invalidSegmentIds.size() > 0) {
                IndexStoreManager.getInstance().clearInvalidSegments(this.getOrCreateCarbonTable(job.getConfiguration()), invalidSegmentIds);
            }
        }
        ArrayList<Segment> validAndInProgressSegments = new ArrayList<Segment>(segments.getValidSegments());
        validAndInProgressSegments.addAll(segments.getListOfInProgressSegments());
        List<Segment> segmentToAccess = this.getFilteredSegment(job, validAndInProgressSegments, false, this.readCommittedScope);
        String segmentFileName = job.getConfiguration().get("current.segmentfile");
        if (segmentFileName != null) {
            segmentToAccess.get(0).setSegmentFileName(segmentFileName + ".segment");
        }
        if ((indexFilter = this.getFilterPredicates(job.getConfiguration())) != null) {
            indexFilter.resolve(false);
        }
        List<InputSplit> batchSplits = this.getSplits(job, indexFilter, segmentToAccess, updateStatusManager, segments.getInvalidSegments());
        splits.addAll(batchSplits);
        List<InputSplit> splitsOfStreaming = this.getSplitsOfStreaming(job, streamSegments, this.carbonTable);
        if (!splitsOfStreaming.isEmpty()) {
            splits.addAll(splitsOfStreaming);
        }
        return splits;
    }

    private List<Segment> getFilteredSegment(JobContext job, List<Segment> validSegments, boolean validationRequired, ReadCommittedScope readCommittedScope) {
        Segment[] segmentsToAccess = this.getSegmentsToAccess(job, readCommittedScope);
        ArrayList<Segment> segmentToAccessSet = new ArrayList<Segment>(new HashSet<Segment>(Arrays.asList(segmentsToAccess)));
        ArrayList<Segment> filteredSegmentToAccess = new ArrayList<Segment>();
        if (segmentsToAccess.length == 0 || segmentsToAccess[0].getSegmentNo().equalsIgnoreCase("*")) {
            filteredSegmentToAccess.addAll(validSegments);
        } else {
            for (Segment validSegment : validSegments) {
                int index = segmentToAccessSet.indexOf(validSegment);
                if (index <= -1) continue;
                if (((Segment)segmentToAccessSet.get(index)).getSegmentFileName() != null && validSegment.getSegmentFileName() == null) {
                    filteredSegmentToAccess.add((Segment)segmentToAccessSet.get(index));
                    continue;
                }
                filteredSegmentToAccess.add(validSegment);
            }
            if (filteredSegmentToAccess.size() != segmentToAccessSet.size() && !validationRequired) {
                for (Segment segment : segmentToAccessSet) {
                    if (filteredSegmentToAccess.contains(segment)) continue;
                    filteredSegmentToAccess.add(segment);
                }
            }
            if (filteredSegmentToAccess.size() != segmentToAccessSet.size() && !validationRequired) {
                for (Segment segment : segmentToAccessSet) {
                    if (filteredSegmentToAccess.contains(segment)) continue;
                    filteredSegmentToAccess.add(segment);
                }
            }
            if (!filteredSegmentToAccess.containsAll(segmentToAccessSet)) {
                ArrayList<Segment> filteredSegmentToAccessTemp = new ArrayList<Segment>(filteredSegmentToAccess);
                filteredSegmentToAccessTemp.removeAll(segmentToAccessSet);
                LOG.info((Object)("Segments ignored are : " + Arrays.toString(filteredSegmentToAccessTemp.toArray())));
            }
        }
        return filteredSegmentToAccess;
    }

    public List<InputSplit> getSplitsOfStreaming(JobContext job, List<Segment> streamSegments, CarbonTable carbonTable) throws IOException {
        return this.getSplitsOfStreaming(job, streamSegments, carbonTable, null);
    }

    public List<InputSplit> getSplitsOfStreaming(JobContext job, List<Segment> streamSegments, CarbonTable carbonTable, FilterResolverIntf filterResolverIntf) throws IOException {
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        if (streamSegments != null && !streamSegments.isEmpty()) {
            IndexFilter filter;
            this.numStreamSegments = streamSegments.size();
            long minSize = Math.max(this.getFormatMinSplitSize(), CarbonTableInputFormat.getMinSplitSize((JobContext)job));
            long maxSize = CarbonTableInputFormat.getMaxSplitSize((JobContext)job);
            if (filterResolverIntf == null && carbonTable != null && (filter = this.getFilterPredicates(job.getConfiguration())) != null) {
                filter.processFilterExpression();
                filterResolverIntf = filter.getResolver();
            }
            StreamPruner streamPruner = new StreamPruner(carbonTable);
            streamPruner.init(filterResolverIntf);
            List streamFiles = streamPruner.prune(streamSegments);
            this.hitedStreamFiles = streamFiles.size();
            this.numStreamFiles = streamPruner.getTotalFileNums();
            for (StreamFile streamFile : streamFiles) {
                int blkIndex;
                Path path = new Path(streamFile.getFilePath());
                long length = streamFile.getFileSize();
                if (length == 0L) continue;
                FileSystem fs = FileFactory.getFileSystem((Path)path);
                FileStatus file = fs.getFileStatus(path);
                BlockLocation[] blkLocations = fs.getFileBlockLocations(path, 0L, length);
                long blockSize = file.getBlockSize();
                long splitSize = this.computeSplitSize(blockSize, minSize, maxSize);
                long bytesRemaining = length;
                while ((double)bytesRemaining / (double)splitSize > 1.1) {
                    blkIndex = this.getBlockIndex(blkLocations, length - bytesRemaining);
                    splits.add((InputSplit)this.makeSplit(streamFile.getSegmentNo(), streamFile.getFilePath(), length - bytesRemaining, splitSize, blkLocations[blkIndex].getHosts(), blkLocations[blkIndex].getCachedHosts(), FileFormat.ROW_V1));
                    bytesRemaining -= splitSize;
                }
                if (bytesRemaining == 0L) continue;
                blkIndex = this.getBlockIndex(blkLocations, length - bytesRemaining);
                splits.add((InputSplit)this.makeSplit(streamFile.getSegmentNo(), streamFile.getFilePath(), length - bytesRemaining, bytesRemaining, blkLocations[blkIndex].getHosts(), blkLocations[blkIndex].getCachedHosts(), FileFormat.ROW_V1));
            }
        }
        return splits;
    }

    protected FileSplit makeSplit(String segmentId, String filePath, long start, long length, String[] hosts, String[] inMemoryHosts, FileFormat fileFormat) {
        return new CarbonInputSplit(segmentId, filePath, start, length, hosts, inMemoryHosts, fileFormat);
    }

    private List<InputSplit> getSplits(JobContext job, IndexFilter expression, List<Segment> validSegments, SegmentUpdateStatusManager updateStatusManager, List<Segment> invalidSegments) throws IOException {
        ArrayList<String> segmentsToBeRefreshed = new ArrayList();
        if (!CarbonProperties.getInstance().isDistributedPruningEnabled(this.carbonTable.getDatabaseName(), this.carbonTable.getTableName())) {
            IndexStoreManager.getInstance().refreshSegmentCacheIfRequired(this.carbonTable, updateStatusManager, validSegments);
        } else {
            segmentsToBeRefreshed = IndexStoreManager.getInstance().getSegmentsToBeRefreshed(this.carbonTable, validSegments);
        }
        this.numSegments = validSegments.size();
        LinkedList<InputSplit> result = new LinkedList<InputSplit>();
        UpdateVO invalidBlockVOForSegmentId = null;
        boolean isIUDTable = updateStatusManager.getUpdateStatusDetails().length != 0;
        List<CarbonInputSplit> dataBlocksOfSegment = this.getDataBlocksOfSegment(job, this.carbonTable, expression, validSegments, invalidSegments, segmentsToBeRefreshed);
        this.numBlocks = dataBlocksOfSegment.size();
        for (CarbonInputSplit inputSplit : dataBlocksOfSegment) {
            if (isIUDTable) {
                invalidBlockVOForSegmentId = SegmentUpdateStatusManager.getInvalidTimestampRange((LoadMetadataDetails)inputSplit.getSegment().getLoadMetadataDetails());
            }
            String[] deleteDeltaFilePath = null;
            if (isIUDTable) {
                if (CarbonUtil.isInvalidTableBlock((String)inputSplit.getSegmentId(), (String)inputSplit.getFilePath(), (UpdateVO)invalidBlockVOForSegmentId, (SegmentUpdateStatusManager)updateStatusManager)) continue;
                try {
                    deleteDeltaFilePath = updateStatusManager.getDeleteDeltaFilePath(inputSplit.getPath().toString(), inputSplit.getSegmentId());
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            inputSplit.setDeleteDeltaFiles(deleteDeltaFilePath);
            result.add((InputSplit)inputSplit);
        }
        return result;
    }

    public Segment[] getSegmentsToAccess(JobContext job, ReadCommittedScope readCommittedScope) {
        String segmentString = job.getConfiguration().get(INPUT_SEGMENT_NUMBERS, "");
        if (segmentString.trim().isEmpty()) {
            return new Segment[0];
        }
        List segments = Segment.toSegmentList((String[])segmentString.split(","), (ReadCommittedScope)readCommittedScope);
        return segments.toArray(new Segment[segments.size()]);
    }

    public BlockMappingVO getBlockRowCount(Job job, CarbonTable table, List<PartitionSpec> partitions, boolean isUpdateFlow) throws IOException {
        ExplainCollector.remove();
        AbsoluteTableIdentifier identifier = table.getAbsoluteTableIdentifier();
        ReadCommittedScope readCommittedScope = this.getReadCommitted((JobContext)job, identifier);
        LoadMetadataDetails[] loadMetadataDetails = readCommittedScope.getSegmentList();
        SegmentUpdateStatusManager updateStatusManager = new SegmentUpdateStatusManager(table, loadMetadataDetails);
        SegmentStatusManager.ValidAndInvalidSegmentsInfo allSegments = new SegmentStatusManager(identifier, readCommittedScope.getConfiguration()).getValidAndInvalidSegments(Boolean.valueOf(table.isMV()), loadMetadataDetails, readCommittedScope);
        HashMap<String, Long> blockRowCountMapping = new HashMap<String, Long>();
        HashMap<String, Long> segmentAndBlockCountMapping = new HashMap<String, Long>();
        HashMap<String, String> blockToSegmentMapping = new HashMap<String, String>();
        List<Segment> filteredSegment = this.getFilteredSegment((JobContext)job, allSegments.getValidSegments(), false, readCommittedScope);
        boolean isIUDTable = updateStatusManager.getUpdateStatusDetails().length != 0;
        ArrayList<String> toBeCleanedSegments = new ArrayList<String>();
        for (Segment segment : filteredSegment) {
            boolean refreshNeeded = IndexStoreManager.getInstance().getTableSegmentRefresher(this.getOrCreateCarbonTable(job.getConfiguration())).isRefreshNeeded(segment, SegmentUpdateStatusManager.getInvalidTimestampRange((LoadMetadataDetails)segment.getLoadMetadataDetails()));
            if (!refreshNeeded) continue;
            toBeCleanedSegments.add(segment.getSegmentNo());
        }
        for (Segment segment : allSegments.getInvalidSegments()) {
            toBeCleanedSegments.add(segment.getSegmentNo());
        }
        if (toBeCleanedSegments.size() > 0) {
            IndexStoreManager.getInstance().clearInvalidSegments(this.getOrCreateCarbonTable(job.getConfiguration()), toBeCleanedSegments);
        }
        IndexExprWrapper indexExprWrapper = IndexChooser.getDefaultIndex((CarbonTable)this.getOrCreateCarbonTable(job.getConfiguration()), null);
        IndexUtil.loadIndexes((CarbonTable)table, (IndexExprWrapper)indexExprWrapper, filteredSegment);
        if (isIUDTable || isUpdateFlow) {
            String blockName;
            HashMap<String, Long> blockletToRowCountMap = new HashMap<String, Long>();
            if (CarbonProperties.getInstance().isDistributedPruningEnabled(table.getDatabaseName(), table.getTableName())) {
                try {
                    List<ExtendedBlocklet> extendedBlocklets = this.getDistributedBlockRowCount(table, partitions, filteredSegment, allSegments.getInvalidSegments(), toBeCleanedSegments);
                    for (ExtendedBlocklet blocklet : extendedBlocklets) {
                        String filePath = blocklet.getFilePath().replace("\\", "/");
                        blockName = filePath.substring(filePath.lastIndexOf("/") + 1);
                        blockletToRowCountMap.put(blocklet.getSegmentId() + "," + blockName, blocklet.getRowCount());
                    }
                }
                catch (Exception e) {
                    if (CarbonProperties.getInstance().isFallBackDisabled()) {
                        throw e;
                    }
                    TableIndex defaultIndex = IndexStoreManager.getInstance().getDefaultIndex(table);
                    blockletToRowCountMap.putAll(defaultIndex.getBlockRowCount(filteredSegment, partitions, defaultIndex));
                }
            } else {
                TableIndex defaultIndex = IndexStoreManager.getInstance().getDefaultIndex(table);
                blockletToRowCountMap.putAll(defaultIndex.getBlockRowCount(filteredSegment, partitions, defaultIndex));
            }
            for (Map.Entry eachBlocklet : blockletToRowCountMap.entrySet()) {
                String[] segmentIdAndPath = ((String)eachBlocklet.getKey()).split(",", 2);
                String segmentId = segmentIdAndPath[0];
                blockName = segmentIdAndPath[1];
                long rowCount = (Long)eachBlocklet.getValue();
                String key = CarbonUpdateUtil.getSegmentBlockNameKey((String)segmentId, (String)blockName, (boolean)table.isHivePartitionTable());
                SegmentUpdateDetails details = updateStatusManager.getDetailsForABlock(key);
                if (null != details && CarbonUpdateUtil.isBlockInvalid((SegmentStatus)details.getSegmentStatus())) continue;
                Long blockCount = (Long)blockRowCountMapping.get(key);
                if (blockCount == null) {
                    blockCount = 0L;
                    Long count = (Long)segmentAndBlockCountMapping.get(segmentId);
                    if (count == null) {
                        count = 0L;
                    }
                    segmentAndBlockCountMapping.put(segmentId, count + 1L);
                }
                blockToSegmentMapping.put(key, segmentId);
                blockCount = blockCount + rowCount;
                blockRowCountMapping.put(key, blockCount);
            }
        } else {
            long totalRowCount;
            if (CarbonProperties.getInstance().isDistributedPruningEnabled(table.getDatabaseName(), table.getTableName())) {
                totalRowCount = this.getDistributedCount(table, partitions, filteredSegment);
            } else {
                TableIndex defaultIndex = IndexStoreManager.getInstance().getDefaultIndex(table);
                totalRowCount = defaultIndex.getRowCount(filteredSegment, partitions, defaultIndex);
            }
            blockRowCountMapping.put("rowCount", totalRowCount);
        }
        BlockMappingVO blockMappingVO = new BlockMappingVO(blockRowCountMapping, segmentAndBlockCountMapping);
        blockMappingVO.setBlockToSegmentMapping(blockToSegmentMapping);
        return blockMappingVO;
    }

    public ReadCommittedScope getReadCommitted(JobContext job, AbsoluteTableIdentifier identifier) throws IOException {
        if (this.readCommittedScope == null) {
            ReadCommittedScope readCommittedScope;
            if (job.getConfiguration().getBoolean(CARBON_TRANSACTIONAL_TABLE, true)) {
                readCommittedScope = new TableStatusReadCommittedScope(identifier, job.getConfiguration());
            } else {
                readCommittedScope = CarbonTableInputFormat.getReadCommittedScope(job.getConfiguration());
                if (readCommittedScope == null) {
                    readCommittedScope = new LatestFilesReadCommittedScope(identifier.getTablePath(), job.getConfiguration());
                }
            }
            this.readCommittedScope = readCommittedScope;
        }
        return this.readCommittedScope;
    }

    public void setReadCommittedScope(ReadCommittedScope readCommittedScope) {
        this.readCommittedScope = readCommittedScope;
    }
}

