/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.api;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.index.IndexFilter;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.indexstore.BlockletDetailInfo;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.core.metadata.schema.SchemaReader;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.readcommitter.LatestFilesReadCommittedScope;
import org.apache.carbondata.core.readcommitter.ReadCommittedScope;
import org.apache.carbondata.core.statusmanager.FileFormat;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.api.CarbonInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;

@InterfaceAudience.User
@InterfaceStability.Evolving
public class CarbonFileInputFormat<T>
extends CarbonInputFormat<T>
implements Serializable {
    private CarbonTable carbonTable;

    @Override
    public CarbonTable getOrCreateCarbonTable(Configuration configuration) throws IOException {
        if (this.carbonTable == null) {
            CarbonTable localCarbonTable;
            TableInfo tableInfo = CarbonFileInputFormat.getTableInfo(configuration);
            if (tableInfo != null) {
                localCarbonTable = CarbonTable.buildFromTableInfo((TableInfo)tableInfo);
            } else {
                String schemaPath = CarbonTablePath.getSchemaFilePath((String)this.getAbsoluteTableIdentifier(configuration).getTablePath());
                if (!FileFactory.isFileExist((String)schemaPath)) {
                    TableInfo tableInfoInfer = SchemaReader.inferSchema((AbsoluteTableIdentifier)this.getAbsoluteTableIdentifier(configuration), (boolean)true);
                    localCarbonTable = CarbonTable.buildFromTableInfo((TableInfo)tableInfoInfer);
                } else {
                    localCarbonTable = SchemaReader.readCarbonTableFromStore((AbsoluteTableIdentifier)this.getAbsoluteTableIdentifier(configuration));
                }
            }
            this.carbonTable = localCarbonTable;
            return localCarbonTable;
        }
        CarbonTable carbonTableTemp = this.carbonTable;
        return carbonTableTemp;
    }

    @Override
    public List<InputSplit> getSplits(JobContext job) throws IOException {
        Segment seg;
        CarbonTable carbonTable = this.getOrCreateCarbonTable(job.getConfiguration());
        if (null == carbonTable) {
            throw new IOException("Missing/Corrupt schema file for table.");
        }
        AbsoluteTableIdentifier identifier = carbonTable.getAbsoluteTableIdentifier();
        ReadCommittedScope readCommittedScope = null;
        if (carbonTable.isTransactionalTable()) {
            readCommittedScope = new LatestFilesReadCommittedScope(identifier.getTablePath() + "/Fact/Part0/Segment_null/", job.getConfiguration());
        } else {
            readCommittedScope = CarbonFileInputFormat.getReadCommittedScope(job.getConfiguration());
            if (readCommittedScope == null) {
                readCommittedScope = new LatestFilesReadCommittedScope(identifier.getTablePath(), job.getConfiguration());
            } else {
                readCommittedScope.setConfiguration(job.getConfiguration());
            }
        }
        IndexFilter filter = this.getFilterPredicates(job.getConfiguration());
        ArrayList<Segment> externalTableSegments = new ArrayList<Segment>();
        if (carbonTable.isTransactionalTable()) {
            seg = new Segment("null", null, readCommittedScope);
            externalTableSegments.add(seg);
        } else {
            LoadMetadataDetails[] loadMetadataDetails;
            block0: for (LoadMetadataDetails load : loadMetadataDetails = readCommittedScope.getSegmentList()) {
                seg = new Segment(load.getLoadName(), null, readCommittedScope);
                if (this.fileLists != null) {
                    for (int i = 0; i < this.fileLists.size(); ++i) {
                        String timestamp = CarbonTablePath.DataFileUtil.getTimeStampFromFileName((String)this.fileLists.get(i).toString());
                        if (!timestamp.equals(seg.getSegmentNo())) continue;
                        externalTableSegments.add(seg);
                        continue block0;
                    }
                    continue;
                }
                externalTableSegments.add(seg);
            }
        }
        ArrayList<InputSplit> splits = new ArrayList();
        boolean useBlockIndex = job.getConfiguration().getBoolean("filter_blocks", true);
        if (filter != null) {
            filter.resolve(false);
        }
        if (useBlockIndex) {
            splits = this.getSplits(job, filter, externalTableSegments);
        } else {
            List<CarbonFile> carbonFiles = null;
            carbonFiles = null != this.fileLists ? this.getAllCarbonDataFiles(this.fileLists) : this.getAllCarbonDataFiles(carbonTable.getTablePath());
            for (CarbonFile carbonFile : carbonFiles) {
                CarbonInputSplit split = new CarbonInputSplit("null", carbonFile.getAbsolutePath(), 0L, carbonFile.getLength(), carbonFile.getLocations(), FileFormat.COLUMNAR_V3);
                split.setVersion(ColumnarFormatVersion.V3);
                BlockletDetailInfo info = new BlockletDetailInfo();
                split.setDetailInfo(info);
                info.setBlockSize(carbonFile.getLength());
                info.setVersionNumber(split.getVersion().number());
                info.setUseMinMaxForPruning(false);
                splits.add((InputSplit)split);
            }
            Collections.sort(splits, new Comparator<InputSplit>(){

                @Override
                public int compare(InputSplit o1, InputSplit o2) {
                    return ((CarbonInputSplit)o1).getFilePath().compareTo(((CarbonInputSplit)o2).getFilePath());
                }
            });
        }
        this.setAllColumnProjectionIfNotConfigured(job, carbonTable);
        return splits;
    }

    public void setAllColumnProjectionIfNotConfigured(JobContext job, CarbonTable carbonTable) {
        if (CarbonFileInputFormat.getColumnProjection(job.getConfiguration()) == null) {
            String[] projectionColumns = this.projectAllColumns(carbonTable);
            CarbonFileInputFormat.setColumnProjection(job.getConfiguration(), projectionColumns);
        }
    }

    private List<CarbonFile> getAllCarbonDataFiles(String tablePath) {
        List carbonFiles;
        try {
            carbonFiles = FileFactory.getCarbonFile((String)tablePath).listFiles(true, new CarbonFileFilter(){

                public boolean accept(CarbonFile file) {
                    return file.getName().endsWith(".carbondata");
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return carbonFiles;
    }

    private List<CarbonFile> getAllCarbonDataFiles(List fileLists) {
        LinkedList<CarbonFile> carbonFiles = new LinkedList<CarbonFile>();
        try {
            for (int i = 0; i < fileLists.size(); ++i) {
                carbonFiles.add(FileFactory.getCarbonFile((String)fileLists.get(i).toString()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return carbonFiles;
    }

    private List<InputSplit> getSplits(JobContext job, IndexFilter indexFilter, List<Segment> validSegments) throws IOException {
        this.numSegments = validSegments.size();
        LinkedList<InputSplit> result = new LinkedList<InputSplit>();
        List<CarbonInputSplit> dataBlocksOfSegment = this.getDataBlocksOfSegment(job, this.carbonTable, indexFilter, validSegments, new ArrayList<Segment>(), new ArrayList<String>());
        this.numBlocks = dataBlocksOfSegment.size();
        result.addAll(dataBlocksOfSegment);
        return result;
    }
}

