/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.geo.scan.expression;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.ExpressionResult;
import org.apache.carbondata.core.scan.expression.UnknownExpression;
import org.apache.carbondata.core.scan.expression.conditional.ConditionalExpression;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.scan.filter.intf.RowIntf;
import org.apache.carbondata.core.util.CustomIndex;

@InterfaceAudience.Internal
public class PolygonExpression
extends UnknownExpression
implements ConditionalExpression {
    private String polygon;
    private CustomIndex<List<Long[]>> instance;
    private List<Long[]> ranges = new ArrayList<Long[]>();
    private ColumnExpression column;
    private ExpressionResult trueExpRes;
    private ExpressionResult falseExpRes;

    public PolygonExpression(String polygon, String columnName, CustomIndex indexInstance) {
        this.polygon = polygon;
        this.instance = indexInstance;
        this.column = new ColumnExpression(columnName, DataTypes.LONG);
        this.trueExpRes = new ExpressionResult(DataTypes.BOOLEAN, (Object)true);
        this.falseExpRes = new ExpressionResult(DataTypes.BOOLEAN, (Object)false);
    }

    private void validate(List<Long[]> ranges) {
        for (Long[] range : ranges) {
            if (range.length == 2) continue;
            throw new RuntimeException("Query processor must return list of ranges with each range containing minimum and maximum values");
        }
    }

    private void processExpression() {
        try {
            this.ranges = (List)this.instance.query(this.polygon);
            this.validate(this.ranges);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean rangeBinarySearch(List<Long[]> ranges, long searchForNumber) {
        int low = 0;
        int high = ranges.size() - 1;
        while (low <= high) {
            int mid = low + (high - low) / 2;
            Long[] range = ranges.get(mid);
            if (searchForNumber >= range[0]) {
                if (searchForNumber <= range[1]) {
                    return true;
                }
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return false;
    }

    public ExpressionResult evaluate(RowIntf value) {
        if (this.rangeBinarySearch(this.ranges, (Long)value.getVal(0))) {
            return this.trueExpRes;
        }
        return this.falseExpRes;
    }

    public ExpressionType getFilterExpressionType() {
        return ExpressionType.UNKNOWN;
    }

    public List<Expression> getChildren() {
        if (this.ranges.isEmpty()) {
            this.processExpression();
        }
        return super.getChildren();
    }

    public void findAndSetChild(Expression oldExpr, Expression newExpr) {
    }

    public String getString() {
        return this.getStatement();
    }

    public String getStatement() {
        return "IN_POLYGON('" + this.polygon + "')";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.polygon);
        out.writeObject(this.instance);
        out.writeObject(this.column);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.polygon = (String)in.readObject();
        this.instance = (CustomIndex)in.readObject();
        this.column = (ColumnExpression)in.readObject();
        this.ranges = new ArrayList<Long[]>();
        this.trueExpRes = new ExpressionResult(DataTypes.BOOLEAN, (Object)true);
        this.falseExpRes = new ExpressionResult(DataTypes.BOOLEAN, (Object)false);
    }

    public List<ColumnExpression> getAllColumnList() {
        return new ArrayList<ColumnExpression>(Arrays.asList(this.column));
    }

    public List<ColumnExpression> getColumnList() {
        return this.getAllColumnList();
    }

    public boolean isSingleColumn() {
        return true;
    }

    public List<ExpressionResult> getLiterals() {
        return null;
    }
}

