/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.geo;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.geo.GridData;
import org.apache.carbondata.geo.QuadNode;
import org.apache.carbondata.geo.QuadRect;
import org.apache.log4j.Logger;

public class QuadTreeCls {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)QuadTreeCls.class.getName());
    private QuadNode root;

    public QuadTreeCls(double left, double down, double width, double height, int depth) {
        QuadRect rect = new QuadRect(left, down, width, height);
        int maxColumn = (int)Math.pow(2.0, depth);
        GridData grid = new GridData(0L, maxColumn, 0L, maxColumn, depth);
        this.root = new QuadNode(rect, grid, 1, depth);
        LOGGER.info((Object)("build quad tree successfully, the max column is " + maxColumn));
    }

    public boolean insert(List<double[]> vertexes) {
        if (4 > vertexes.size()) {
            throw new RuntimeException("polygon at least need 4 points, first and last is same.");
        }
        if (!this.isPointsSame(vertexes.get(0), vertexes.get(vertexes.size() - 1))) {
            throw new RuntimeException("please make first point the same as last point");
        }
        QuadRect outerRectangle = this.getOuterRectangle(vertexes.subList(0, vertexes.size() - 1));
        if (this.root.getRect().outsideBox(outerRectangle)) {
            LOGGER.warn((Object)"the query outer rect is bigger than the root node return");
            return false;
        }
        return this.root.insert(vertexes);
    }

    public List<Long[]> getNodesData() {
        ArrayList<Long[]> result = new ArrayList<Long[]>();
        this.getNodeGridRange(this.root, result);
        this.sortRange(result);
        this.combineRange(result);
        LOGGER.info((Object)("after query the range size is " + result.size()));
        return result;
    }

    public void getNodeGridRange(QuadNode node, List<Long[]> result) {
        if (node.getNodeStatus() == 1) {
            Long[] range = node.getGrid().getHashIDRange();
            result.add(range);
        } else {
            this.getSubChildGridRange(node, QuadNode.ChildEnum.BOTTOMLEFT, result);
            this.getSubChildGridRange(node, QuadNode.ChildEnum.TOPLEFT, result);
            this.getSubChildGridRange(node, QuadNode.ChildEnum.TOPRIGHT, result);
            this.getSubChildGridRange(node, QuadNode.ChildEnum.BOTTOMRIGHT, result);
        }
    }

    public void getSubChildGridRange(QuadNode node, QuadNode.ChildEnum childType, List<Long[]> result) {
        QuadNode child = node.getChildren(childType);
        if (child != null) {
            this.getNodeGridRange(child, result);
        }
    }

    public void sortRange(List<Long[]> rangeList) {
        rangeList.sort(new Comparator<Long[]>(){

            @Override
            public int compare(Long[] x, Long[] y) {
                return Long.compare(x[0], y[0]);
            }
        });
    }

    public void combineRange(List<Long[]> rangeList) {
        if (rangeList.size() > 1) {
            int i = 0;
            int j = i + 1;
            while (i < rangeList.size() - 1) {
                long nextStart;
                long previousEnd = rangeList.get(i)[1];
                if (previousEnd + 1L == (nextStart = rangeList.get(j)[0].longValue())) {
                    rangeList.get((int)j)[0] = rangeList.get(i)[0];
                    rangeList.get((int)i)[0] = null;
                    rangeList.get((int)i)[1] = null;
                }
                ++i;
                ++j;
            }
            rangeList.removeIf(item -> item[0] == null && item[1] == null);
        }
    }

    private QuadRect getOuterRectangle(List<double[]> polygon) {
        double left = Double.MAX_VALUE;
        double top = Double.MIN_VALUE;
        double right = Double.MIN_VALUE;
        double bottom = Double.MAX_VALUE;
        for (double[] point : polygon) {
            if (point[0] < left) {
                left = point[0];
            }
            if (point[0] > right) {
                right = point[0];
            }
            if (point[1] < bottom) {
                bottom = point[1];
            }
            if (!(point[1] > top)) continue;
            top = point[1];
        }
        Point2D.Double topLeft = new Point2D.Double(left, top);
        Point2D.Double bottomRight = new Point2D.Double(right, bottom);
        return new QuadRect(topLeft, bottomRight);
    }

    public QuadNode getRoot() {
        return this.root;
    }

    public void clean() {
        if (this.root != null) {
            this.root.clean();
            this.root = null;
        }
    }

    private boolean isPointsSame(double[] x, double[] y) {
        return Double.toString(x[0]).equals(Double.toString(y[0])) && Double.toString(x[1]).equals(Double.toString(y[1]));
    }
}

