/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.geo;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

class QuadRect {
    public Double left;
    public Double top;
    public Double right;
    public Double bottom;
    public Point2D.Double topLeft;
    public Point2D.Double topRight;
    public Point2D.Double bottomRight;
    public Point2D.Double bottomLeft;

    public QuadRect(Point2D.Double topleft, Point2D.Double bottomRight) {
        this.left = topleft.x;
        this.top = topleft.y;
        this.right = bottomRight.x;
        this.bottom = bottomRight.y;
        this.topLeft = new Point2D.Double(this.left, this.top);
        this.topRight = new Point2D.Double(this.right, this.top);
        this.bottomRight = new Point2D.Double(this.right, this.bottom);
        this.bottomLeft = new Point2D.Double(this.left, this.bottom);
    }

    public QuadRect(double x, double y, double x2, double y2) {
        this.left = x;
        this.bottom = y;
        this.right = x2;
        this.top = y2;
        this.topLeft = new Point2D.Double(this.left, this.top);
        this.topRight = new Point2D.Double(this.right, this.top);
        this.bottomRight = new Point2D.Double(this.right, this.bottom);
        this.bottomLeft = new Point2D.Double(this.left, this.bottom);
    }

    public boolean outsideBox(QuadRect polygonRect) {
        return polygonRect.left < this.left || polygonRect.right > this.right || polygonRect.top > this.top || polygonRect.bottom < this.bottom;
    }

    public List<Point2D.Double> getPolygonPointList() {
        ArrayList<Point2D.Double> polygon = new ArrayList<Point2D.Double>();
        polygon.add(this.topLeft);
        polygon.add(this.topRight);
        polygon.add(this.bottomRight);
        polygon.add(this.bottomLeft);
        return polygon;
    }

    public Double[] getMidelePoint() {
        double x = this.left + (this.right - this.left) / 2.0;
        double y = this.bottom + (this.top - this.bottom) / 2.0;
        return new Double[]{x, y};
    }

    public Point2D.Double getMiddlePoint() {
        Double[] mPoint = this.getMidelePoint();
        return new Point2D.Double(mPoint[0], mPoint[1]);
    }

    public List<Point2D.Double> getSplitRect() {
        Double[] mPoint = this.getMidelePoint();
        double middleTopX = mPoint[0];
        double middleTopY = this.top;
        Point2D.Double middleTop = new Point2D.Double(middleTopX, middleTopY);
        double middleBottomX = mPoint[0];
        double middleBottomY = this.bottom;
        Point2D.Double middleBottom = new Point2D.Double(middleBottomX, middleBottomY);
        double leftMiddleX = this.left;
        double leftMiddleY = mPoint[1];
        Point2D.Double leftMiddle = new Point2D.Double(leftMiddleX, leftMiddleY);
        double rightMiddleX = this.right;
        double rightMiddleY = mPoint[1];
        Point2D.Double rightMiddle = new Point2D.Double(rightMiddleX, rightMiddleY);
        Point2D.Double middle = new Point2D.Double(mPoint[0], mPoint[1]);
        ArrayList<Point2D.Double> rectList = new ArrayList<Point2D.Double>();
        rectList.add(this.topLeft);
        rectList.add(middleTop);
        rectList.add(this.topRight);
        rectList.add(leftMiddle);
        rectList.add(middle);
        rectList.add(rightMiddle);
        rectList.add(this.bottomLeft);
        rectList.add(middleBottom);
        rectList.add(this.bottomRight);
        return rectList;
    }
}

