/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.geo;

import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.List;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.geo.GeometryOperation;
import org.apache.carbondata.geo.GridData;
import org.apache.carbondata.geo.QuadRect;
import org.apache.log4j.Logger;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

class QuadNode {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)QuadNode.class.getName());
    private QuadRect rect;
    private GridData grid;
    private int currentDepth;
    private int maxDepth;
    private QuadNode northWest = null;
    private QuadNode northEast = null;
    private QuadNode southWest = null;
    private QuadNode southEast = null;

    public QuadNode(QuadRect rect, GridData grid, int currentDepth, int maxDepth) {
        this.rect = rect;
        this.grid = grid;
        this.currentDepth = currentDepth;
        this.maxDepth = maxDepth;
    }

    public boolean insert(List<double[]> queryPolygon) {
        Polygon polygonGeo = GeometryOperation.getPolygonByDoubleList(queryPolygon);
        if (polygonGeo != null) {
            List<Point2D.Double> polygon;
            Geometry rect = polygonGeo.getEnvelope();
            if (GeometryOperation.disjoint(rect, polygon = this.rect.getPolygonPointList())) {
                LOGGER.info((Object)"quad tree disJoint with query polygon envelope return");
                return false;
            }
            if (!GeometryOperation.disjoint((Geometry)polygonGeo, polygon)) {
                LOGGER.info((Object)"start to insert query polygon to tree");
                this.insert(polygonGeo);
                LOGGER.info((Object)"end to insert query polygon to tree");
                return true;
            }
            LOGGER.info((Object)"polygon disJoint with query polygon return");
            return false;
        }
        LOGGER.info((Object)"query polygon is null return");
        return false;
    }

    public void insert(Polygon queryPolygon) {
        List<Point2D.Double> polygon = this.rect.getPolygonPointList();
        Geometry queryRect = queryPolygon.getEnvelope();
        if (this.isMaxDepth()) {
            Point2D.Double middlePoint = this.rect.getMiddlePoint();
            if (!GeometryOperation.disjoint((Geometry)queryPolygon, middlePoint)) {
                this.grid.setStatus(1);
            } else {
                this.grid.setStatus(2);
            }
        } else if (GeometryOperation.contains((Geometry)queryPolygon, polygon)) {
            this.grid.setStatus(1);
        } else {
            GridData grid;
            this.grid.setStatus(0);
            List<Point2D.Double> rectList = this.rect.getSplitRect();
            List<Point2D.Double> topLeft = Arrays.asList(rectList.get(0), rectList.get(1), rectList.get(4), rectList.get(3));
            List<Point2D.Double> topRight = Arrays.asList(rectList.get(1), rectList.get(2), rectList.get(5), rectList.get(4));
            List<Point2D.Double> bottomLeft = Arrays.asList(rectList.get(3), rectList.get(4), rectList.get(7), rectList.get(6));
            List<Point2D.Double> bottomRight = Arrays.asList(rectList.get(4), rectList.get(5), rectList.get(8), rectList.get(7));
            long gridRowMiddle = this.grid.startRow + (this.grid.endRow - this.grid.startRow) / 2L;
            long gridColumnMiddle = this.grid.startColumn + (this.grid.endColumn - this.grid.startColumn) / 2L;
            if (!GeometryOperation.disjoint(queryRect, topLeft) && !GeometryOperation.disjoint((Geometry)queryPolygon, topLeft)) {
                grid = new GridData(this.grid.startRow, gridRowMiddle, gridColumnMiddle, this.grid.endColumn, this.maxDepth);
                this.insertIntoChildren(ChildEnum.TOPLEFT, grid, topLeft, queryPolygon);
            }
            if (!GeometryOperation.disjoint(queryRect, topRight) && !GeometryOperation.disjoint((Geometry)queryPolygon, topRight)) {
                grid = new GridData(gridRowMiddle, this.grid.endRow, gridColumnMiddle, this.grid.endColumn, this.maxDepth);
                this.insertIntoChildren(ChildEnum.TOPRIGHT, grid, topRight, queryPolygon);
            }
            if (!GeometryOperation.disjoint(queryRect, bottomLeft) && !GeometryOperation.disjoint((Geometry)queryPolygon, bottomLeft)) {
                grid = new GridData(this.grid.startRow, gridRowMiddle, this.grid.startColumn, gridColumnMiddle, this.maxDepth);
                this.insertIntoChildren(ChildEnum.BOTTOMLEFT, grid, bottomLeft, queryPolygon);
            }
            if (!GeometryOperation.disjoint(queryRect, bottomRight) && !GeometryOperation.disjoint((Geometry)queryPolygon, bottomRight)) {
                grid = new GridData(gridRowMiddle, this.grid.endRow, this.grid.startColumn, gridColumnMiddle, this.maxDepth);
                this.insertIntoChildren(ChildEnum.BOTTOMRIGHT, grid, bottomRight, queryPolygon);
            }
            this.combineChild();
            this.checkAndSetDisJoin();
        }
    }

    private void insertIntoChildren(ChildEnum childType, GridData grid, List<Point2D.Double> rectangle, Polygon queryPolygon) {
        QuadRect rect = new QuadRect(rectangle.get(0), rectangle.get(2));
        switch (childType) {
            case TOPLEFT: {
                this.northWest = new QuadNode(rect, grid, this.currentDepth + 1, this.maxDepth);
                this.northWest.insert(queryPolygon);
                break;
            }
            case TOPRIGHT: {
                this.northEast = new QuadNode(rect, grid, this.currentDepth + 1, this.maxDepth);
                this.northEast.insert(queryPolygon);
                break;
            }
            case BOTTOMLEFT: {
                this.southWest = new QuadNode(rect, grid, this.currentDepth + 1, this.maxDepth);
                this.southWest.insert(queryPolygon);
                break;
            }
            case BOTTOMRIGHT: {
                this.southEast = new QuadNode(rect, grid, this.currentDepth + 1, this.maxDepth);
                this.southEast.insert(queryPolygon);
                break;
            }
            default: {
                LOGGER.warn((Object)"child type not match");
            }
        }
    }

    private void combineChild() {
        if (this.checkChildCanCombine(this.northWest) && this.checkChildCanCombine(this.northEast) && this.checkChildCanCombine(this.southWest) && this.checkChildCanCombine(this.southEast)) {
            this.getGrid().setStatus(1);
            this.northWest.clean();
            this.northWest = null;
            this.northEast.clean();
            this.northEast = null;
            this.southWest.clean();
            this.southWest = null;
            this.southEast.clean();
            this.southEast = null;
        }
    }

    private boolean checkChildCanCombine(QuadNode child) {
        return child != null && child.getGrid().getStatus() == 1;
    }

    private void checkAndSetDisJoin() {
        boolean canChange = false;
        if (this.northEast != null && this.northEast.getGrid().getStatus() == 2) {
            this.northEast.clean();
            this.northEast = null;
            canChange = true;
        }
        if (this.northWest != null && this.northWest.getGrid().getStatus() == 2) {
            this.northWest.clean();
            this.northWest = null;
            canChange = true;
        }
        if (this.southWest != null && this.southWest.getGrid().getStatus() == 2) {
            this.southWest.clean();
            this.southWest = null;
            canChange = true;
        }
        if (this.southEast != null && this.southEast.getGrid().getStatus() == 2) {
            this.southEast.clean();
            this.southEast = null;
            canChange = true;
        }
        if (canChange && this.childrenIsNull()) {
            this.getGrid().setStatus(2);
        }
    }

    public QuadRect getRect() {
        return this.rect;
    }

    public GridData getGrid() {
        return this.grid;
    }

    protected boolean isMaxDepth() {
        return this.currentDepth > this.maxDepth;
    }

    public boolean childrenIsNull() {
        return this.northWest == null && this.northEast == null && this.southWest == null && this.southEast == null;
    }

    public void clean() {
        this.rect = null;
        this.grid = null;
        if (this.northWest != null) {
            this.northWest.clean();
        }
        if (this.northEast != null) {
            this.northEast.clean();
        }
        if (this.southWest != null) {
            this.southWest.clean();
        }
        if (this.southEast != null) {
            this.southEast.clean();
        }
    }

    public QuadNode getChildren(ChildEnum childType) {
        switch (childType) {
            case TOPLEFT: {
                return this.northWest;
            }
            case TOPRIGHT: {
                return this.northEast;
            }
            case BOTTOMRIGHT: {
                return this.southEast;
            }
            case BOTTOMLEFT: {
                return this.southWest;
            }
        }
        return null;
    }

    public int getNodeStatus() {
        return this.grid.getStatus();
    }

    public static enum ChildEnum {
        TOPLEFT,
        TOPRIGHT,
        BOTTOMLEFT,
        BOTTOMRIGHT;

    }
}

