/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.geo;

class GridData {
    public static final int STATUS_CONTAIN = 0;
    public static final int STATUS_ALL = 1;
    public static final int STATUS_DISJOIN = 2;
    public long startRow;
    public long endRow;
    public long startColumn;
    public long endColumn;
    private long startHash;
    private long endHash;
    private int maxDepth;
    private int status = 2;

    public GridData(long rs, long re, long cs, long ce, int maxDepth) {
        this.startRow = rs;
        this.endRow = re;
        this.startColumn = cs;
        this.endColumn = ce;
        this.maxDepth = maxDepth;
        this.computeHashidRange();
    }

    public void setGridData(GridData grid) {
        this.startRow = grid.startRow;
        this.endRow = grid.endRow;
        this.startColumn = grid.startColumn;
        this.endColumn = grid.endColumn;
        this.maxDepth = grid.maxDepth;
        this.startHash = grid.startHash;
        this.endHash = grid.endHash;
        this.status = grid.status;
    }

    private void computeHashidRange() {
        this.startHash = this.createHashID(this.startRow, this.startColumn);
        this.endHash = this.createHashID(this.endRow - 1L, this.endColumn - 1L);
    }

    public long createHashID(long row, long column) {
        long index = 0L;
        for (int i = 0; i < this.maxDepth + 1; ++i) {
            long x = row >> i & 1L;
            long y = column >> i & 1L;
            index = index | x << 2 * i + 1 | y << 2 * i;
        }
        return index;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public Long[] getHashIDRange() {
        return new Long[]{this.startHash, this.endHash};
    }
}

