/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.geo;

import java.awt.geom.Point2D;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

class GeometryOperation {
    private static final GeometryFactory geoFactory = new GeometryFactory();

    GeometryOperation() {
    }

    public static Polygon getPolygonByPointList(List<Point2D.Double> polygon) {
        int size = polygon.size();
        if (size < 3) {
            return null;
        }
        Coordinate[] rect = new Coordinate[size + 1];
        for (int i = 0; i < size; ++i) {
            rect[i] = new Coordinate(polygon.get((int)i).x, polygon.get((int)i).y);
        }
        rect[size] = new Coordinate(polygon.get((int)0).x, polygon.get((int)0).y);
        return geoFactory.createPolygon(rect);
    }

    public static Polygon getPolygonByDoubleList(List<double[]> polygon) {
        int size = polygon.size();
        if (size < 4) {
            return null;
        }
        Coordinate[] rect = new Coordinate[size];
        for (int i = 0; i < size; ++i) {
            rect[i] = new Coordinate(polygon.get(i)[0], polygon.get(i)[1]);
        }
        return geoFactory.createPolygon(rect);
    }

    public static Point getPointByPoint2D(Point2D.Double pointB) {
        Coordinate point = new Coordinate(pointB.x, pointB.y);
        return geoFactory.createPoint(point);
    }

    public static boolean disjoint(Geometry polygonA, List<Point2D.Double> polygonB) {
        Polygon polyB = GeometryOperation.getPolygonByPointList(polygonB);
        boolean result = polygonA.disjoint((Geometry)polyB);
        return result;
    }

    public static boolean disjoint(Geometry polygonA, Point2D.Double pointB) {
        Point pointGeo = GeometryOperation.getPointByPoint2D(pointB);
        boolean result = polygonA.disjoint((Geometry)pointGeo);
        return result;
    }

    public static boolean contains(Geometry polygonA, List<Point2D.Double> polygonB) {
        Polygon polyB = GeometryOperation.getPolygonByPointList(polygonB);
        return polygonA.contains((Geometry)polyB);
    }

    public static boolean contains(Geometry polygonA, Point2D.Double pointB) {
        Point pointGeo = GeometryOperation.getPointByPoint2D(pointB);
        boolean result = polygonA.contains((Geometry)pointGeo);
        return result;
    }

    public static boolean intersects(Geometry polygonA, List<Point2D.Double> polygonB) {
        Polygon polyB = GeometryOperation.getPolygonByPointList(polygonB);
        boolean result = polygonA.intersects((Geometry)polyB);
        return result;
    }

    public static boolean intersects(Geometry polygonA, Point2D.Double pointB) {
        Point pointGeo = GeometryOperation.getPointByPoint2D(pointB);
        boolean result = polygonA.intersects((Geometry)pointGeo);
        return result;
    }
}

