/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.geo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.exceptions.sql.MalformedCarbonCommandException;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.util.CustomIndex;
import org.apache.carbondata.geo.QuadTreeCls;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class GeoHashIndex
extends CustomIndex<List<Long[]>> {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)GeoHashIndex.class.getName());
    private static final double CONVERT_FACTOR = 180.0;
    private static final double EARTH_RADIUS = 6371004.0;
    private double oriLatitude;
    private double userDefineMaxLongitude;
    private double userDefineMaxLatitude;
    private double userDefineMinLongitude;
    private double userDefineMinLatitude;
    private double CalculateMaxLongitude;
    private double CalculateMaxLatitude;
    private int gridSize;
    private double mCos;
    private double deltaY;
    private double deltaX;
    private double deltaYByRatio;
    private double deltaXByRatio;
    private int cutLevel;
    private int conversionRatio;
    private double lon0ByRation;
    private double lat0ByRation;

    public void init(String indexName, Map<String, String> properties) throws Exception {
        String[] srcTypes;
        String options = properties.get("spatial_index");
        if (StringUtils.isEmpty((CharSequence)options)) {
            throw new MalformedCarbonCommandException(String.format("%s property is invalid.", "spatial_index"));
        }
        if (!(options = options.toLowerCase()).contains(indexName.toLowerCase())) {
            throw new MalformedCarbonCommandException(String.format("%s property is invalid. %s is not present.", "spatial_index", indexName));
        }
        String commonKey = "spatial_index." + indexName + ".";
        String TYPE = commonKey + "type";
        String type = properties.get(TYPE);
        if (!"geohash".equalsIgnoreCase(type)) {
            throw new MalformedCarbonCommandException(String.format("%s property is invalid. %s property must be %s for this class.", "spatial_index", TYPE, "geohash"));
        }
        String SOURCE_COLUMNS = commonKey + "sourcecolumns";
        String sourceColumnsOption = properties.get(SOURCE_COLUMNS);
        if (StringUtils.isEmpty((CharSequence)sourceColumnsOption)) {
            throw new MalformedCarbonCommandException(String.format("%s property is invalid. Must specify %s property.", "spatial_index", SOURCE_COLUMNS));
        }
        if (sourceColumnsOption.split(",").length != 2) {
            throw new MalformedCarbonCommandException(String.format("%s property is invalid. %s property must have 2 columns.", "spatial_index", SOURCE_COLUMNS));
        }
        String SOURCE_COLUMN_TYPES = commonKey + "sourcecolumntypes";
        String sourceDataTypes = properties.get(SOURCE_COLUMN_TYPES);
        for (String srcdataType : srcTypes = sourceDataTypes.split(",")) {
            if ("bigint".equalsIgnoreCase(srcdataType)) continue;
            throw new MalformedCarbonCommandException(String.format("%s property is invalid. %s datatypes must be long.", "spatial_index", SOURCE_COLUMNS));
        }
        String TARGET_DATA_TYPE = commonKey + "datatype";
        properties.put(TARGET_DATA_TYPE, "long");
        String ORIGIN_LATITUDE = commonKey + "originlatitude";
        String originLatitude = properties.get(ORIGIN_LATITUDE);
        if (StringUtils.isEmpty((CharSequence)originLatitude)) {
            throw new MalformedCarbonCommandException(String.format("%s property is invalid. Must specify %s property.", "spatial_index", ORIGIN_LATITUDE));
        }
        String MIN_LONGITUDE = commonKey + "minlongitude";
        String MAX_LONGITUDE = commonKey + "maxlongitude";
        String MIN_LATITUDE = commonKey + "minlatitude";
        String MAX_LATITUDE = commonKey + "maxlatitude";
        String minLongitude = properties.get(MIN_LONGITUDE);
        String maxLongitude = properties.get(MAX_LONGITUDE);
        String minLatitude = properties.get(MIN_LATITUDE);
        String maxLatitude = properties.get(MAX_LATITUDE);
        if (StringUtils.isEmpty((CharSequence)minLongitude)) {
            throw new MalformedCarbonCommandException(String.format("%s property is invalid. Must specify %s property.", "spatial_index", MIN_LONGITUDE));
        }
        if (StringUtils.isEmpty((CharSequence)minLatitude)) {
            throw new MalformedCarbonCommandException(String.format("%s property is invalid. Must specify %s property.", "spatial_index", MIN_LATITUDE));
        }
        if (StringUtils.isEmpty((CharSequence)maxLongitude)) {
            throw new MalformedCarbonCommandException(String.format("%s property is invalid. Must specify %s property.", "spatial_index", MAX_LONGITUDE));
        }
        if (StringUtils.isEmpty((CharSequence)maxLatitude)) {
            throw new MalformedCarbonCommandException(String.format("%s property is invalid. Must specify %s property.", "spatial_index", MAX_LATITUDE));
        }
        String GRID_SIZE = commonKey + "gridsize";
        String gridSize = properties.get(GRID_SIZE);
        if (StringUtils.isEmpty((CharSequence)gridSize)) {
            throw new MalformedCarbonCommandException(String.format("%s property is invalid. %s property must be specified.", "spatial_index", GRID_SIZE));
        }
        String CONVERSION_RATIO = commonKey + "conversionratio";
        String conversionRatio = properties.get(CONVERSION_RATIO);
        if (StringUtils.isEmpty((CharSequence)conversionRatio)) {
            throw new MalformedCarbonCommandException(String.format("%s property is invalid. %s property must be specified.", "spatial_index", CONVERSION_RATIO));
        }
        this.oriLatitude = Double.valueOf(originLatitude);
        this.userDefineMaxLongitude = Double.valueOf(maxLongitude);
        this.userDefineMaxLatitude = Double.valueOf(maxLatitude);
        this.userDefineMinLongitude = Double.valueOf(minLongitude);
        this.userDefineMinLatitude = Double.valueOf(minLatitude);
        this.gridSize = Integer.parseInt(gridSize);
        this.conversionRatio = Integer.parseInt(conversionRatio);
        this.calculateData();
    }

    public String generate(List<?> sources) throws Exception {
        if (sources.size() != 2) {
            throw new RuntimeException("Source columns list must be of size 2.");
        }
        if (sources.get(0) == null || sources.get(1) == null) {
            return null;
        }
        if (!(sources.get(0) instanceof Long) || !(sources.get(1) instanceof Long)) {
            throw new RuntimeException("Source columns must be of Long type.");
        }
        Long longitude = (Long)sources.get(0);
        Long latitude = (Long)sources.get(1);
        int[] gridPoint = this.calculateID(longitude, latitude);
        Long hashId = this.createHashID(gridPoint[0], gridPoint[1]);
        return String.valueOf(hashId);
    }

    public List<Long[]> query(String polygon) throws Exception {
        if (!this.validate(polygon)) {
            return null;
        }
        String[] pointList = polygon.trim().split(",");
        ArrayList<double[]> queryList = new ArrayList<double[]>();
        for (String str : pointList) {
            String[] points = this.splitString(str);
            if (2 != points.length) {
                throw new RuntimeException("longitude and latitude is a pair need 2 data");
            }
            try {
                queryList.add(new double[]{Double.valueOf(points[0]), Double.valueOf(points[1])});
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("can not covert the string data to double", e);
            }
        }
        if (!this.checkPointsSame(pointList[0], pointList[pointList.length - 1])) {
            throw new RuntimeException("the first point and last point in polygon should be same");
        }
        List<Long[]> rangeList = this.getPolygonRangeList(queryList);
        return rangeList;
    }

    private String[] splitString(String str) {
        return str.trim().split("\\s+");
    }

    private boolean checkPointsSame(String point1, String point2) throws Exception {
        String[] points2;
        String[] points1 = this.splitString(point1);
        return points1[0].equals((points2 = this.splitString(point2))[0]) && points1[1].equals(points2[1]);
    }

    private boolean validate(String polygon) throws Exception {
        String[] pointList = polygon.trim().split(",");
        if (4 > pointList.length) {
            throw new RuntimeException("polygon need at least 3 points, really has " + pointList.length);
        }
        return true;
    }

    private List<Long[]> getPolygonRangeList(List<double[]> queryList) throws Exception {
        QuadTreeCls qTreee = new QuadTreeCls(this.userDefineMinLongitude, this.userDefineMinLatitude, this.CalculateMaxLongitude, this.CalculateMaxLatitude, this.cutLevel);
        qTreee.insert(queryList);
        return qTreee.getNodesData();
    }

    private void calculateData() throws Exception {
        this.mCos = Math.cos(this.oriLatitude / (double)this.conversionRatio * Math.PI / 180.0);
        this.deltaX = (double)(this.gridSize * 360) / (4.003019872478237E7 * this.mCos);
        this.deltaXByRatio = this.deltaX * (double)this.conversionRatio;
        this.deltaY = (double)(this.gridSize * 360) / 4.003019872478237E7;
        this.deltaYByRatio = this.deltaY * (double)this.conversionRatio;
        LOGGER.info((Object)("after spatial calculate delta X is: " + String.format("%f", this.deltaX) + "the delta Y is: " + String.format("%f", this.deltaY)));
        LOGGER.info((Object)("after spatial calculate X ByRatio is: " + String.format("%f", this.deltaXByRatio) + "the Y ByRatio is: " + String.format("%f", this.deltaYByRatio)));
        this.calculateArea();
    }

    private void calculateArea() {
        double Yn;
        this.userDefineMinLongitude -= this.deltaX / 2.0;
        this.userDefineMaxLongitude += this.deltaX / 2.0;
        this.userDefineMinLatitude -= this.deltaY / 2.0;
        this.userDefineMaxLatitude += this.deltaY / 2.0;
        this.lon0ByRation = this.userDefineMinLongitude * (double)this.conversionRatio;
        this.lat0ByRation = this.userDefineMinLatitude * (double)this.conversionRatio;
        double Xn = Math.log((this.userDefineMaxLongitude - this.userDefineMinLongitude) / this.deltaX) / Math.log(2.0);
        double doubleMax = Math.max(Xn, Yn = Math.log((this.userDefineMaxLatitude - this.userDefineMinLatitude) / this.deltaY) / Math.log(2.0));
        this.cutLevel = doubleMax % 1.0 == 0.0 ? (int)doubleMax : (int)(doubleMax + 1.0);
        this.CalculateMaxLongitude = this.userDefineMinLongitude + Math.pow(2.0, this.cutLevel) * this.deltaX;
        this.CalculateMaxLatitude = this.userDefineMinLatitude + Math.pow(2.0, this.cutLevel) * this.deltaY;
        LOGGER.info((Object)("After spatial calculate the cut level is: " + String.format("%d", this.cutLevel)));
        LOGGER.info((Object)("the min longitude is: " + String.format("%f", this.userDefineMinLongitude) + " the max longitude is: " + String.format("%f", this.CalculateMaxLongitude)));
        LOGGER.info((Object)("the min latitude is: " + String.format("%f", this.userDefineMinLatitude) + " the max latitude is: " + String.format("%f", this.CalculateMaxLatitude)));
    }

    private int[] calculateID(long longitude, long latitude) throws Exception {
        try {
            int row = (int)(((double)longitude - this.lon0ByRation) / this.deltaXByRatio);
            int column = (int)(((double)latitude - this.lat0ByRation) / this.deltaYByRatio);
            return new int[]{row, column};
        }
        catch (ArithmeticException e) {
            throw new RuntimeException("can not divide by zero.");
        }
    }

    private long createHashID(long row, long column) {
        long index = 0L;
        for (int i = 0; i < this.cutLevel + 1; ++i) {
            long x = row >> i & 1L;
            long y = column >> i & 1L;
            index = index | x << 2 * i + 1 | y << 2 * i;
        }
        return index;
    }
}

