/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.pulsar.PulsarConfiguration;
import org.apache.camel.component.pulsar.PulsarMessageReceiptFactory;
import org.apache.camel.component.pulsar.utils.AutoConfiguration;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.RedeliveryBackoff;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class PulsarComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, PulsarConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, RedeliveryBackoff.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, PulsarMessageReceiptFactory.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, BatcherBuilder.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, MessageRouter.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, AutoConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, PulsarClient.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "org.apache.camel.component.pulsar.PulsarConfiguration": {
                return this.applicationContext.getBean(ref, PulsarConfiguration.class);
            }
            case "org.apache.pulsar.client.api.RedeliveryBackoff": {
                return this.applicationContext.getBean(ref, RedeliveryBackoff.class);
            }
            case "org.apache.camel.component.pulsar.PulsarMessageReceiptFactory": {
                return this.applicationContext.getBean(ref, PulsarMessageReceiptFactory.class);
            }
            case "org.apache.pulsar.client.api.BatcherBuilder": {
                return this.applicationContext.getBean(ref, BatcherBuilder.class);
            }
            case "org.apache.pulsar.client.api.MessageRouter": {
                return this.applicationContext.getBean(ref, MessageRouter.class);
            }
            case "org.apache.camel.component.pulsar.utils.AutoConfiguration": {
                return this.applicationContext.getBean(ref, AutoConfiguration.class);
            }
            case "org.apache.pulsar.client.api.PulsarClient": {
                return this.applicationContext.getBean(ref, PulsarClient.class);
            }
        }
        return null;
    }
}

