/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jasypt.springboot;

import java.lang.annotation.Annotation;
import org.apache.camel.component.jasypt.springboot.EncryptablePropertySourcesPlaceholderConfigurer;
import org.apache.camel.component.jasypt.springboot.JasyptEncryptedPropertiesConfiguration;
import org.apache.camel.component.jasypt.springboot.JasyptEncryptedPropertiesUtils;
import org.apache.camel.component.jasypt.springboot.JasyptSpringEncryptedPropertiesParser;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.EnvironmentStringPBEConfig;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.salt.RandomSaltGenerator;
import org.jasypt.salt.SaltGenerator;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.bind.handler.IgnoreErrorsBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"camel.component.jasypt.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={CamelAutoConfiguration.class})
public class JasyptEncryptedPropertiesAutoconfiguration {
    @Bean
    public JasyptEncryptedPropertiesConfiguration JasyptEncryptedPropertiesAutoconfiguration(ConfigurableEnvironment environment) {
        JasyptEncryptedPropertiesConfiguration config = new JasyptEncryptedPropertiesConfiguration();
        IgnoreErrorsBindHandler handler = new IgnoreErrorsBindHandler(BindHandler.DEFAULT);
        MutablePropertySources propertySources = environment.getPropertySources();
        PropertySourcesPlaceholdersResolver propertyResolver = new PropertySourcesPlaceholdersResolver((Iterable)propertySources);
        Iterable configurationPropertySources = ConfigurationPropertySources.from((Iterable)propertySources);
        ConversionService conversionService = ApplicationConversionService.getSharedInstance();
        Binder binder = new Binder(configurationPropertySources, (PlaceholdersResolver)propertyResolver, conversionService);
        ResolvableType type = ResolvableType.forClass(JasyptEncryptedPropertiesConfiguration.class);
        Annotation annotation = AnnotationUtils.findAnnotation(JasyptEncryptedPropertiesConfiguration.class, ConfigurationProperties.class);
        Annotation[] annotations = new Annotation[]{annotation};
        Bindable target = Bindable.of((ResolvableType)type).withExistingValue((Object)config).withAnnotations(annotations);
        binder.bind("camel.component.jasypt", target, (BindHandler)handler);
        return config;
    }

    @Bean
    @ConditionalOnMissingBean(value={EnvironmentStringPBEConfig.class})
    public EnvironmentStringPBEConfig environmentVariablesConfiguration(JasyptEncryptedPropertiesConfiguration configuration) {
        EnvironmentStringPBEConfig environmentStringPBEConfig = new EnvironmentStringPBEConfig();
        environmentStringPBEConfig.setAlgorithm(configuration.getAlgorithm());
        environmentStringPBEConfig.setIvGenerator(JasyptEncryptedPropertiesUtils.getIVGenerator(configuration));
        environmentStringPBEConfig.setSaltGenerator(this.getSaltGenerator(configuration));
        environmentStringPBEConfig.setProviderName(configuration.getProviderName());
        JasyptEncryptedPropertiesUtils.parsePassword(environmentStringPBEConfig, configuration);
        return environmentStringPBEConfig;
    }

    @Bean
    @ConditionalOnMissingBean(value={StringEncryptor.class})
    public StringEncryptor stringEncryptor(EnvironmentStringPBEConfig environmentVariablesConfiguration) {
        StandardPBEStringEncryptor standardPBEStringEncryptor = new StandardPBEStringEncryptor();
        standardPBEStringEncryptor.setConfig((PBEConfig)environmentVariablesConfiguration);
        return standardPBEStringEncryptor;
    }

    @Bean
    public EncryptablePropertySourcesPlaceholderConfigurer propertyConfigurer(StringEncryptor stringEncryptor) {
        return new EncryptablePropertySourcesPlaceholderConfigurer(stringEncryptor);
    }

    @Bean
    public PropertiesParser encryptedPropertiesParser(PropertyResolver propertyResolver, StringEncryptor stringEncryptor) {
        return new JasyptSpringEncryptedPropertiesParser(propertyResolver, stringEncryptor);
    }

    public SaltGenerator getSaltGenerator(JasyptEncryptedPropertiesConfiguration configuration) {
        String saltGeneratorClassName = configuration.getSaltGeneratorClassName();
        SaltGenerator saltGenerator = (SaltGenerator)JasyptEncryptedPropertiesUtils.loadClass(saltGeneratorClassName);
        if (saltGenerator != null) {
            return saltGenerator;
        }
        return new RandomSaltGenerator();
    }
}

