/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.drive.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.google.drive.GoogleDriveClientFactory;
import org.apache.camel.component.google.drive.GoogleDriveConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class GoogleDriveComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, GoogleDriveConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, GoogleDriveClientFactory.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "org.apache.camel.component.google.drive.GoogleDriveConfiguration": {
                return this.applicationContext.getBean(ref, GoogleDriveConfiguration.class);
            }
            case "org.apache.camel.component.google.drive.GoogleDriveClientFactory": {
                return this.applicationContext.getBean(ref, GoogleDriveClientFactory.class);
            }
        }
        return null;
    }
}

