/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.opentelemetry;

import io.opentelemetry.api.trace.Tracer;
import io.quarkus.arc.DefaultBean;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.apache.camel.opentelemetry.CamelQuarkusOpenTelemetryTracer;
import org.apache.camel.opentelemetry.OpenTelemetryTracer;
import org.apache.camel.opentelemetry.OpenTelemetryTracingStrategy;
import org.apache.camel.quarkus.component.opentelemetry.CamelOpenTelemetryConfig;
import org.apache.camel.spi.InterceptStrategy;

@Singleton
public class OpenTelemetryTracerProducer {
    @Inject
    CamelOpenTelemetryConfig config;
    @Inject
    OTelRuntimeConfig oTelRuntimeConfig;
    @Inject
    Tracer tracer;

    @Produces
    @Singleton
    @DefaultBean
    public OpenTelemetryTracer getOpenTelemetry() {
        if (!this.oTelRuntimeConfig.sdkDisabled()) {
            CamelQuarkusOpenTelemetryTracer openTelemetryTracer = new CamelQuarkusOpenTelemetryTracer();
            if (this.tracer != null) {
                openTelemetryTracer.setTracer(this.tracer);
                if (this.config.excludePatterns().isPresent()) {
                    openTelemetryTracer.setExcludePatterns(this.config.excludePatterns().get());
                }
                if (this.config.traceProcessors()) {
                    OpenTelemetryTracingStrategy tracingStrategy = new OpenTelemetryTracingStrategy((OpenTelemetryTracer)openTelemetryTracer);
                    tracingStrategy.setPropagateContext(true);
                    openTelemetryTracer.setTracingStrategy((InterceptStrategy)tracingStrategy);
                }
                openTelemetryTracer.setEncoding(this.config.encoding());
            }
            return openTelemetryTracer;
        }
        return null;
    }
}

