/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mapstruct;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.mapstruct.MapStructMapperFinder;
import org.apache.camel.component.mapstruct.MapstructComponent;
import org.apache.camel.quarkus.component.mapstruct.CamelQuarkusMapStructMapperFinder;
import org.apache.camel.quarkus.component.mapstruct.ConversionMethodInfo;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@Recorder
public class MapStructRecorder {
    public RuntimeValue<?> createMapper(String mapperClassName) {
        try {
            Object mapper = Thread.currentThread().getContextClassLoader().loadClass(mapperClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return new RuntimeValue(mapper);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public RuntimeValue<ConversionMethodInfo> createConversionMethodInfo(Class<?> from, Class<?> to, boolean cdiBean, RuntimeValue<?> mapper, String conversionMethodClassName) {
        return new RuntimeValue((Object)new ConversionMethodInfo(from, to, cdiBean, mapper, conversionMethodClassName));
    }

    public RuntimeValue<MapstructComponent> createMapStructComponent(Set<String> mapperPackages, Set<RuntimeValue<ConversionMethodInfo>> conversionMethodInfos) {
        String packages = String.join((CharSequence)",", mapperPackages);
        CamelQuarkusMapStructMapperFinder finder = new CamelQuarkusMapStructMapperFinder(packages, conversionMethodInfos.size());
        MapstructComponent component = new MapstructComponent();
        component.setMapperPackageName(packages);
        component.setMapStructConverter((MapStructMapperFinder)finder);
        return new RuntimeValue((Object)component);
    }

    public void registerMapStructTypeConverters(RuntimeValue<TypeConverterRegistry> typeConverterRegistryRuntimeValue, Set<RuntimeValue<ConversionMethodInfo>> conversionMethods, BeanContainer container) {
        TypeConverterRegistry registry = (TypeConverterRegistry)typeConverterRegistryRuntimeValue.getValue();
        conversionMethods.forEach(c -> {
            try {
                Object conversionMethod;
                ConversionMethodInfo info = (ConversionMethodInfo)c.getValue();
                Class<?> conversionMethodClass = Thread.currentThread().getContextClassLoader().loadClass(info.getConversionMethodClassName());
                if (info.isCdiBean()) {
                    conversionMethod = container.beanInstance(conversionMethodClass, new Annotation[0]);
                } else if (info.getMapper() != null) {
                    Object mapper = info.getMapper().getValue();
                    conversionMethod = conversionMethodClass.getDeclaredConstructor(mapper.getClass()).newInstance(mapper);
                } else {
                    conversionMethod = conversionMethodClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                registry.addTypeConverter(info.getToClass(), info.getFromClass(), (TypeConverter)new SimpleTypeConverter(false, (SimpleTypeConverter.ConversionMethod)conversionMethod));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

