/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.karaf.commands.AbstractRouteCommand;
import org.apache.camel.spi.ManagementAgent;
import org.apache.felix.gogo.commands.Command;

@Command(scope="camel", name="route-reset-stats", description="Reset performance stats on a route or group of routes")
public class RouteResetStats
extends AbstractRouteCommand {
    @Override
    public void executeOnRoute(CamelContext camelContext, Route camelRoute) throws Exception {
        String id = camelRoute.getId();
        ManagementAgent agent = camelContext.getManagementStrategy().getManagementAgent();
        if (agent != null) {
            String camelId;
            MBeanServer mBeanServer = agent.getMBeanServer();
            ObjectName query = ObjectName.getInstance("org.apache.camel:type=routes,*");
            Set<ObjectName> set = mBeanServer.queryNames(query, null);
            for (ObjectName routeMBean : set) {
                camelId = (String)mBeanServer.getAttribute(routeMBean, "CamelId");
                if (camelId == null || !camelId.equals(camelContext.getName())) continue;
                mBeanServer.invoke(routeMBean, "reset", null, null);
            }
            query = ObjectName.getInstance("org.apache.camel:type=processors,*");
            set = mBeanServer.queryNames(query, null);
            for (ObjectName processorMBean : set) {
                camelId = (String)mBeanServer.getAttribute(processorMBean, "CamelId");
                String routeId = (String)mBeanServer.getAttribute(processorMBean, "RouteId");
                if (camelId == null || !camelId.equals(camelContext.getName()) || routeId == null || !routeId.equals(id)) continue;
                mBeanServer.invoke(processorMBean, "reset", null, null);
            }
        }
    }
}

