/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import org.apache.camel.CamelContext;
import org.apache.camel.karaf.commands.CamelController;
import org.apache.camel.processor.interceptor.BacklogTracer;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="camel", name="backlog-tracer-start", description="Starts the Backlog tracer")
public class BacklogTracerStart
extends OsgiCommandSupport {
    @Argument(index=0, name="context", description="The name of the Camel context.", required=true, multiValued=false)
    String context;
    @Option(name="--pattern", aliases={"-p"}, description="To trace messages only for nodes or routes matching the given pattern (default is all)", required=false, multiValued=false)
    String pattern;
    @Option(name="--filter", aliases={"-f"}, description="To trace messages only for nodes or routes matching the given filter (using simple language by default)", required=false, multiValued=false)
    String filter;
    @Option(name="--backlogSize", aliases={"-s"}, description="Number of maximum traced messages in total to keep in the backlog (FIFO queue)", required=false, multiValued=false, valueToShowInHelp="1000")
    Integer backlogSize;
    @Option(name="--removeOnDump", aliases={"-r"}, description="Whether to remove traced messages when dumping the messages", required=false, multiValued=false)
    Boolean removeOnDump;
    private CamelController camelController;

    public void setCamelController(CamelController camelController) {
        this.camelController = camelController;
    }

    protected Object doExecute() throws Exception {
        CamelContext camel = this.camelController.getCamelContext(this.context);
        if (camel == null) {
            System.err.println("CamelContext " + this.context + " not found.");
            return null;
        }
        BacklogTracer backlogTracer = BacklogTracer.getBacklogTracer((CamelContext)camel);
        if (backlogTracer == null) {
            backlogTracer = (BacklogTracer)camel.getDefaultBacklogTracer();
        }
        backlogTracer.setEnabled(true);
        if (this.backlogSize != null) {
            backlogTracer.setBacklogSize(this.backlogSize.intValue());
        }
        if (this.removeOnDump != null) {
            backlogTracer.setRemoveOnDump(this.removeOnDump.booleanValue());
        }
        backlogTracer.setTracePattern(this.pattern);
        backlogTracer.setTraceFilter(this.filter);
        System.out.println("BacklogTracer started on " + camel.getName() + " with size: " + backlogTracer.getBacklogSize());
        return null;
    }
}

