/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.io.IOException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmppPrivateChatProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(XmppPrivateChatProducer.class);
    private final XmppEndpoint endpoint;
    private XMPPConnection connection;
    private final String participant;

    public XmppPrivateChatProducer(XmppEndpoint endpoint, String participant) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.participant = participant;
        ObjectHelper.notEmpty((String)participant, (String)"participant");
        LOG.debug("Creating XmppPrivateChatProducer to participant {}", (Object)participant);
    }

    public void process(Exchange exchange) {
        try {
            if (this.connection == null) {
                this.connection = this.endpoint.createConnection();
            }
            if (!this.connection.isConnected()) {
                this.reconnect();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not connect to XMPP server.", e);
        }
        String participant = this.endpoint.getParticipant();
        String thread = this.endpoint.getChatId();
        if (participant == null) {
            participant = this.getParticipant();
        } else {
            thread = "Chat:" + participant + ":" + this.endpoint.getUser();
        }
        ChatManager chatManager = ChatManager.getInstanceFor((XMPPConnection)this.connection);
        Chat chat = this.getOrCreateChat(chatManager, participant, thread);
        Message message = null;
        try {
            message = new Message();
            message.setTo(participant);
            message.setThread(thread);
            message.setType(Message.Type.normal);
            this.endpoint.getBinding().populateXmppMessage(message, exchange);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending XMPP message to {} from {} : {}", new Object[]{participant, this.endpoint.getUser(), message.getBody()});
            }
            chat.sendMessage(message);
        }
        catch (Exception e) {
            throw new RuntimeExchangeException("Could not send XMPP message to " + participant + " from " + this.endpoint.getUser() + " : " + message + " to: " + XmppEndpoint.getConnectionMessage(this.connection), exchange, (Throwable)e);
        }
    }

    private synchronized Chat getOrCreateChat(ChatManager chatManager, final String participant, String thread) {
        Chat chat;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Looking for existing chat instance with thread ID {}", (Object)this.endpoint.getChatId());
        }
        if ((chat = chatManager.getThreadChat(thread)) == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Creating new chat instance with thread ID {}", (Object)thread);
            }
            chat = chatManager.createChat(participant, thread, new MessageListener(){

                public void processMessage(Chat chat, Message message) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received and discarding message from {} : {}", (Object)participant, (Object)message.getBody());
                    }
                }
            });
        }
        return chat;
    }

    private synchronized void reconnect() throws XMPPException, SmackException, IOException {
        if (!this.connection.isConnected()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reconnecting to: {}", (Object)XmppEndpoint.getConnectionMessage(this.connection));
            }
            this.connection.connect();
        }
    }

    protected void doStart() throws Exception {
        if (this.connection == null) {
            try {
                this.connection = this.endpoint.createConnection();
            }
            catch (SmackException e) {
                if (this.endpoint.isTestConnectionOnStartup()) {
                    throw new RuntimeException("Could not establish connection to XMPP server:  " + this.endpoint.getConnectionDescription(), e);
                }
                LOG.warn("Could not connect to XMPP server. {}  Producer will attempt lazy connection when needed.", (Object)e.getMessage());
            }
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.connection != null && this.connection.isConnected()) {
            this.connection.disconnect();
        }
        this.connection = null;
        super.doStop();
    }

    public String getParticipant() {
        return this.participant;
    }
}

