/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ObjectHelper;
import org.jivesoftware.smack.packet.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmppBinding {
    private static final Logger LOG = LoggerFactory.getLogger(XmppBinding.class);
    private HeaderFilterStrategy headerFilterStrategy;

    public XmppBinding() {
        this.headerFilterStrategy = new DefaultHeaderFilterStrategy();
    }

    public XmppBinding(HeaderFilterStrategy headerFilterStrategy) {
        ObjectHelper.notNull((Object)headerFilterStrategy, (String)"headerFilterStrategy");
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public void populateXmppMessage(Message message, Exchange exchange) {
        message.setBody((String)exchange.getIn().getBody(String.class));
        Set entries = exchange.getIn().getHeaders().entrySet();
        for (Map.Entry entry : entries) {
            Object value;
            String name = (String)entry.getKey();
            if (this.headerFilterStrategy.applyFilterToCamelHeaders(name, value = entry.getValue(), exchange)) continue;
            if ("subject".equalsIgnoreCase(name)) {
                String subject = (String)exchange.getContext().getTypeConverter().convertTo(String.class, value);
                message.setSubject(subject);
                continue;
            }
            if ("language".equalsIgnoreCase(name)) {
                String language = (String)exchange.getContext().getTypeConverter().convertTo(String.class, value);
                message.setLanguage(language);
                continue;
            }
            try {
                message.setProperty(name, value);
                LOG.trace("Added property name: {} value: {}", (Object)name, (Object)value.toString());
            }
            catch (IllegalArgumentException iae) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Cannot add property " + name + " to XMPP message due: ", (Throwable)iae);
            }
        }
        String id = exchange.getExchangeId();
        if (id != null) {
            message.setProperty("exchangeId", (Object)id);
        }
    }

    public Object extractBodyFromXmpp(Exchange exchange, Message message) {
        return message.getBody();
    }

    public Map<String, Object> extractHeadersFromXmpp(Message xmppMessage, Exchange exchange) {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        for (String name : xmppMessage.getPropertyNames()) {
            Object value;
            if (this.headerFilterStrategy.applyFilterToExternalHeaders(name, value = xmppMessage.getProperty(name), exchange)) continue;
            answer.put(name, value);
        }
        answer.put("CamelXmppMessageType", xmppMessage.getType());
        answer.put("CamelXmppSubject", xmppMessage.getSubject());
        answer.put("CamelXmppThreadID", xmppMessage.getThread());
        answer.put("CamelXmppFrom", xmppMessage.getFrom());
        answer.put("CamelXmppPacketID", xmppMessage.getPacketID());
        answer.put("CamelXmppTo", xmppMessage.getTo());
        return answer;
    }
}

