/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import org.apache.camel.CamelContext;
import org.apache.camel.TypeConverter;
import org.apache.camel.core.osgi.OsgiCamelContextHelper;
import org.apache.camel.core.osgi.OsgiTypeConverter;
import org.apache.camel.core.osgi.utils.BundleContextUtils;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.Registry;
import org.osgi.framework.BundleContext;

public class OsgiDefaultCamelContext
extends DefaultCamelContext {
    private final BundleContext bundleContext;
    private final Registry registry;

    public OsgiDefaultCamelContext(BundleContext bundleContext) {
        this(bundleContext, null);
    }

    public OsgiDefaultCamelContext(BundleContext bundleContext, Registry registry) {
        this.bundleContext = bundleContext;
        this.registry = registry;
        OsgiCamelContextHelper.osgiUpdate(this, bundleContext);
    }

    protected Registry createRegistry() {
        if (this.registry != null) {
            return OsgiCamelContextHelper.wrapRegistry((CamelContext)this, this.registry, this.bundleContext);
        }
        return OsgiCamelContextHelper.wrapRegistry((CamelContext)this, super.createRegistry(), this.bundleContext);
    }

    protected TypeConverter createTypeConverter() {
        BundleContext ctx = BundleContextUtils.getBundleContext(((Object)((Object)this)).getClass());
        if (ctx == null) {
            ctx = this.bundleContext;
        }
        return new OsgiTypeConverter(ctx, this.getInjector());
    }

    public void setName(String name) {
        super.setName(name);
        super.setManagementName(name + "-" + this.bundleContext.getBundle().getBundleId());
    }
}

