/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.pollingconsumer;

import java.util.TimeZone;
import java.util.concurrent.ScheduledFuture;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.spi.ScheduledPollConsumerScheduler;
import org.apache.camel.spring.util.CamelThreadPoolTaskScheduler;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;

public class SpringScheduledPollConsumerScheduler
extends ServiceSupport
implements ScheduledPollConsumerScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(SpringScheduledPollConsumerScheduler.class);
    private CamelContext camelContext;
    private Consumer consumer;
    private Runnable runnable;
    private String cron;
    private TimeZone timeZone = TimeZone.getDefault();
    private volatile CronTrigger trigger;
    private volatile ThreadPoolTaskScheduler taskScheduler;
    private boolean destroyTaskScheduler;
    private volatile ScheduledFuture future;

    public void onInit(Consumer consumer) {
        this.consumer = consumer;
    }

    public void scheduleTask(Runnable runnable) {
        this.runnable = runnable;
    }

    public void unscheduleTask() {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
    }

    public void startScheduler() {
    }

    public boolean isSchedulerStarted() {
        return this.taskScheduler != null && !this.taskScheduler.getScheduledExecutor().isShutdown();
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public String getCron() {
        return this.cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public ThreadPoolTaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public void setTaskScheduler(ThreadPoolTaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notEmpty((String)this.cron, (String)"cron", (Object)((Object)this));
        this.trigger = new CronTrigger(this.getCron(), this.getTimeZone());
        if (this.taskScheduler == null) {
            this.taskScheduler = new CamelThreadPoolTaskScheduler(this.getCamelContext(), this.consumer, this.consumer.getEndpoint().getEndpointUri());
            this.taskScheduler.afterPropertiesSet();
            this.destroyTaskScheduler = true;
        }
        LOG.debug("Scheduling cron trigger {}", (Object)this.getCron());
        this.future = this.taskScheduler.schedule(this.runnable, (Trigger)this.trigger);
    }

    protected void doStop() throws Exception {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
        if (this.destroyTaskScheduler) {
            this.taskScheduler.destroy();
            this.taskScheduler = null;
        }
    }
}

