/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.ws.filter.impl;

import java.util.HashSet;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.spring.ws.filter.MessageFilter;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapMessage;

public class BasicMessageFilter
implements MessageFilter {
    private static final String BREADCRUMB_ID = "BreadcrumbId";

    @Override
    public void filterProducer(Exchange exchange, WebServiceMessage response) {
        if (exchange != null) {
            this.processHeaderAndAttachments(exchange.getIn(), response);
        }
    }

    @Override
    public void filterConsumer(Exchange exchange, WebServiceMessage response) {
        if (exchange != null) {
            this.processHeaderAndAttachments(exchange.getOut(), response);
        }
    }

    protected void processHeaderAndAttachments(Message inOrOut, WebServiceMessage response) {
        if (response instanceof SoapMessage) {
            SoapMessage soapMessage = (SoapMessage)response;
            this.processSoapHeader(inOrOut, soapMessage);
            this.doProcessSoapAttachments(inOrOut, soapMessage);
        }
    }

    protected void processSoapHeader(Message inOrOut, SoapMessage soapMessage) {
        boolean isHeaderAvailable;
        boolean bl = isHeaderAvailable = inOrOut != null && inOrOut.getHeaders() != null && !inOrOut.getHeaders().isEmpty();
        if (isHeaderAvailable) {
            this.doProcessSoapHeader(inOrOut, soapMessage);
        }
    }

    protected void doProcessSoapHeader(Message inOrOut, SoapMessage soapMessage) {
        SoapHeader soapHeader = soapMessage.getSoapHeader();
        Map headers = inOrOut.getHeaders();
        HashSet headerKeySet = new HashSet(headers.keySet());
        headerKeySet.remove("CamelSpringWebserviceSoapAction");
        headerKeySet.remove("CamelSpringWebserviceEndpointUri");
        headerKeySet.remove("CamelSpringWebserviceAddressingAction");
        headerKeySet.remove("CamelSpringWebserviceAddressingFaultTo");
        headerKeySet.remove("CamelSpringWebserviceAddressingReplyTo");
        headerKeySet.remove("CamelSpringWebserviceAddressingFaultAction");
        headerKeySet.remove("CamelSpringWebserviceAddressingOutputAction");
        headerKeySet.remove(BREADCRUMB_ID);
        for (String name : headerKeySet) {
            Object value = headers.get(name);
            if (value instanceof QName) {
                soapHeader.addHeaderElement((QName)value);
                continue;
            }
            if (!(value instanceof String)) continue;
            soapHeader.addAttribute(new QName(name), value + "");
        }
    }

    protected void doProcessSoapAttachments(Message inOrOut, SoapMessage response) {
        Map attachments = inOrOut.getAttachments();
        HashSet keySet = new HashSet(attachments.keySet());
        for (String key : keySet) {
            response.addAttachment(key, (DataHandler)attachments.get(key));
        }
    }
}

