/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq.reply;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Connection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.Service;
import org.apache.camel.component.rabbitmq.RabbitMQEndpoint;
import org.apache.camel.component.rabbitmq.reply.CorrelationTimeoutMap;
import org.apache.camel.component.rabbitmq.reply.QueueReplyHandler;
import org.apache.camel.component.rabbitmq.reply.ReplyHandler;
import org.apache.camel.component.rabbitmq.reply.ReplyHolder;
import org.apache.camel.component.rabbitmq.reply.ReplyManager;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReplyManagerSupport
extends ServiceSupport
implements ReplyManager {
    protected final Logger log = LoggerFactory.getLogger(ReplyManagerSupport.class);
    protected final CamelContext camelContext;
    protected final CountDownLatch replyToLatch = new CountDownLatch(1);
    protected final long replyToTimeout = 1000L;
    protected ScheduledExecutorService executorService;
    protected RabbitMQEndpoint endpoint;
    protected String replyTo;
    protected Connection listenerContainer;
    protected CorrelationTimeoutMap correlation;
    private int closeTimeout = 30000;

    public ReplyManagerSupport(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void setScheduledExecutorService(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public void setEndpoint(RabbitMQEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void setReplyTo(String replyTo) {
        this.log.debug("ReplyTo destination: {}", (Object)replyTo);
        this.replyTo = replyTo;
        this.replyToLatch.countDown();
    }

    @Override
    public String getReplyTo() {
        if (this.replyTo != null) {
            return this.replyTo;
        }
        try {
            this.log.trace("Waiting for replyTo to be set");
            boolean done = this.replyToLatch.await(1000L, TimeUnit.MILLISECONDS);
            if (!done) {
                this.log.warn("ReplyTo destination was not set and timeout occurred");
            } else {
                this.log.trace("Waiting for replyTo to be set done");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.replyTo;
    }

    @Override
    public String registerReply(ReplyManager replyManager, Exchange exchange, AsyncCallback callback, String originalCorrelationId, String correlationId, long requestTimeout) {
        QueueReplyHandler handler = new QueueReplyHandler(replyManager, exchange, callback, originalCorrelationId, correlationId, requestTimeout);
        ReplyHandler result = this.correlation.putIfAbsent(correlationId, handler, requestTimeout);
        if (result != null) {
            String logMessage = String.format("The correlationId [%s] is not unique.", correlationId);
            throw new IllegalArgumentException(logMessage);
        }
        return correlationId;
    }

    protected abstract ReplyHandler createReplyHandler(ReplyManager var1, Exchange var2, AsyncCallback var3, String var4, String var5, long var6);

    public void onMessage(AMQP.BasicProperties properties, byte[] message) {
        String correlationID = properties.getCorrelationId();
        if (correlationID == null) {
            this.log.warn("Ignoring message with no correlationID: {}", (Object)message);
            return;
        }
        this.log.debug("Received reply message with correlationID [{}] -> {}", (Object)correlationID, (Object)message);
        this.handleReplyMessage(correlationID, properties, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processReply(ReplyHolder holder) {
        this.log.info("in processReply");
        if (holder != null && this.isRunAllowed()) {
            try {
                Exchange exchange = holder.getExchange();
                boolean timeout = holder.isTimeout();
                if (timeout) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("Timeout occurred after {} millis waiting for reply message with correlationID [{}] on destination {}. Setting ExchangeTimedOutException on {} and continue routing.", new Object[]{holder.getRequestTimeout(), holder.getCorrelationId(), this.replyTo, ExchangeHelper.logIds((Exchange)exchange)});
                    }
                    String msg = "reply message with correlationID: " + holder.getCorrelationId() + " not received on destination: " + this.replyTo;
                    exchange.setException((Throwable)new ExchangeTimedOutException(exchange, holder.getRequestTimeout(), msg));
                } else {
                    this.endpoint.setRabbitExchange(exchange, null, holder.getProperties(), holder.getMessage());
                    if (holder.getOriginalCorrelationId() != null) {
                        if (exchange.getOut() != null) {
                            exchange.getOut().setHeader("rabbitmq.CORRELATIONID", (Object)holder.getOriginalCorrelationId());
                        } else {
                            exchange.getIn().setHeader("rabbitmq.CORRELATIONID", (Object)holder.getOriginalCorrelationId());
                        }
                    }
                }
            }
            finally {
                AsyncCallback callback = holder.getCallback();
                callback.done(false);
            }
        }
    }

    protected abstract void handleReplyMessage(String var1, AMQP.BasicProperties var2, byte[] var3);

    protected abstract Connection createListenerContainer() throws Exception;

    protected ReplyHandler waitForProvisionCorrelationToBeUpdated(String correlationID, byte[] message) {
        if (this.log.isWarnEnabled()) {
            this.log.warn("Early reply received with correlationID [{}] -> {}", (Object)correlationID, (Object)message);
        }
        ReplyHandler answer = null;
        boolean done = false;
        int counter = 0;
        while (!done && counter++ < 50) {
            this.log.trace("Early reply not found handler at attempt {}. Waiting a bit longer.", (Object)counter);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            answer = this.correlation.get(correlationID);
            boolean bl = done = answer != null;
            if (answer == null || !this.log.isTraceEnabled()) continue;
            this.log.trace("Early reply with correlationID [{}] has been matched after {} attempts and can be processed using handler: {}", new Object[]{correlationID, counter, answer});
        }
        return answer;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.executorService, (String)"executorService", (Object)this);
        ObjectHelper.notNull((Object)((Object)this.endpoint), (String)"endpoint", (Object)this);
        this.log.debug("Using timeout checker interval with {} millis", (Object)this.endpoint.getRequestTimeoutCheckerInterval());
        this.correlation = new CorrelationTimeoutMap(this.executorService, this.endpoint.getRequestTimeoutCheckerInterval());
        ServiceHelper.startService((Service)this.correlation);
        this.listenerContainer = this.createListenerContainer();
        this.log.debug("Using executor {}", (Object)this.executorService);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)((Object)this.correlation));
        if (this.listenerContainer != null) {
            this.log.debug("Closing connection: {} with timeout: {} ms.", (Object)this.listenerContainer, (Object)this.closeTimeout);
            this.listenerContainer.close(this.closeTimeout);
            this.listenerContainer = null;
        }
        if (this.executorService != null) {
            this.camelContext.getExecutorServiceManager().shutdownGraceful((ExecutorService)this.executorService);
            this.executorService = null;
        }
    }
}

