/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.LongString;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQMessageConverter {
    protected static final Logger LOG = LoggerFactory.getLogger(RabbitMQMessageConverter.class);

    public void mergeAmqpProperties(Exchange exchange, AMQP.BasicProperties properties) {
        if (properties.getType() != null) {
            exchange.getIn().setHeader("rabbitmq.TYPE", (Object)properties.getType());
        }
        if (properties.getAppId() != null) {
            exchange.getIn().setHeader("rabbitmq.APP_ID", (Object)properties.getAppId());
        }
        if (properties.getClusterId() != null) {
            exchange.getIn().setHeader("rabbitmq.CLUSTERID", (Object)properties.getClusterId());
        }
        if (properties.getContentEncoding() != null) {
            exchange.getIn().setHeader("rabbitmq.CONTENT_ENCODING", (Object)properties.getContentEncoding());
        }
        if (properties.getContentType() != null) {
            exchange.getIn().setHeader("rabbitmq.CONTENT_TYPE", (Object)properties.getContentType());
        }
        if (properties.getCorrelationId() != null) {
            exchange.getIn().setHeader("rabbitmq.CORRELATIONID", (Object)properties.getCorrelationId());
        }
        if (properties.getExpiration() != null) {
            exchange.getIn().setHeader("rabbitmq.EXPIRATION", (Object)properties.getExpiration());
        }
        if (properties.getMessageId() != null) {
            exchange.getIn().setHeader("rabbitmq.MESSAGE_ID", (Object)properties.getMessageId());
        }
        if (properties.getPriority() != null) {
            exchange.getIn().setHeader("rabbitmq.PRIORITY", (Object)properties.getPriority());
        }
        if (properties.getReplyTo() != null) {
            exchange.getIn().setHeader("rabbitmq.REPLY_TO", (Object)properties.getReplyTo());
        }
        if (properties.getTimestamp() != null) {
            exchange.getIn().setHeader("rabbitmq.TIMESTAMP", (Object)properties.getTimestamp());
        }
        if (properties.getUserId() != null) {
            exchange.getIn().setHeader("rabbitmq.USERID", (Object)properties.getUserId());
        }
    }

    public AMQP.BasicProperties.Builder buildProperties(Exchange exchange) {
        Object timestamp;
        Object appId;
        Object expiration;
        Object contentEncoding;
        Object type;
        Object userId;
        Object deliveryMode;
        Object correlationId;
        Object replyTo;
        Object clusterId;
        Object messageId;
        Object priority;
        AMQP.BasicProperties.Builder properties = new AMQP.BasicProperties.Builder();
        Message msg = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        Object contentType = msg.removeHeader("rabbitmq.CONTENT_TYPE");
        if (contentType != null) {
            properties.contentType(contentType.toString());
        }
        if ((priority = msg.removeHeader("rabbitmq.PRIORITY")) != null) {
            properties.priority(Integer.valueOf(Integer.parseInt(priority.toString())));
        }
        if ((messageId = msg.removeHeader("rabbitmq.MESSAGE_ID")) != null) {
            properties.messageId(messageId.toString());
        }
        if ((clusterId = msg.removeHeader("rabbitmq.CLUSTERID")) != null) {
            properties.clusterId(clusterId.toString());
        }
        if ((replyTo = msg.removeHeader("rabbitmq.REPLY_TO")) != null) {
            properties.replyTo(replyTo.toString());
        }
        if ((correlationId = msg.removeHeader("rabbitmq.CORRELATIONID")) != null) {
            properties.correlationId(correlationId.toString());
        }
        if ((deliveryMode = msg.removeHeader("rabbitmq.DELIVERY_MODE")) != null) {
            properties.deliveryMode(Integer.valueOf(Integer.parseInt(deliveryMode.toString())));
        }
        if ((userId = msg.removeHeader("rabbitmq.USERID")) != null) {
            properties.userId(userId.toString());
        }
        if ((type = msg.removeHeader("rabbitmq.TYPE")) != null) {
            properties.type(type.toString());
        }
        if ((contentEncoding = msg.removeHeader("rabbitmq.CONTENT_ENCODING")) != null) {
            properties.contentEncoding(contentEncoding.toString());
        }
        if ((expiration = msg.removeHeader("rabbitmq.EXPIRATION")) != null) {
            properties.expiration(expiration.toString());
        }
        if ((appId = msg.removeHeader("rabbitmq.APP_ID")) != null) {
            properties.appId(appId.toString());
        }
        if ((timestamp = msg.removeHeader("rabbitmq.TIMESTAMP")) != null) {
            properties.timestamp(new Date(Long.parseLong(timestamp.toString())));
        }
        Map headers = msg.getHeaders();
        HashMap filteredHeaders = new HashMap();
        for (Map.Entry header : headers.entrySet()) {
            Object value = this.getValidRabbitMQHeaderValue(header.getValue());
            if (value != null) {
                filteredHeaders.put(header.getKey(), header.getValue());
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            if (header.getValue() == null) {
                LOG.debug("Ignoring header: {} with null value", header.getKey());
                continue;
            }
            LOG.debug("Ignoring header: {} of class: {} with value: {}", new Object[]{header.getKey(), ObjectHelper.classCanonicalName(header.getValue()), header.getValue()});
        }
        properties.headers(filteredHeaders);
        return properties;
    }

    private Object getValidRabbitMQHeaderValue(Object headerValue) {
        if (headerValue instanceof String) {
            return headerValue;
        }
        if (headerValue instanceof BigDecimal) {
            return headerValue;
        }
        if (headerValue instanceof Number) {
            return headerValue;
        }
        if (headerValue instanceof Boolean) {
            return headerValue;
        }
        if (headerValue instanceof Date) {
            return headerValue;
        }
        if (headerValue instanceof byte[]) {
            return headerValue;
        }
        if (headerValue instanceof LongString) {
            return headerValue;
        }
        if (headerValue instanceof Timestamp) {
            return headerValue;
        }
        if (headerValue instanceof Byte) {
            return headerValue;
        }
        if (headerValue instanceof Double) {
            return headerValue;
        }
        if (headerValue instanceof Float) {
            return headerValue;
        }
        if (headerValue instanceof Long) {
            return headerValue;
        }
        return null;
    }
}

