/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.dsl.component.ComponentDslBuilderFactoryGenerator;
import org.apache.camel.maven.packaging.dsl.component.ComponentsBuilderFactoryGenerator;
import org.apache.camel.maven.packaging.dsl.component.ComponentsDslMetadataRegistry;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generate-component-dsl", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class ComponentDslMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${project.basedir}")
    protected File baseDir;
    @Parameter
    protected File sourcesOutputDir;
    @Parameter
    protected File componentsMetadata;
    @Parameter
    protected File outputResourcesDir;
    @Parameter(defaultValue="org.apache.camel.builder.component")
    protected String componentsDslPackageName;
    @Parameter(defaultValue="org.apache.camel.builder.component.dsl")
    protected String componentsDslFactoriesPackageName;
    @Parameter(defaultValue="${project.build.directory}/../../../catalog/camel-catalog/src/generated/resources/org/apache/camel/catalog/components")
    protected File jsonDir;
    private transient String licenseHeader;

    @Override
    public void execute(MavenProject project, MavenProjectHelper projectHelper, BuildContext buildContext) throws MojoFailureException, MojoExecutionException {
        this.buildDir = new File(project.getBuild().getDirectory());
        this.baseDir = project.getBasedir();
        this.componentsDslPackageName = "org.apache.camel.builder.component";
        this.componentsDslFactoriesPackageName = "org.apache.camel.builder.component.dsl";
        super.execute(project, projectHelper, buildContext);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File camelDir = PackageHelper.findCamelDirectory((File)this.baseDir, (String)"dsl/camel-componentdsl");
        if (camelDir == null) {
            this.getLog().debug((CharSequence)"No dsl/camel-componentdsl folder found, skipping execution");
            return;
        }
        Path root = camelDir.toPath();
        if (this.sourcesOutputDir == null) {
            this.sourcesOutputDir = root.resolve("src/generated/java").toFile();
        }
        if (this.outputResourcesDir == null) {
            this.outputResourcesDir = root.resolve("src/generated/resources").toFile();
        }
        if (this.componentsMetadata == null) {
            this.componentsMetadata = this.outputResourcesDir.toPath().resolve("metadata.json").toFile();
        }
        ArrayList<ComponentModel> models = new ArrayList<ComponentModel>();
        for (File file : this.jsonDir.listFiles()) {
            BaseModel model = JsonMapper.generateModel((Path)file.toPath());
            models.add((ComponentModel)model);
        }
        models.sort((o1, o2) -> o1.getScheme().compareToIgnoreCase(o2.getScheme()));
        this.executeComponent(models);
    }

    private void executeComponent(List<ComponentModel> allModels) throws MojoFailureException {
        if (!allModels.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + allModels.size() + " components"));
            try (InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("license-header-java.txt");){
                this.licenseHeader = PackageHelper.loadText((InputStream)is);
            }
            catch (Exception e) {
                throw new MojoFailureException("Error loading license-header-java.txt file", (Throwable)e);
            }
            for (ComponentModel model : allModels) {
                this.createComponentDsl(model);
            }
        }
    }

    private void createComponentDsl(ComponentModel model) throws MojoFailureException {
        ComponentDslBuilderFactoryGenerator componentDslBuilderFactoryGenerator = this.syncAndGenerateSpecificComponentsBuilderFactories(model);
        ComponentsDslMetadataRegistry componentsDslMetadataRegistry = this.syncAndUpdateComponentsMetadataRegistry(model, componentDslBuilderFactoryGenerator.getGeneratedClassName());
        TreeSet<ComponentModel> componentCachedModels = new TreeSet<ComponentModel>(Comparator.comparing(ComponentModel::getScheme));
        componentCachedModels.addAll(componentsDslMetadataRegistry.getComponentCacheFromMemory().values());
        this.syncAndGenerateComponentsBuilderFactories(componentCachedModels);
    }

    private ComponentDslBuilderFactoryGenerator syncAndGenerateSpecificComponentsBuilderFactories(ComponentModel componentModel) throws MojoFailureException {
        ComponentDslBuilderFactoryGenerator componentDslBuilderFactoryGenerator = ComponentDslBuilderFactoryGenerator.generateClass(componentModel, this.getProjectClassLoader(), this.componentsDslPackageName);
        boolean updated = this.writeSourceIfChanged(componentDslBuilderFactoryGenerator.printClassAsString(), this.componentsDslFactoriesPackageName.replace('.', '/'), componentDslBuilderFactoryGenerator.getGeneratedClassName() + ".java", this.sourcesOutputDir);
        if (updated) {
            this.getLog().info((CharSequence)("Updated ComponentDsl: " + componentModel.getScheme()));
        }
        return componentDslBuilderFactoryGenerator;
    }

    private ComponentsDslMetadataRegistry syncAndUpdateComponentsMetadataRegistry(ComponentModel componentModel, String className) {
        ComponentsDslMetadataRegistry componentsDslMetadataRegistry = new ComponentsDslMetadataRegistry(this.sourcesOutputDir.toPath().resolve(this.componentsDslFactoriesPackageName.replace('.', '/')).toFile(), this.componentsMetadata);
        boolean updated = componentsDslMetadataRegistry.addComponentToMetadataAndSyncMetadataFile(componentModel, className);
        if (updated) {
            this.getLog().info((CharSequence)("Updated ComponentDsl metadata: " + componentModel.getScheme()));
        }
        return componentsDslMetadataRegistry;
    }

    private void syncAndGenerateComponentsBuilderFactories(Set<ComponentModel> componentCachedModels) throws MojoFailureException {
        ComponentsBuilderFactoryGenerator componentsBuilderFactoryGenerator = ComponentsBuilderFactoryGenerator.generateClass(componentCachedModels, this.getProjectClassLoader(), this.componentsDslPackageName);
        boolean updated = this.writeSourceIfChanged(componentsBuilderFactoryGenerator.printClassAsString(), this.componentsDslPackageName.replace('.', '/'), componentsBuilderFactoryGenerator.getGeneratedClassName() + ".java", this.sourcesOutputDir);
        if (updated) {
            this.getLog().info((CharSequence)("Updated " + componentCachedModels.size() + " ComponentDsl factories"));
        }
    }

    protected boolean writeSourceIfChanged(String source, String filePath, String fileName, File outputDir) throws MojoFailureException {
        Path target = outputDir.toPath().resolve(filePath).resolve(fileName);
        try {
            String code = this.licenseHeader + source;
            this.getLog().debug((CharSequence)("Source code generated:\n" + code));
            return ComponentDslMojo.updateResource(this.buildContext, target, code);
        }
        catch (Exception e) {
            throw new MojoFailureException("IOError with file " + target, (Throwable)e);
        }
    }
}

