/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp.impl;

import java.io.IOException;
import java.net.Socket;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Route;
import org.apache.camel.component.mllp.MllpAcknowledgementDeliveryException;
import org.apache.camel.component.mllp.MllpException;
import org.apache.camel.component.mllp.MllpInvalidAcknowledgementException;
import org.apache.camel.component.mllp.impl.MllpUtil;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.processor.mllp.Hl7AcknowledgementGenerationException;
import org.apache.camel.processor.mllp.Hl7AcknowledgementGenerator;
import org.apache.camel.support.SynchronizationAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcknowledgmentSynchronizationAdapter
extends SynchronizationAdapter {
    Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    final byte[] originalHl7MessageBytes;
    Hl7AcknowledgementGenerator acknowledgementGenerator = new Hl7AcknowledgementGenerator();
    private Socket clientSocket;

    public AcknowledgmentSynchronizationAdapter(Socket clientSocket, byte[] hl7MessageBytes) {
        this.clientSocket = clientSocket;
        this.originalHl7MessageBytes = hl7MessageBytes;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void onAfterRoute(Route route, Exchange exchange) {
        String acknowledgementMessageType;
        byte[] acknowledgementMessageBytes;
        block32: {
            this.log.info("onAfterRoute");
            if (((Boolean)exchange.getProperty("CamelMllpResetConnectionBeforeSend", Boolean.TYPE)).booleanValue()) {
                MllpUtil.resetConnection(this.clientSocket);
                return;
            }
            if (((Boolean)exchange.getProperty("CamelMllpCloseConnectionBeforeSend", Boolean.TYPE)).booleanValue()) {
                MllpUtil.closeConnection(this.clientSocket);
                return;
            }
            acknowledgementMessageBytes = (byte[])exchange.getProperty("CamelMllpAcknowledgement", byte[].class);
            acknowledgementMessageType = null;
            if (null == acknowledgementMessageBytes) {
                boolean autoAck = (Boolean)exchange.getProperty("CamelMllpAutoAcknowledge", (Object)true, Boolean.TYPE);
                if (!autoAck) {
                    exchange.setException((Throwable)new MllpInvalidAcknowledgementException("Automatic Acknowledgement is disabled and the CamelMllpAcknowledgement exchange property is null or cannot be converted to byte[]", this.originalHl7MessageBytes, acknowledgementMessageBytes));
                    return;
                }
                String acknowledgmentTypeProperty = (String)exchange.getProperty("CamelMllpAcknowledgementType", String.class);
                try {
                    if (null == acknowledgmentTypeProperty) {
                        if (null == exchange.getException()) {
                            acknowledgementMessageType = "AA";
                            acknowledgementMessageBytes = this.acknowledgementGenerator.generateApplicationAcceptAcknowledgementMessage(this.originalHl7MessageBytes);
                        } else {
                            acknowledgementMessageType = "AE";
                            acknowledgementMessageBytes = this.acknowledgementGenerator.generateApplicationErrorAcknowledgementMessage(this.originalHl7MessageBytes);
                        }
                        break block32;
                    }
                    switch (acknowledgmentTypeProperty) {
                        case "AA": {
                            acknowledgementMessageType = "AA";
                            acknowledgementMessageBytes = this.acknowledgementGenerator.generateApplicationAcceptAcknowledgementMessage(this.originalHl7MessageBytes);
                            break;
                        }
                        case "AE": {
                            acknowledgementMessageType = "AE";
                            acknowledgementMessageBytes = this.acknowledgementGenerator.generateApplicationErrorAcknowledgementMessage(this.originalHl7MessageBytes);
                            break;
                        }
                        case "AR": {
                            acknowledgementMessageType = "AR";
                            acknowledgementMessageBytes = this.acknowledgementGenerator.generateApplicationRejectAcknowledgementMessage(this.originalHl7MessageBytes);
                            break;
                        }
                        default: {
                            exchange.setException((Throwable)new Hl7AcknowledgementGenerationException("Unsupported acknowledgment type: " + acknowledgmentTypeProperty));
                            return;
                        }
                    }
                }
                catch (Hl7AcknowledgementGenerationException ackGenerationException) {
                    exchange.setProperty("CamelMllpAcknowledgementException", (Object)ackGenerationException);
                    exchange.setException((Throwable)ackGenerationException);
                }
            } else {
                int bM = 77;
                int bS = 83;
                int bA = 65;
                int bE = 69;
                int bR = 82;
                byte fieldSeparator = this.originalHl7MessageBytes[3];
                for (int i = 0; i < this.originalHl7MessageBytes.length; ++i) {
                    String acknowledgementTypeProperty;
                    if (13 != i || i + 7 >= this.originalHl7MessageBytes.length || 77 != this.originalHl7MessageBytes[i + 1] || 83 != this.originalHl7MessageBytes[i + 2] || 65 != this.originalHl7MessageBytes[i + 3] || fieldSeparator != this.originalHl7MessageBytes[i + 4]) continue;
                    if (fieldSeparator != this.originalHl7MessageBytes[i + 7]) {
                        this.log.warn("MSA-1 is longer than 2-bytes - ignoring trailing bytes");
                    }
                    byte[] acknowledgmentTypeBytes = new byte[]{this.originalHl7MessageBytes[i + 5], this.originalHl7MessageBytes[i + 6]};
                    try {
                        acknowledgementMessageType = IOConverter.toString((byte[])acknowledgmentTypeBytes, (Exchange)exchange);
                    }
                    catch (IOException ioEx) {
                        throw new RuntimeException("Failed to convert acknowledgement message to string", ioEx);
                    }
                    if (65 != acknowledgmentTypeBytes[0]) {
                        switch (acknowledgementMessageBytes[1]) {
                            case 65: 
                            case 69: 
                            case 82: {
                                break;
                            }
                            default: {
                                this.log.warn("Invalid acknowledgement type [" + acknowledgementMessageType + "] found in message - should be AA, AE or AR");
                            }
                        }
                    }
                    if (null == (acknowledgementTypeProperty = (String)exchange.getProperty("CamelMllpAcknowledgementType", String.class)) || acknowledgementTypeProperty.equals(acknowledgementMessageType)) continue;
                    this.log.warn("Acknowledgement type found in message [" + acknowledgementMessageType + "] does not match " + "CamelMllpAcknowledgementType" + " exchange property value [" + acknowledgementTypeProperty + "] - using value found in message");
                }
            }
        }
        Message message = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        message.setHeader("CamelMllpAcknowledgement", (Object)acknowledgementMessageBytes);
        message.setHeader("CamelMllpAcknowledgementType", (Object)acknowledgementMessageType);
        this.log.debug("Sending Acknowledgement");
        try {
            MllpUtil.writeFramedPayload(this.clientSocket, acknowledgementMessageBytes);
        }
        catch (MllpException mllpEx) {
            this.log.error("MLLP Acknowledgement failure: {}", (Throwable)mllpEx);
            MllpAcknowledgementDeliveryException deliveryException = new MllpAcknowledgementDeliveryException(this.originalHl7MessageBytes, acknowledgementMessageBytes, mllpEx);
            exchange.setProperty("CamelMllpAcknowledgementException", (Object)deliveryException);
            exchange.setException((Throwable)deliveryException);
        }
        if (((Boolean)exchange.getProperty("CamelMllpResetConnectionAfterSend", Boolean.TYPE)).booleanValue()) {
            MllpUtil.resetConnection(this.clientSocket);
            return;
        }
        if (((Boolean)exchange.getProperty("CamelMllpCloseConnectionAfterSend", Boolean.TYPE)).booleanValue()) {
            MllpUtil.closeConnection(this.clientSocket);
        }
        super.onAfterRoute(route, exchange);
    }

    public void onComplete(Exchange exchange) {
        this.log.info("onComplete");
        super.onComplete(exchange);
    }

    public void onFailure(Exchange exchange) {
        this.log.warn("onFailure");
        super.onFailure(exchange);
    }
}

