/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import org.apache.camel.component.mllp.MllpException;

public class MllpTimeoutException
extends MllpException {
    private final byte[] hl7Message;

    public MllpTimeoutException(String message, byte[] hl7Message) {
        super(message);
        this.hl7Message = hl7Message;
    }

    public MllpTimeoutException(String message, byte[] hl7Message, Throwable cause) {
        super(message, cause);
        this.hl7Message = hl7Message;
    }

    public byte[] getHl7Message() {
        return this.hl7Message;
    }

    @Override
    public String getMessage() {
        if (this.isLogPhi()) {
            return String.format("%s:\n\tHL7 Message: %s", super.getMessage(), this.covertBytesToPrintFriendlyString(this.hl7Message));
        }
        return super.getMessage();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName());
        stringBuilder.append(": {hl7Message=").append(this.covertBytesToPrintFriendlyString(this.hl7Message)).append("}");
        return stringBuilder.toString();
    }
}

