/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.mllp.MllpEndpoint;
import org.apache.camel.component.mllp.MllpException;
import org.apache.camel.component.mllp.impl.AcknowledgmentSynchronizationAdapter;
import org.apache.camel.component.mllp.impl.MllpUtil;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.processor.mllp.Hl7AcknowledgementGenerator;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.IOHelper;

public class MllpTcpServerConsumer
extends DefaultConsumer {
    ServerSocketThread serverSocketThread;
    List<ClientSocketThread> clientThreads = new LinkedList<ClientSocketThread>();
    private final MllpEndpoint endpoint;

    public MllpTcpServerConsumer(MllpEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.log.trace("MllpTcpServerConsumer(endpoint, processor)");
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        this.log.debug("doStart() - creating acceptor thread");
        ServerSocket serverSocket = new ServerSocket();
        if (null != this.endpoint.receiveBufferSize) {
            serverSocket.setReceiveBufferSize(this.endpoint.receiveBufferSize);
        }
        serverSocket.setReuseAddress(this.endpoint.reuseAddress);
        serverSocket.setSoTimeout(this.endpoint.acceptTimeout);
        InetSocketAddress socketAddress = null == this.endpoint.getHostname() ? new InetSocketAddress(this.endpoint.getPort()) : new InetSocketAddress(this.endpoint.getHostname(), this.endpoint.getPort());
        long startTicks = System.currentTimeMillis();
        do {
            try {
                serverSocket.bind(socketAddress, this.endpoint.backlog);
            }
            catch (BindException bindException) {
                if (System.currentTimeMillis() > startTicks + (long)this.endpoint.getBindTimeout()) {
                    this.log.error("Failed to bind to address {} within timeout {}", (Object)socketAddress, (Object)this.endpoint.getBindTimeout());
                    throw bindException;
                }
                this.log.warn("Failed to bind to address {} - retrying in {} milliseconds", (Object)socketAddress, (Object)this.endpoint.getBindRetryInterval());
                Thread.sleep(this.endpoint.getBindRetryInterval());
            }
        } while (!serverSocket.isBound());
        this.serverSocketThread = new ServerSocketThread(serverSocket);
        this.serverSocketThread.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.log.debug("doStop()");
        for (ClientSocketThread clientSocketThread : this.clientThreads) {
            clientSocketThread.interrupt();
        }
        switch (this.serverSocketThread.getState()) {
            case TERMINATED: {
                break;
            }
            default: {
                this.serverSocketThread.interrupt();
            }
        }
        this.serverSocketThread = null;
        super.doStop();
    }

    class ClientSocketThread
    extends Thread {
        Socket clientSocket;
        Hl7AcknowledgementGenerator acknowledgementGenerator = new Hl7AcknowledgementGenerator();
        Integer initialByte;

        ClientSocketThread(Socket clientSocket, Integer initialByte) throws IOException {
            this.initialByte = initialByte;
            this.setName(this.createThreadName(clientSocket));
            this.clientSocket = clientSocket;
            this.clientSocket.setKeepAlive(((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.keepAlive);
            this.clientSocket.setTcpNoDelay(((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.tcpNoDelay);
            if (null != ((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.receiveBufferSize) {
                this.clientSocket.setReceiveBufferSize(((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.receiveBufferSize);
            }
            if (null != ((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.sendBufferSize) {
                this.clientSocket.setSendBufferSize(((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.sendBufferSize);
            }
            this.clientSocket.setReuseAddress(((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.reuseAddress);
            this.clientSocket.setSoLinger(false, -1);
            this.clientSocket.setSoTimeout(((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.receiveTimeout);
        }

        String createThreadName(Socket socket) {
            String fullClassName = this.getClass().getName();
            String className = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
            String fullEndpointKey = MllpTcpServerConsumer.this.endpoint.getEndpointKey();
            String endpointKey = fullEndpointKey.contains("?") ? fullEndpointKey.substring(0, fullEndpointKey.indexOf(63)) : fullEndpointKey;
            return String.format("%s[%s] - %s -> %s", className, endpointKey, socket.getLocalSocketAddress(), socket.getRemoteSocketAddress());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int receiveTimeoutCounter = 0;
            while (!this.isInterrupted() && null != this.clientSocket && this.clientSocket.isConnected() && !this.clientSocket.isClosed()) {
                byte[] hl7MessageBytes;
                block16: {
                    hl7MessageBytes = null;
                    MllpTcpServerConsumer.this.log.debug("Reading data ....");
                    try {
                        block18: {
                            block17: {
                                if (null != this.initialByte && 11 == this.initialByte) {
                                    hl7MessageBytes = MllpUtil.closeFrame(this.clientSocket, ((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.receiveTimeout, ((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.readTimeout);
                                    break block16;
                                }
                                if (MllpUtil.openFrame(this.clientSocket, ((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.receiveTimeout, ((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.readTimeout)) break block17;
                                receiveTimeoutCounter = 0;
                            }
                            try {
                                receiveTimeoutCounter = 0;
                                break block18;
                            }
                            catch (SocketTimeoutException timeoutEx) {
                                if (((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.maxReceiveTimeouts > 0 && ++receiveTimeoutCounter >= ((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.maxReceiveTimeouts) {
                                    MllpTcpServerConsumer.this.log.warn("Idle Client - resetting connection");
                                    MllpUtil.resetConnection(this.clientSocket);
                                }
                                this.initialByte = null;
                            }
                            continue;
                        }
                        hl7MessageBytes = MllpUtil.closeFrame(this.clientSocket, ((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.receiveTimeout, ((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.readTimeout);
                    }
                    catch (MllpException mllpEx) {
                        Exchange exchange = MllpTcpServerConsumer.this.endpoint.createExchange(ExchangePattern.InOut);
                        exchange.setException((Throwable)mllpEx);
                        return;
                    }
                    finally {
                        this.initialByte = null;
                        continue;
                    }
                }
                if (null == hl7MessageBytes) continue;
                MllpTcpServerConsumer.this.log.debug("Populating the exchange with received message");
                Exchange exchange = MllpTcpServerConsumer.this.endpoint.createExchange(ExchangePattern.InOut);
                Message message = exchange.getIn();
                message.setBody((Object)hl7MessageBytes, byte[].class);
                message.setHeader("CamelMllpLocalAddress", (Object)this.clientSocket.getLocalAddress().toString());
                message.setHeader("CamelMllpRemoteAddress", (Object)this.clientSocket.getRemoteSocketAddress());
                message.setHeader("CamelMllpAutoAcknowledge", (Object)((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.autoAck);
                this.populateHl7DataHeaders(exchange, message, hl7MessageBytes);
                exchange.addOnCompletion((Synchronization)new AcknowledgmentSynchronizationAdapter(this.clientSocket, hl7MessageBytes));
                MllpTcpServerConsumer.this.log.debug("Calling processor");
                try {
                    MllpTcpServerConsumer.this.getProcessor().process(exchange);
                }
                catch (RuntimeException runtimeEx) {
                    throw runtimeEx;
                }
                catch (Exception ex) {
                    MllpTcpServerConsumer.this.log.error("Unexpected exception processing exchange", (Throwable)ex);
                    throw new RuntimeException("Unexpected exception processing exchange", ex);
                }
            }
            MllpTcpServerConsumer.this.log.debug("ClientSocketThread exiting");
        }

        private void populateHl7DataHeaders(Exchange exchange, Message message, byte[] hl7MessageBytes) {
            byte fieldSeparator = hl7MessageBytes[3];
            int endOfMSH = -1;
            ArrayList<Integer> fieldSeparatorIndexes = new ArrayList<Integer>(10);
            for (int i = 0; i < hl7MessageBytes.length; ++i) {
                if (fieldSeparator == hl7MessageBytes[i]) {
                    fieldSeparatorIndexes.add(i);
                    continue;
                }
                if (13 != hl7MessageBytes[i]) continue;
                if (fieldSeparator != hl7MessageBytes[i - 1]) {
                    fieldSeparatorIndexes.add(i);
                }
                endOfMSH = i;
                break;
            }
            String messageBodyForDebugging = new String(hl7MessageBytes);
            if (-1 == endOfMSH) {
                MllpTcpServerConsumer.this.log.error("Population of message headers failed - unable to find the end of the MSH segment");
            } else if (((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.hl7Headers) {
                MllpTcpServerConsumer.this.log.debug("Populating the HL7 message headers");
                Charset charset = Charset.forName(IOHelper.getCharsetName((Exchange)exchange));
                block14: for (int i = 2; i < fieldSeparatorIndexes.size(); ++i) {
                    int startingFieldSeparatorIndex = (Integer)fieldSeparatorIndexes.get(i - 1);
                    int endingFieldSeparatorIndex = (Integer)fieldSeparatorIndexes.get(i);
                    if (endingFieldSeparatorIndex - startingFieldSeparatorIndex <= 1) continue;
                    String headerName = null;
                    switch (i) {
                        case 2: {
                            headerName = "CamelMllpSendingApplication";
                            break;
                        }
                        case 3: {
                            headerName = "CamelMllpSendingFacility";
                            break;
                        }
                        case 4: {
                            headerName = "CamelMllpReceivingApplication";
                            break;
                        }
                        case 5: {
                            headerName = "CamelMllpReceivingFacility";
                            break;
                        }
                        case 6: {
                            headerName = "CamelMllpTimestamp";
                            break;
                        }
                        case 7: {
                            headerName = "CamelMllpSecurity";
                            break;
                        }
                        case 8: {
                            headerName = "CamelMllpMessageType";
                            break;
                        }
                        case 9: {
                            headerName = "CamelMllpMessageControlId";
                            break;
                        }
                        case 10: {
                            headerName = "CamelMllpProcessingId";
                            break;
                        }
                        case 11: {
                            headerName = "CamelMllpVersionId";
                            break;
                        }
                        case 17: {
                            headerName = "CamelMllpCharset";
                            break;
                        }
                        default: {
                            continue block14;
                        }
                    }
                    String headerValue = new String(hl7MessageBytes, startingFieldSeparatorIndex + 1, endingFieldSeparatorIndex - startingFieldSeparatorIndex - 1, charset);
                    message.setHeader(headerName, (Object)headerValue);
                    if (i != 8) continue;
                    String componentSeparator = new String(hl7MessageBytes, 4, 1, charset);
                    String[] components = headerValue.split(String.format("\\Q%s\\E", componentSeparator), 3);
                    message.setHeader("CamelMllpEventType", (Object)components[0]);
                    if (2 > components.length) continue;
                    message.setHeader("CamelMllpTriggerEvent", (Object)components[1]);
                }
            } else {
                MllpTcpServerConsumer.this.log.trace("HL7 Message headers disabled");
            }
        }

        @Override
        public void interrupt() {
            if (null != this.clientSocket && this.clientSocket.isConnected() && !this.clientSocket.isClosed()) {
                try {
                    this.clientSocket.close();
                }
                catch (IOException ex) {
                    MllpTcpServerConsumer.this.log.warn("Exception encoutered closing client Socket in interrupt", (Throwable)ex);
                }
            }
            super.interrupt();
        }
    }

    class ServerSocketThread
    extends Thread {
        ServerSocket serverSocket;

        ServerSocketThread(ServerSocket serverSocket) {
            this.setName(this.createThreadName(serverSocket));
            this.serverSocket = serverSocket;
        }

        String createThreadName(ServerSocket serverSocket) {
            String fullClassName = this.getClass().getName();
            String className = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
            String fullEndpointKey = MllpTcpServerConsumer.this.endpoint.getEndpointKey();
            String endpointKey = fullEndpointKey.contains("?") ? fullEndpointKey.substring(0, fullEndpointKey.indexOf(63)) : fullEndpointKey;
            return String.format("%s[%s] - %s", className, endpointKey, serverSocket.getLocalSocketAddress());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            MllpTcpServerConsumer.this.log.debug("Starting acceptor thread");
            try {
                while (!this.isInterrupted() && null != this.serverSocket && this.serverSocket.isBound() && !this.serverSocket.isClosed()) {
                    Socket socket = null;
                    try {
                        socket = this.serverSocket.accept();
                    }
                    catch (SocketTimeoutException timeoutEx) {
                        MllpTcpServerConsumer.this.log.debug("Timeout waiting for client connection - keep listening");
                        continue;
                    }
                    catch (SocketException socketEx) {
                        if (!this.serverSocket.isBound()) continue;
                        try {
                            this.serverSocket.close();
                            continue;
                        }
                        catch (Exception ex) {
                            MllpTcpServerConsumer.this.log.debug("Exception encountered closing ServerSocket after SocketException on accept() - ignoring", (Throwable)ex);
                            continue;
                        }
                    }
                    catch (IOException ioEx) {
                        MllpTcpServerConsumer.this.log.error("Exception encountered accepting connection - closing ServerSocket", (Throwable)ioEx);
                        if (!this.serverSocket.isBound()) continue;
                        try {
                            this.serverSocket.close();
                            continue;
                        }
                        catch (Exception ex) {
                            MllpTcpServerConsumer.this.log.debug("Exception encountered closing ServerSocket after exception on accept() - ignoring", (Throwable)ex);
                            continue;
                        }
                    }
                    try {
                        ClientSocketThread clientThread;
                        InputStream inputStream;
                        Thread.sleep(100L);
                        if (!socket.isConnected() || socket.isClosed()) continue;
                        MllpTcpServerConsumer.this.log.debug("Socket appears to be there - check for available data");
                        try {
                            inputStream = socket.getInputStream();
                        }
                        catch (IOException ioEx) {
                            MllpTcpServerConsumer.this.log.warn("Failed to retrieve the InputStream for socket after the initial connection was accepted");
                            MllpUtil.resetConnection(socket);
                            continue;
                        }
                        if (0 < inputStream.available()) {
                            ClientSocketThread clientThread2 = new ClientSocketThread(socket, null);
                            MllpTcpServerConsumer.this.clientThreads.add(clientThread2);
                            clientThread2.start();
                            continue;
                        }
                        socket.setSoTimeout(100);
                        try {
                            int tmpByte = inputStream.read();
                            socket.setSoTimeout(((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.receiveTimeout);
                            if (-1 == tmpByte) {
                                MllpTcpServerConsumer.this.log.debug("Socket.read() returned END_OF_STREAM - resetting connection");
                                MllpUtil.resetConnection(socket);
                                continue;
                            }
                            clientThread = new ClientSocketThread(socket, tmpByte);
                            MllpTcpServerConsumer.this.clientThreads.add(clientThread);
                            clientThread.start();
                        }
                        catch (SocketTimeoutException timeoutEx) {
                            MllpTcpServerConsumer.this.log.debug("No Data - but the socket is there.  Starting ClientSocketThread");
                            clientThread = new ClientSocketThread(socket, null);
                            MllpTcpServerConsumer.this.clientThreads.add(clientThread);
                            clientThread.start();
                        }
                    }
                    catch (SocketTimeoutException timeoutEx) {
                        MllpTcpServerConsumer.this.log.trace("SocketTimeoutException waiting for new connections - no new connections");
                        for (int i = MllpTcpServerConsumer.this.clientThreads.size() - 1; i >= 0; --i) {
                            ClientSocketThread thread = MllpTcpServerConsumer.this.clientThreads.get(i);
                            if (thread.isAlive()) continue;
                            MllpTcpServerConsumer.this.clientThreads.remove(i);
                        }
                    }
                    catch (InterruptedException interruptEx) {
                        MllpTcpServerConsumer.this.log.debug("accept loop interrupted - closing ServerSocket");
                        try {
                            this.serverSocket.close();
                        }
                        catch (Exception ex) {
                            MllpTcpServerConsumer.this.log.debug("Exception encountered closing ServerSocket after InterruptedException - ignoring", (Throwable)ex);
                        }
                    }
                    catch (Exception ex) {
                        MllpTcpServerConsumer.this.log.error("Exception accepting new connection - retrying", (Throwable)ex);
                    }
                }
                return;
            }
            finally {
                MllpTcpServerConsumer.this.log.debug("ServerSocket.accept loop finished - closing listener");
                if (null != this.serverSocket && this.serverSocket.isBound() && !this.serverSocket.isClosed()) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (Exception ex) {
                        MllpTcpServerConsumer.this.log.debug("Exception encountered closing ServerSocket after accept loop had exited - ignoring", (Throwable)ex);
                    }
                }
            }
        }

        @Override
        public void interrupt() {
            super.interrupt();
            if (null != this.serverSocket && this.serverSocket.isBound()) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException ioEx) {
                    MllpTcpServerConsumer.this.log.warn("Exception encountered closing ServerSocket in interrupt() method - ignoring", (Throwable)ioEx);
                }
            }
        }
    }
}

