/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.mllp.MllpAcknowledgementTimoutException;
import org.apache.camel.component.mllp.MllpApplicationErrorAcknowledgementException;
import org.apache.camel.component.mllp.MllpApplicationRejectAcknowledgementException;
import org.apache.camel.component.mllp.MllpCommitErrorAcknowledgementException;
import org.apache.camel.component.mllp.MllpCommitRejectAcknowledgementException;
import org.apache.camel.component.mllp.MllpEndpoint;
import org.apache.camel.component.mllp.MllpException;
import org.apache.camel.component.mllp.MllpInvalidAcknowledgementException;
import org.apache.camel.component.mllp.impl.MllpUtil;
import org.apache.camel.impl.DefaultProducer;

public class MllpTcpClientProducer
extends DefaultProducer {
    MllpEndpoint endpoint;
    Socket socket;

    public MllpTcpClientProducer(MllpEndpoint endpoint) throws SocketException {
        super((Endpoint)endpoint);
        this.log.trace("MllpTcpClientProducer(endpoint)");
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        this.log.trace("doStart()");
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.log.trace("doStop()");
        MllpUtil.closeConnection(this.socket);
        super.doStop();
    }

    public void process(Exchange exchange) throws Exception {
        Exception connectionException;
        this.log.trace("process(exchange)");
        if (((Boolean)exchange.getProperty("CamelMllpResetConnectionBeforeSend", Boolean.TYPE)).booleanValue()) {
            MllpUtil.resetConnection(this.socket);
            return;
        }
        if (((Boolean)exchange.getProperty("CamelMllpCloseConnectionBeforeSend", Boolean.TYPE)).booleanValue()) {
            MllpUtil.closeConnection(this.socket);
        }
        if (null != (connectionException = this.checkConnection())) {
            exchange.setException((Throwable)connectionException);
            return;
        }
        Message message = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        byte[] hl7MessageBytes = (byte[])message.getMandatoryBody(byte[].class);
        this.log.debug("Sending message to external system");
        try {
            MllpUtil.writeFramedPayload(this.socket, hl7MessageBytes);
        }
        catch (MllpException mllpEx) {
            exchange.setException((Throwable)mllpEx);
            return;
        }
        this.log.debug("Reading acknowledgement from external system");
        byte[] acknowledgementBytes = null;
        try {
            if (MllpUtil.openFrame(this.socket, this.endpoint.receiveTimeout, this.endpoint.readTimeout)) {
                acknowledgementBytes = MllpUtil.closeFrame(this.socket, this.endpoint.receiveTimeout, this.endpoint.readTimeout);
            }
        }
        catch (SocketTimeoutException timeoutEx) {
            exchange.setException((Throwable)new MllpAcknowledgementTimoutException("Acknowledgement timout", hl7MessageBytes, timeoutEx));
            return;
        }
        catch (MllpException mllpEx) {
            exchange.setException((Throwable)mllpEx);
            return;
        }
        if (null != acknowledgementBytes) {
            this.log.debug("Populating the exchange with the acknowledgement from the external system");
            message.setHeader("CamelMllpAcknowledgement", (Object)acknowledgementBytes);
            message.setHeader("CamelMllpLocalAddress", (Object)this.socket.getLocalAddress().toString());
            message.setHeader("CamelMllpRemoteAddress", (Object)this.socket.getRemoteSocketAddress());
            byte fieldDelim = acknowledgementBytes[3];
            int msaStartIndex = -1;
            for (int i = 0; i < acknowledgementBytes.length; ++i) {
                if (13 != acknowledgementBytes[i]) continue;
                int bM = 77;
                int bS = 83;
                int bC = 67;
                int bA = 65;
                int bE = 69;
                int bR = 82;
                if (acknowledgementBytes.length <= i + 7 || 77 != acknowledgementBytes[i + 1] || 83 != acknowledgementBytes[i + 2] || 65 != acknowledgementBytes[i + 3] || fieldDelim != acknowledgementBytes[i + 4]) continue;
                msaStartIndex = i + 1;
                if (65 != acknowledgementBytes[i + 5] && 67 != acknowledgementBytes[i + 5]) {
                    exchange.setException((Throwable)new MllpInvalidAcknowledgementException(new String(acknowledgementBytes, i + 5, 2), hl7MessageBytes, acknowledgementBytes));
                    break;
                }
                switch (acknowledgementBytes[i + 6]) {
                    case 65: {
                        if (fieldDelim != acknowledgementBytes[i + 7]) {
                            exchange.setException((Throwable)new MllpInvalidAcknowledgementException(new String(acknowledgementBytes, i + 5, 3), hl7MessageBytes, acknowledgementBytes));
                        }
                        if (65 == acknowledgementBytes[i + 5]) {
                            message.setHeader("CamelMllpAcknowledgementType", (Object)"AA");
                            break;
                        }
                        message.setHeader("CamelMllpAcknowledgementType", (Object)"CA");
                        break;
                    }
                    case 69: {
                        if (65 == acknowledgementBytes[i + 5]) {
                            message.setHeader("CamelMllpAcknowledgementType", (Object)"AE");
                            exchange.setException((Throwable)new MllpApplicationErrorAcknowledgementException(hl7MessageBytes, acknowledgementBytes));
                            break;
                        }
                        message.setHeader("CamelMllpAcknowledgementType", (Object)"CE");
                        exchange.setException((Throwable)new MllpCommitErrorAcknowledgementException(hl7MessageBytes, acknowledgementBytes));
                        break;
                    }
                    case 82: {
                        if (65 == acknowledgementBytes[i + 5]) {
                            message.setHeader("CamelMllpAcknowledgementType", (Object)"AR");
                            exchange.setException((Throwable)new MllpApplicationRejectAcknowledgementException(hl7MessageBytes, acknowledgementBytes));
                            break;
                        }
                        message.setHeader("CamelMllpAcknowledgementType", (Object)"CR");
                        exchange.setException((Throwable)new MllpCommitRejectAcknowledgementException(hl7MessageBytes, acknowledgementBytes));
                        break;
                    }
                    default: {
                        exchange.setException((Throwable)new MllpInvalidAcknowledgementException(new String(acknowledgementBytes, i + 5, 2), hl7MessageBytes, acknowledgementBytes));
                        break;
                    }
                }
                break;
            }
            if (-1 == msaStartIndex) {
                exchange.setException((Throwable)new MllpInvalidAcknowledgementException("MSA Not found in acknowledgement", hl7MessageBytes, acknowledgementBytes));
            }
        }
        if (((Boolean)exchange.getProperty("CamelMllpResetConnectionAfterSend", Boolean.TYPE)).booleanValue()) {
            MllpUtil.resetConnection(this.socket);
            return;
        }
        if (((Boolean)exchange.getProperty("CamelMllpCloseConnectionAfterSend", Boolean.TYPE)).booleanValue()) {
            MllpUtil.closeConnection(this.socket);
        }
    }

    Exception checkConnection() {
        if (null == this.socket || this.socket.isClosed() || !this.socket.isConnected()) {
            this.socket = new Socket();
            try {
                this.socket.setKeepAlive(this.endpoint.keepAlive);
                this.socket.setTcpNoDelay(this.endpoint.tcpNoDelay);
                if (null != this.endpoint.receiveBufferSize) {
                    this.socket.setReceiveBufferSize(this.endpoint.receiveBufferSize);
                }
                if (null != this.endpoint.sendBufferSize) {
                    this.socket.setSendBufferSize(this.endpoint.sendBufferSize);
                }
                this.socket.setReuseAddress(this.endpoint.reuseAddress);
                this.socket.setSoLinger(false, -1);
                this.socket.setSoTimeout(this.endpoint.receiveTimeout);
            }
            catch (SocketException e) {
                return e;
            }
            InetSocketAddress socketAddress = null == this.endpoint.getHostname() ? new InetSocketAddress(this.endpoint.getPort()) : new InetSocketAddress(this.endpoint.getHostname(), this.endpoint.getPort());
            this.log.debug("Connecting to socket on {}", (Object)socketAddress);
            try {
                this.socket.connect(socketAddress, this.endpoint.connectTimeout);
            }
            catch (SocketTimeoutException e) {
                return e;
            }
            catch (IOException e) {
                return e;
            }
        }
        return null;
    }
}

